#ifndef CPPCADES_CPLICENSE_H_
#define CPPCADES_CPLICENSE_H_

#include "cppcades.h"
#include "atlstr.h"

#define CADESCOM_ELEVATED_CALL 1

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPLicenseObject
{
public:
    CPPCadesCPLicenseObject(void);
    ~CPPCadesCPLicenseObject(void);

    HRESULT SetLicense(const CAtlStringW& sSerialNumber, const CAtlStringW& sOwner, const CAtlStringW& sCompany);
    HRESULT SerialNumber(DWORD Product, CAtlString& pVal);
    HRESULT ValidTo(DWORD Product, CAtlString& pVal);
    HRESULT FirstInstallDate(DWORD Product, CAtlString& pVal);
    HRESULT Type(DWORD Product, CAtlString& pVal);
    HRESULT CompanyName(DWORD Product, CAtlString& pVal);
    HRESULT get_IsValid(DWORD Product, DWORD dwFlags, BOOL* pVal);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPLicenseObject);
    void* m_licenseCSP;
    void* m_licenseOCSP;
    void* m_licenseTSP;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CPLICENSE_H_
