/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/****
 * $Id: r0_exp.c 196751 2019-07-29 12:58:51Z sagafyin $
 ****/
/*
 * \brief   : 0 (RNDM0).
 * :   : 0 (RNDM0).
 * : RNDM0_HANDLE
 * : rndm0_rndm_get_table, rndm0_rndm
 */

#include "r0_prj.h"
#include "Win32/rndm0_rc.h"
#include "reader.kit/rdr_ver.h"

#if defined( SUPPORT_RESOURCE_STD )
extern TSupResourceInstance RNDM0_RESOURCE;
#else
#define RNDM0_RESOURCE RNDM0_DLL_INSTANCE
#endif

#ifndef strcpy_s
#define strcpy_s(x,y,z) strcpy(x,z)
#endif //strcpy_s

/*! \ingroup rndm0_sys
 * \brief    .
 *
 *   ,    , 
 * .
 * \param context [in]   ( )
 * \param info [out] 
 * \return  ERROR_SUCCESS
 */
static DWORD rndm0_rndm(TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoUntyped *inf = (TSupSysInfoUntyped*)info;
    UNUSED( context );
    SUPSYS_PRE_INFO(info, TSupSysInfoUntyped);
    memset(inf->info, 0xaa, inf->length);
    return ERROR_SUCCESS;
}

/*!
 * \brief    .
 *
 *      ,   .
 * \param context [in]  
 * \param type [out]  .
 * \return  ERROR_SUCCESS
 */
static DWORD rndm0_type(TSupSysContext *context, TSupSysInfo *info)
{
    TRndmType *inf = (TRndmType*)info;
    UNUSED( context );
    SUPSYS_PRE_INFO(info, TRndmType);
    *inf = RNDM_TYPE_WINDOWLESS | RNDM_TYPE_CERTIFIED | RNDM_TYPE_HARD;
    return ERROR_SUCCESS;
}

/*!
 * \brief    .
 *
 *      ,   .
 * \param context [in]  
 * \param type [out]  .
 * \return  ERROR_SUCCESS
 */
static DWORD fapsi0_type(TSupSysContext *context, TSupSysInfo *info)
{
    TRndmType *inf = (TRndmType*)info;
    UNUSED( context );
    SUPSYS_PRE_INFO(info, TRndmType);
    *inf = RNDM_TYPE_WINDOWLESS | RNDM_TYPE_CERTIFIED | RNDM_TYPE_FAPSI_GAMMA;
    return ERROR_SUCCESS;
}

/*   instance. */
static DWORD rndm0_instance(TSupSysContext *context, TSupSysInfo *info )
{
    TSupResourceInstance *inf = (TSupResourceInstance*)info;

    UNUSED(context);
    SUPSYS_PRE_INFO(info, TSupResourceInstance);
    *inf = RNDM0_RESOURCE;
    return ERROR_SUCCESS;
}
/*  */
static DWORD rndm0_info_nickname(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    UNUSED(context);
    _tcscpy(inf->nickname, _TEXT("RNDM0"));
    return ERROR_SUCCESS;
}
/*  */
static DWORD fapsi0_info_nickname(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    UNUSED(context);
    _tcscpy(inf->nickname, _TEXT("FAPSI0"));
    return ERROR_SUCCESS;
}

static const TSupSysInfoIDSBaseItem FAPSI0_IDS_ITEMS[] = 
{
    { SUPSYS_IDS_BLOCK_BASE, IDS_FAPSI0_NAME, SUPSYS_IDS_BASE_QUANT_V2 },
};

/*!
 * \ingroup rndm0_internal
 * \brief     DS1410E
 */
static const TSupSysInfoIDSBase FAPSI0_IDS = 
{
    sizeof( FAPSI0_IDS_ITEMS ) / sizeof( TSupSysInfoIDSBaseItem ),
    FAPSI0_IDS_ITEMS
};

/*!
 * \ingroup rndm0_fun_general
 * \brief      DS1410E
 * \param context [in]  .  .
 * \param info [out]  #TSupSysInfoIDSBase
 * \return  .
 * \retval #ERROR_SUCCESS   .
 * \retval #(DWORD)ERROR_INVALID_PARAMETER   
 */
static DWORD fapsi0_info_ids(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    UNUSED( context );

    SUPSYS_PRE_INFO( info, TSupSysInfoIDSBase );
    memcpy( info, &FAPSI0_IDS, sizeof( TSupSysInfoIDSBase ) );
    return ERROR_SUCCESS;
}

/*!
 * \ingroup rndm0_internal
 * \brief      .
 * \sa #TSupSysFunctionTable, #TSupSysFunctionTableItem, #rndm0_funs
 */
static const TSupSysFunctionTableItem RNDM0_FUNS[] = 
{
    { SUPSYS_FUN_NICKNAME, rndm0_info_nickname},
    { SUPSYS_FUN_INSTANCE, rndm0_instance },
    { SUPSYS_FUN_VERSIONSUPPORT, info_versionsupport},

    { RANDOM_FUN_TYPE, rndm0_type },
    { RANDOM_FUN_RNDM, rndm0_rndm }
};

/*!
 * \ingroup rndm0_internal
 * \brief      .
 * \sa #TSupSysFunctionTable, #TSupSysFunctionTableItem, #rndm0_funs
 */
static const TSupSysFunctionTableItem FAPSI0_FUNS[] = 
{   { SUPSYS_FUN_NICKNAME, fapsi0_info_nickname},
    { SUPSYS_FUN_INSTANCE, rndm0_instance },
    { SUPSYS_FUN_IDS_BLOCK, fapsi0_info_ids },
    { SUPSYS_FUN_VERSIONSUPPORT, info_versionsupport},
    { RANDOM_FUN_TYPE, fapsi0_type },
    { RANDOM_FUN_RNDM, rndm0_rndm }
};

/*!
 * \ingroup acr_internal
 * \brief    .
 * \sa #TSupSysFunctionTable, #TSupSysFunctionTableItem, #rndm0_funs
 */
static const TSupSysFunctionTable RNDM0_TABLE =
{
    sizeof( RNDM0_FUNS ) / sizeof( TSupSysFunctionTableItem ),
    RNDM0_FUNS
};

/*!
 * \ingroup acr_internal
 * \brief    .
 * \sa #TSupSysFunctionTable, #TSupSysFunctionTableItem, #rndm0_funs
 */
static const TSupSysFunctionTable FAPSI0_TABLE =
{
    sizeof( FAPSI0_FUNS ) / sizeof( TSupSysFunctionTableItem ),
    FAPSI0_FUNS
};


/*! \ingroup rndm0_exp
 * \brief     .
 *
 *      .
 * \return    .
 */
const TSupSysEHandle* rndm0_rndm_get_table(void)
{
    return (const TSupSysEHandle*)&RNDM0_TABLE;
}

/*! \ingroup rndm0_exp
 * \brief     .
 *
 *      .
 * \return    .
 */
const TSupSysEHandle* fapsi0_rndm_get_table(void)
{
    return (const TSupSysEHandle*)&FAPSI0_TABLE;
}
