#ifndef CLOUD_API_HEADER_H
#define CLOUD_API_HEADER_H

#include "reader/support.h"

#if !defined( _CLOUD_DECL )
#define _CLOUD_DECL
#endif /* !defined( _CLOUD_DECL ) */

#if defined( __cplusplus )
extern "C" {
#endif /* defined( __cplusplus ) */

DWORD LoadCloudLibrary();

typedef void* TDssCertificatesEnumContext;
typedef void* TCloudServerEnumCtx;

typedef struct {
    const char* szUnique;	//   
    const char* szAuthURL;	//   , .. NULL, ,      szUnique
    const char* szRestURL;	//   , .. NULL, ,      szUnique
    const char* szUsername;	//   , .. NULL
    const char* szPassword;	//   , .. NULL
    const TCHAR* szDescription;	//  , .. NULL
    BOOL bTestService;		// ,    
    const char* szDocStoreURL;	//    , .. NULL, ,      szUnique
} TDssServerInfo;

static const unsigned DSS_SERVER_INFO_VERSION_0 = 0;	// szUnique, szAuthURL, szRestURL, szUsername, szPassword
static const unsigned DSS_SERVER_INFO_VERSION_1 = 1;	// + szDescription, bTestService
static const unsigned DSS_SERVER_INFO_VERSION_2 = 2;	// + szDocStoreURL

typedef struct {
    BYTE* certificate;              //    
    size_t certificate_length;      //    
    unsigned certificate_id;        //    DSS
    DWORD key_spec;                 //   (AT_KEYEXCHANGE  AT_SIGNATURE)
    DWORD permissions;              //  
    BYTE* extensions;               //    (   )
    size_t extensions_length;       //    
    char* szFriendlyName;           //   
    size_t szFriendlyNameMaxLength; //   
} TDssCertificateInfo;

/*
*        .
*/
_CLOUD_DECL DWORD SetCloudCertificateToStore(
    const TDssServerInfo* serverInfo,           //    
    const TDssCertificateInfo* certificateInfo, //  ,   
    const char* szContName,                     //  ;       ;
		                                //  NULL;  
    BOOL isLM,                                  //        
    const WCHAR *wszProvName,                   // , .. NULL
    DWORD dwProvType                            // , .. 0
);

/*
*      DSS.
* TDssCertificatesEnumContext       DssCertificatesEnumClose.
*/
_CLOUD_DECL DWORD DssCertificatesEnumOpen(
    const TDssServerInfo* serverInfo,           //    
    TDssCertificatesEnumContext *enumContextPtr //     
);

/*
*      DSS.
*      docstore   api V2   .
* TDssCertificatesEnumContext       DssCertificatesEnumClose.
*/
_CLOUD_DECL DWORD ExtendedDssCertificatesEnumOpen(
    const TDssServerInfo* serverInfo,           //    
    unsigned serverInfoVersion,                 //   TDssServerInfo
    TDssCertificatesEnumContext* enumContextPtr //     
);

/*
*      
*     .
*/
_CLOUD_DECL DWORD DssCertificateEnumNext(
    TDssCertificatesEnumContext enumContext, //     
    TDssCertificateInfo* containerInfo       //      
);

/*
*   
*/
_CLOUD_DECL void DssCertificatesEnumClose(
    TDssCertificatesEnumContext enumContext
);

/*
*      DSS-xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx.
*/
_CLOUD_DECL DWORD FormContainerName(
    const TDssServerInfo* serverInfo, //  
    unsigned certificateId, //    DSS
    char *szContName, //  ,       ;
    size_t *contNameSize //      
);

/*
*      
*/
_CLOUD_DECL DWORD DssDropAuthCookies(
    const TDssServerInfo* serverInfo //    
);

/*
*    
*/
_CLOUD_DECL DWORD DssSetConnectionTimeout(
    unsigned short timeout // 
);

/*
*    
*/
_CLOUD_DECL DWORD DssGetConnectionTimeout(
    unsigned short *timeout // 
);

/*
*    .
*/
_CLOUD_DECL DWORD CloudServerSettingsEnumOpen(
    TCloudServerEnumCtx* enum_ctx //  
);

/*
*   ,   DiscoveryService.
*/
_CLOUD_DECL DWORD CloudServerSettingsEnumOpenFromDiscovery(
    const char* szDiscoveryURL, //  DiscoveryService (c,     DSS), .. NULL
    TCloudServerEnumCtx* enum_ctx //  
);

/*
*       .
*/
_CLOUD_DECL DWORD CloudServerSettingsEnumNext(
    TCloudServerEnumCtx enum_ctx, //  
    TDssServerInfo* serverInfo //       -    CloudServerSettingsEnumClose
);

/*
*       .
*/
_CLOUD_DECL DWORD ExtendedCloudServerSettingsEnumNext(
    TCloudServerEnumCtx enum_ctx, //  
    unsigned serverInfoVersion, //   TDssServerInfo
    TDssServerInfo* serverInfo //        -    CloudServerSettingsEnumClose
);


/*
*    .     . 
*/
_CLOUD_DECL void CloudServerSettingsEnumClose(
    TCloudServerEnumCtx enum_ctx //  
);

/*
*     .
*   TDssServerInfo: {unique, auth, rest}, {unique, user, pass}, {unique, auth, rest, user, pass}
*/
_CLOUD_DECL DWORD SaveCloudServerSettings(
    const TDssServerInfo* serverInfo, //   
    BOOL isGlobal //       (  )
);

/*
*     .
*   TDssServerInfo: {unique, auth, rest}, {unique, user, pass}, {unique, auth, rest, user, pass}
*   (szDescription/bTestService)      {unique, auth, rest}
*/
_CLOUD_DECL DWORD SaveExtendedCloudServerSettings(
    const TDssServerInfo* serverInfo, //   
    unsigned serverInfoVersion, //   TDssServerInfo
    BOOL isGlobal //       (  )
);

/*
*    
*/
_CLOUD_DECL DWORD DeleteCloudServerSettings(
    const char *szUnique //   
);

/*
*     (    )
*/
_CLOUD_DECL void UpdateCloudServerSettings();

/*
*     (    DiscoveryService')
*/
_CLOUD_DECL void UpdateCloudServerSettingsUsingDiscovery(
    const char* szDiscoveryURL //  DiscoveryService (c,     DSS), .. NULL
);

/*
*        
*/
_CLOUD_DECL DWORD UpdateCloudCertificates(
    const char *szUnique //   
);

#if defined( __cplusplus )
}
#endif /* defined( __cplusplus ) */

#endif // CLOUD_API_HEADER_H

