/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 262786 $
 * \date $Date:: 2023-10-13 14:07:38 +0300#$
 * \author $Author: fomichev $
 * \brief      -  READER.
 */

#if !defined( READER_SCARD_SCARD_H )
#define READER_SCARD_SCARD_H

#include "reader.kit/reader.h"

/*!
* \ingroup scard_interface
* \def RSCARD_FUN_CONNECT_CARRIER
* \brief ,     -. 
*
* ,      -  SCardConnect. 
* Ÿ  :       APDU,       .
*
*         .  ATR-   
*  ,    ,    ,   , 
*   . 
* \sa #TSCardInfoConnectCarrier
*
*/
#define RSCARD_FUN_CONNECT_CARRIER 0x2501

#define PCSC_CLA_NUM 0
#define PCSC_INS_NUM 1
#define PCSC_P1_NUM 2
#define PCSC_P2_NUM 3
#define PCSC_LC_NUM 4
#define PCSC_DATA_NUM 5

#define PCSC_APDU_HEADER 4

#define MAX_APDU_LEN 0x100
#define MIN_APDU_RESPONSE_LEN 2 // minimal size of APDU response


/*!
 * \ingroup rdr_ext_fkc_type
 * \defgroup rscard_specific_info   ,   -
 * \brief        
 *   -.
 * \{
 */

/*!
 * \brief         BER-TLV.
 * \sa #TSCardInfoConnectCarrier
 */
typedef struct 
{
    unsigned char class_type; //!< ""   BER-TLV ( 6-8).
    unsigned char class_tag; //!< " "   BER-TLV ( 1-5).
    unsigned char simple_tag; //!<    .
    TSupSysInfoUntyped input; //!<       BER-TLV.
    TSupSysInfoUntyped output; //!<  :  .                output.length.   output.length    .
} TSCardInfoBerTLVSearch;

/*!
 * \brief         
 * SIMPLE-TLV.
 * \sa #TSCardInfoConnectCarrier
*/
typedef struct 
{
    unsigned char simple_tag; //!<    .
    TSupSysInfoUntyped input; //!<       SIMPLE-TLV.
    TSupSysInfoUntyped output; //!<  :  .                output.length.   output.length    .
} TSCardInfoSimpleTLVSearch;

/*!
 * \brief        BER-TLV
 *
 *  ,       
 *  BER-TLV. 
 * \sa #TSCardInfoBerTLVSearch
 */
typedef DWORD (*TSCardBerTLVSearch)( TSCardInfoBerTLVSearch *);

/*!
 * \brief        SIMPLE-TLV
 *
 *  ,       
 *  SIMPLE-TLV. 
 * \sa #TSCardInfoSimpleTLVSearch
 */
typedef DWORD (*TSCardSimpleTLVSearch)( TSCardInfoSimpleTLVSearch *);

/*!
 * \brief     APDU-.
 *
 *    SCardTransmit    ,     . 
 *  "" . 
 * \sa #TSCardInfoConnectCarrier
 */
typedef DWORD(*TSCardAPDUCmd) (TSupSysEContext *, BYTE *, size_t, BYTE *, size_t *);

/*!
 * \brief    APDU.
 *    status-word.    ,  .
 *       DWORD,  . ,     ,
 *      status-word.
 * \sa #TSCardInfoConnectCarrier, #TSCardSimpleAPDUCmd
 */
typedef DWORD(*TGetErrorCode) (unsigned short, DWORD *);

/*!
 * \brief ""   APDU.
 *      ,    (#TGetErrorCode),  APDU (CLA|INS|P1|P2),  ,  ,        .
 *        .   callback-     status-word.
 * \sa #TSCardInfoConnectCarrier, #TSCardSimpleAPDUCmd
 */
typedef DWORD(*TSCardSimpleAPDUCmd)(TSupSysEContext * /*reader_ctx*/,
    BOOL /*isSM*/,
    TGetErrorCode /*get_error_fun*/,
    const BYTE * /*apdu_header*/,
    const BYTE * /*apdu_in*/,
    size_t /*apdu_in_len*/,
    BYTE * /*apdu_out*/,
    size_t * /*apdu_out_len*/,
    DWORD* /*add_out_param*/);

/*!
 * \brief    .
 * \sa #TSCardInfoConnectCarrier
 */
typedef DWORD(*TSCardGetStatusCmd) (TSupSysEContext * /*reader_ctx*/);

/*!
 * \brief   -.
 *
 *      (ATR, protocol)     APDU.   #RSCARD_FUN_CONNECT_CARRIER
 */
typedef struct 
{    
    TSCardAPDUCmd apdu_cmd; //!<   APDU-
    TSCardAPDUCmd secure_apdu_cmd; //!<    APDU-,    .          status word (2 ),       ,    CPR_ERR_RDR_SM.
    unsigned protocol; //!< ,       (SCARD_PROTOCOL_T0/SCARD_PROTOCOL_T1)
    TSupSysInfoUntyped atr; //!< ATR .
    TSupSysEContext *reader; //!<  .     callback' APDU.
    TSCardBerTLVSearch ber_tlv_search; //!<    ,       BER-TLV .
    TSCardSimpleTLVSearch simple_tlv_search; //!<    ,       SIMPLE-TLV .
    TCHAR *connect; //!<  :   ,      .
    BOOL need_reset_on_disconnect; //!< [out]  ,     ,   .
    BOOL need_reset_on_end_transaction; //!< [out]  ,       .
    BOOL need_connect_after_reconnect; //!< UNUSED,          .
    unsigned int app_count;  //!< [out]    ,    .
    TSCardSimpleAPDUCmd simple_apdu_cmd; //!< ""   APDU.   .        .   callback-     status-word.
    TSCardGetStatusCmd get_status_cmd; //!<    .
} TSCardInfoConnectCarrier;

/*!\}*/
#endif /* READER_SCARD_SCARD_H */
