/*
* Copyright(C) 2000  
*
*    , 
*    .
*
*        ,
* ,    ,
*     ,
* ,      
*     
*      .
*/

/****
* $Id: f12grpn.c 121363 2015-06-03 17:20:39Z dim $
*
*       (READER).
*
*   /      (FAT12).
*
*      .
*     .
*
* : fat12_group_enum_next
****/

#include "fat12prj.h"

/*++++
*     .
++++*/
DWORD fat12_group_enum_next(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TSupSysInfoGroupEnum *inf = (TSupSysInfoGroupEnum*)info;
    TFat12ConnectEnum *enum_ptr;
    const size_t pref_l = _tcslen(_TEXT("FAT12_"));

    UNUSED( context );
    SUPSYS_PRE_INFO( info, TSupSysInfoGroupEnum);
    SUPSYS_PRE_READ_PTRS( inf->add_info.info, sizeof( TFat12ConnectEnum ) );

#if !defined( UNIX )
    enum_ptr = (TFat12ConnectEnum*)(inf->add_info.info);
    SUPSYS_PRE_STRING_PTR( enum_ptr->drive_strings );
    SUPSYS_PRE_STRING_PTR( enum_ptr->cur );

    while( *( enum_ptr->cur ) )
    {
	size_t l = _tcslen( enum_ptr->cur );
	if (isCPdisk(enum_ptr->cur))
	{
	    if( l + pref_l > inf->name.length )
		return (DWORD)ERROR_INVALID_PARAMETER;
	    _tcscpy( inf->name.text, _TEXT("FAT12_") );
	    _tcscat( inf->name.text, enum_ptr->cur );
	    inf->name.length = l + pref_l;
	    if( inf->name.text[inf->name.length - 1] == '\\' )
	    {
		inf->name.text[inf->name.length - 1] = 0;
		inf->name.length--;
	    }
	    if( inf->name.text[inf->name.length - 1] == ':' )
	    {
		inf->name.text[inf->name.length - 1] = 0;
		inf->name.length--;
	    }
	    enum_ptr->cur += l + 1;
	    return ERROR_SUCCESS;
	}
	enum_ptr->cur += l + 1;
    }
    enum_ptr->cur = NULL;
    return (DWORD)SCARD_E_READER_UNAVAILABLE;
#else
    enum_ptr = (TFat12ConnectEnum*)(inf->add_info.info);

    while( enum_ptr->cur )
    {
	const size_t l = _tcslen( enum_ptr->cur->connect_str );
	if( 1 /* GetDriveType( enum_ptr->cur ) == DRIVE_REMOVABLE */ )
	{
	    if( l + pref_l > inf->name.length )
		return (DWORD)ERROR_INVALID_PARAMETER;
	    _tcscpy( inf->name.text, _TEXT("FAT12_") );
	    _tcscat( inf->name.text, enum_ptr->cur->connect_str );
	    inf->name.length = l + pref_l;
	    if( inf->name.text[l + pref_l - 1] == '\\' )
	    {
		inf->name.text[l + pref_l - 1] = 0;
		inf->name.length--;
	    }
	    enum_ptr->cur = enum_ptr->cur->next;
	    return ERROR_SUCCESS;
	}
    }
    return (DWORD)SCARD_E_READER_UNAVAILABLE;
#endif	/* !UNIX */
}
