/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 166516 $
 * \date $Date:: 2017-11-21 14:05:30 +0300#$
 * \author $Author: borodin $
 * \brief      .
 */

#include "fat12prj.h"

/*! 
 * \ingroup fat12_fun_reader
 * \brief      .
 *
 *      
 *   #fat12_info_folder_enum_open
 * \param context [in]  .  .
 * \param info [in]  #TReaderInfoFolderEnum
 * \sa #TReaderInfoFolderEnum, #READER_FUN_FOLDER_ENUM_CLOSE, 
 *  #TSupSysFunction, #fat12_info_folder_enum_open, #fat12_info_folder_enum_next,
 * \return  
 */
DWORD fat12_info_folder_enum_close(
    TSupSysContext *context,
    TSupSysInfo *info )
{
    TReaderInfoFolderEnum *inf = (TReaderInfoFolderEnum*)info;
    TFat12FolderEnumNew *folder_enum;
    TFat12Context * ctx = (TFat12Context *)context;

    SUPSYS_PRE_INFO( info, TReaderInfoFolderEnum );

    if (ctx->long_names) {
	if ((TSupFileEnum*)inf->add_info.info)
	    support_closedir((TSupFileEnum*)inf->add_info.info);
	inf->add_info.info = NULL;
	return ERROR_SUCCESS;
    }

    if( inf->add_info.length == 0 || inf->add_info.info == NULL )
	return ERROR_SUCCESS;
    if (inf->flags == RDR_FOLDER_ENUM_FLAG_OPEN)
    {
	support_closedir((TSupFileEnum*)inf->add_info.info);
	inf->add_info.length = 0;
	inf->add_info.info = NULL;
	return ERROR_SUCCESS;
    }
    folder_enum = (TFat12FolderEnumNew*)inf->add_info.info;
    free( folder_enum->full_prefix );
    free( folder_enum );
    inf->add_info.length = 0;
    inf->add_info.info = NULL;
    return ERROR_SUCCESS;
}
