/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 260542 $
 * \date $Date:: 2023-08-15 22:16:30 +0300#$
 * \author $Author: raa $
 *
 * \brief  Microsoft Cryptography Service Provider.
 *
 *   ,     CSP.
 *  ,      -   
 *   ,   .
 */
#ifndef WINCSPC_INT_H_INCLUDED
#define WINCSPC_INT_H_INCLUDED

#include "wincspc.h"

#define CSP_36_R2_CPC_CONFIG_64_LEN 648
#define CSP_36_R2_CPC_CONFIG_32_LEN 532

#if defined(__cplusplus)
extern "C" {
#endif // defined(__cplusplus)

	// ,      
	// . wincspc.h 
#if defined(CPC_SEPARATE_NAMESPACE_BINDING)
    CPCCreateProvider_t		CPCCreateProvider;
    CPCGetDefaultConfig_t	CPCGetDefaultConfig;
#endif

	//  ,    HCRYPTMODULE
CPCAcquireContext_t	CPCAcquireContext;
CPCReleaseContext_t	CPCReleaseContext;
CPCGetProvParam_t	CPCGetProvParam;
CPCSetProvParam_t	CPCSetProvParam;
CPCGenKey_t		CPCGenKey;
CPCDestroyKey_t		CPCDestroyKey;
CPCCreateHash_t		CPCCreateHash;
CPCDestroyHash_t	CPCDestroyHash;
CPCEncrypt_t		CPCEncrypt;
CPCDecrypt_t		CPCDecrypt;
CPCDeriveKey_t		CPCDeriveKey;
CPCDuplicateKey_t	CPCDuplicateKey;
CPCDuplicateHash_t	CPCDuplicateHash;
CPCExportKey_t		CPCExportKey;
CPCGenRandom_t		CPCGenRandom;
CPCGetHashParam_t	CPCGetHashParam;
CPCGetKeyParam_t	CPCGetKeyParam;
CPCGetUserKey_t		CPCGetUserKey;
CPCHashData_t		CPCHashData;
CPCHashSessionKey_t	CPCHashSessionKey;
CPCImportKey_t		CPCImportKey;
CPCSetHashParam_t	CPCSetHashParam;
CPCSetKeyParam_t	CPCSetKeyParam;
CPCSignHash_t		CPCSignHash;
CPCVerifySignature_t	CPCVerifySignature;
CPCDestroyProvider_t	CPCDestroyProvider;

#if defined(__cplusplus)
} // extern "C"
#endif // defined(__cplusplus)

#endif /* WINCSPC_INT_H_INCLUDED */
