/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 260542 $
 * \date $Date:: 2023-08-15 22:16:30 +0300#$
 * \author $Author: raa $
 *
 * \brief XXX
 *
 * XXX
 */
#ifndef _CSPMM_H_INCLUDED
#define _CSPMM_H_INCLUDED

#ifdef UNIX
    #include "CSP_WinDef.h"
#else // UNIX
    #include <windef.h>
#endif // UNIX
#include "WinCryptEx.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct CPC_MEMORY_ARENA_ CPC_MEMORY_ARENA, *LPCPC_MEMORY_ARENA;

typedef struct CPC_MEMORY_STATS_ {
    LONG nBytes;
    LONG nChunks;
    LONG Used;
    LONG Size;
} CPC_MEMORY_STATS, *LPCPC_MEMORY_STATS;

typedef DWORD CPCAPI CPC_AllocMemory_Callback(
    LPCPC_MEMORY_ARENA pArena, 
    CPC_SIZE_T dwSize,
    DWORD dwMemPoolId,
    DWORD dwThreadId,
    LPVOID *pRes
);

typedef DWORD CPCAPI CPC_FreeMemory_Callback(
    LPCPC_MEMORY_ARENA pArena,
    VOID *pMem,
    DWORD dwMemPoolId
);

typedef VOID CPCAPI CPC_StatMemory_Callback(
    LPCPC_MEMORY_ARENA pArena,
    LPCPC_MEMORY_STATS pStats,
    DWORD dwMemPoolId
);

typedef VOID CPCAPI CPC_ValidateMemory_Callback(
    LPCPC_MEMORY_ARENA pArena
);

typedef VOID CPCAPI CPC_DoneMemory_Callback(
    LPCPC_MEMORY_ARENA pArena
);

typedef VOID CPCAPI CPC_MemoryException_Callback(
    LPCPC_MEMORY_ARENA pArena,
    VOID *arg
);

struct CPC_MEMORY_ARENA_ {
    CPC_ValidateMemory_Callback     *pValidateMemory;
    CPC_DoneMemory_Callback	    *pDoneMemory;
    CPC_AllocMemory_Callback	    *pAllocMemory;
    CPC_FreeMemory_Callback	    *pFreeMemory;
    CPC_StatMemory_Callback	    *pStatMemory;
    CPC_MemoryException_Callback    *pHandleException;
    LPVOID			    lpArg;
};

/*     (memory pool id)
    ,      MP_PRIME  
       MP_SEC*/
#define MP_WORK		3
#define MP_PRIME	MP_WORK
#define MP_SEC		MP_WORK
#define MP_PRIME_M	4
#define MP_SEC_M	5
#define MP_WORK_M	6
#if defined ( _WIN32 ) || defined ( _WIN64 )
#define MP_BIG		7
#else
#define MP_BIG		MP_WORK
#endif /* defined ( _WIN32 ) || defined ( _WIN64 ) */

#define NO_ZERO_MEMORY		(0x80000000)

#ifdef __cplusplus
}
#endif

#endif /* _CSPMM_H_INCLUDED */
