#ifndef ASN1_PRINTABLESTRING_H
#define ASN1_PRINTABLESTRING_H

#include <stdio.h>
#include <stdlib.h>
#include "asn1BerCppTypes.h"
#include "asn1XerCppTypes.h"
#include "rtTable.h"

namespace asn1data {

typedef ASN1PrintableString ASN1T_ASN1PrintableString;

class EXTERN ASN1C_ASN1PrintableString :
   public ASN1CType, public ASN1XERSAXDecodeHandler
{
protected:
    ASN1T_ASN1PrintableString& msgData;
    ASN1MemBuf mCurrElemValue;
public:
   ASN1C_ASN1PrintableString (ASN1T_ASN1PrintableString& data);
   ASN1C_ASN1PrintableString (
      ASN1MessageBufferIF& msgBuf, ASN1T_ASN1PrintableString& data);
   ASN1C_ASN1PrintableString (ASN1C_ASN1PrintableString& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ASN1PrintableString& getCopy (ASN1T_ASN1PrintableString* pDstData = 0);
   ASN1T_ASN1PrintableString* newCopy ();

   inline ASN1C_ASN1PrintableString& operator= (ASN1C_ASN1PrintableString& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }

   // SAX ContentHandler interface

   virtual void startElement 
      (const XMLCHAR* const uri, 
       const XMLCHAR* const localname, 
       const XMLCHAR* const qname, 
       const XMLCHAR* const* attrs);

   virtual void characters 
      (const XMLCHAR* const chars,
       const unsigned int length);

   virtual void endElement
      (const XMLCHAR* const uri,
       const XMLCHAR* const localname,
       const XMLCHAR* const qname);

   virtual void init (int level = 0);
} ;

EXTERN int asn1E_ASN1PrintableString (ASN1CTXT* pctxt,
   ASN1T_ASN1PrintableString *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ASN1PrintableString (ASN1CTXT* pctxt,
   ASN1T_ASN1PrintableString *pvalue, ASN1TagType tagging, int length);

EXTERN int asn1XE_ASN1PrintableString
  (ASN1CTXT* pctxt, ASN1T_ASN1PrintableString value,
   ASN1ConstCharPtr elemName, ASN1ConstCharPtr attributes);

EXTERN void asn1Copy_ASN1PrintableString (ASN1CTXT *pctxt, ASN1T_ASN1PrintableString* pSrcValue, ASN1T_ASN1PrintableString* pDstValue);

EXTERN void asn1Free_ASN1PrintableString (ASN1CTXT *pctxt, ASN1T_ASN1PrintableString* pvalue);
}

#endif // ASN1_PRINTABLESTRING_H

