/*
 * Copyright (C) 1997-2003 by Objective Systems, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by Objective Systems, Inc.
 *
 * PROPRIETARY NOTICE
 *
 * This software is an unpublished work subject to a confidentiality agreement
 * and is protected by copyright and trade secret law.  Unauthorized copying,
 * redistribution or other use of this work is prohibited.
 *
 * The above notice of copyright on this source code product does not indicate
 * any actual or intended publication of such source code.
 *
 *****************************************************************************/

/**
 * @file rtTable.h
 */

#ifndef _RTTABLE_H_
#define _RTTABLE_H_

#include "asn1type.h"

#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************/
/*                                                            */
/*  Common RunTime Library Functions		              */
/*                                                            */
/**************************************************************/

EXTERNRT int rtCmpTCINT8 (ASN1INT8* value, ASN1INT8* compValue);
EXTERNRT int rtCmpTCUINT8 (ASN1UINT8* value, ASN1UINT8* compValue);
#define rtCmpTCCHAR rtCmpTCINT8
#define rtCmpTCOCTET rtCmpTCUINT8
EXTERNRT int rtCmpTCSINT (ASN1SINT* value, ASN1SINT* compValue);
EXTERNRT int rtCmpTCUSINT (ASN1USINT* value, ASN1USINT* compValue);
EXTERNRT int rtCmpTCINT (ASN1INT* value, ASN1INT* compValue);
EXTERNRT int rtCmpTCUINT (ASN1UINT* value, ASN1UINT* compValue);
EXTERNRT int rtCmpTCINT64 (ASN1INT64* value, ASN1INT64* compValue);
EXTERNRT int rtCmpTCUINT64 (ASN1UINT64* value, ASN1UINT64* compValue);
EXTERNRT int rtCmpTCOID (ASN1OBJID* pOID, ASN1OBJID* pcompOID);
EXTERNRT int rtCmpTCReal (ASN1REAL* value, ASN1REAL* compValue);
EXTERNRT int rtCmpTCBoolean (ASN1BOOL* key, ASN1BOOL* pCompValue);
EXTERNRT int rtCmpTCBitStr (ASN1UINT numbits, ASN1ConstOctetPtr data, 
   ASN1UINT cmpnumbits, ASN1ConstOctetPtr cmpData);
EXTERNRT int rtCmpTCOctet (ASN1ConstOctetPtr pValue, ASN1ConstOctetPtr pCompValue);
EXTERNRT int rtCmpTCOctStr (ASN1UINT numocts, ASN1ConstOctetPtr data,
   ASN1UINT cmpnumocts, ASN1ConstOctetPtr cmpdata);
EXTERNRT int rtCmpTCCharStr (ASN1ConstCharPtr cstring, ASN1ConstCharPtr compCstring);
EXTERNRT int rtCmpTC16BitCharStr (Asn116BitCharString* key, Asn116BitCharString* pCompValue);
EXTERNRT int rtCmpTC32BitCharStr (Asn132BitCharString* key, Asn132BitCharString* pCompValue);

EXTERNRT int rtBSearch (void *key, void *base, 
                      size_t nmemb, size_t size,  
                      int (*compar) (void *, void *));

EXTERNRT int rtLSearch (void *key, void *base, 
                      int nmemb, size_t size,  
                      int (*compar) (void *, void *));

#define RTARRAYTOLIST(arraysize, array, list) \
{\
   static Asn1RTDListNode ListNodes[arraysize]; \
   ASN1UINT i; \
   for (i = 0; i < arraysize; i ++) { \
      ListNodes[i].data = (void*)&array[i]; \
      ListNodes[i].next = (Asn1RTDListNode*) 0; \
      if (0 != list.tail) { \
         list.tail->next = &ListNodes[i]; \
         ListNodes[i].prev = list.tail; \
      } \
      if (0 == list.head) { \
         list.head = &ListNodes[i]; \
         ListNodes[i].prev = (Asn1RTDListNode*) 0; \
      } \
      list.tail = &ListNodes[i]; \
      list.count++; \
   } \
}

EXTERNRT void rtMemFreeNullPtr(ASN1CTXT* pctxt, void* pobject);

#ifdef __cplusplus
}
#endif
#endif 
