/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2005-2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 *
 * \brief
 *
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef HAVE_CPRO_CONFIG_H
#include "myconfig.h"
#endif

#ifdef _WIN32
#   include <Windows.h>
#   include <WinCrypt.h>
#   include "platformstream.h"
#else
#   include <arpa/inet.h> // htonl()
#endif
#include "wincspc.h"
#include "ike_gost.h"
#include "init_plg.h"
#include "example.h"

#ifdef TEST_CONFORMITY
#   include "../../Conformity/ConformityIPSEC.h"
extern vblob **pikepckt;
extern LPCONF_IPSEC pC_pikepckt;
#include "ConformityIKEp1.h"
#endif  /* TEST_CONFORMITY */
#define IKEPACKET_ENCRYPT 1

static char buf[10000];
static ikeHDR *ih = (ikeHDR*) buf;

unsigned
ph1_SIGNATURE_Main(p1_ir_state *i, p1_ir_state *r, bool is_cfgmode)
{
    unsigned rc;
    int line;
    unsigned enc_len, save_enc_len, dec_len;
    vblob *pSIG_I;
    vblob *pSIG_R;
    vblob *pKEi_b;
    vblob *pKEr_b;
    vblob *pNi_b;
    vblob *pNr_b;

    // --------------Initiator
    // Send HDR(CKYi,0)<SA>

    // --------------Responder
    // Receive HDR(CKYi,0)<SA>
    CERR(r->plg->p1_CreateFn(r->plg,
		             r->Vendor_IDs, is_cfgmode ? CPIKE_AUTH_HYBRID_RESP_GOST : r->SAtype.am,
			     IKE_RESPONDER,
			     r->SAtype.enc_mac_id, r->SAtype.hash_id,
			     r->SAtype.gtype_id, r->SAtype.group_id,
			     0,
			     &r->p1));
    //   ( RECOMMENDED   )
    //r->plg->p1_SetParamFn(r->p1, CPIKE_AC_Life_Duration, 31*24*60*60, CPIKE_LIFET_SECONDS /*1 */, 0);
    //r->plg->p1_SetParamFn(r->p1, CPIKE_AC_Max_Messages, CPIKE_NONPFS_MAX_MSGS, 0 /*64*/, 0);
    //r->plg->p1_SetParamFn(r->p1, CPIKE_AC_PFS_Control, CPIKE_PFSC_Enable_Non_PFS, 0, 0);

    // Send HDR(CKYi,CKYr)<SA>

    // --------------Initiator
    // Receive HDR(CKYi,CKYr)<SA>
    CERR(i->plg->p1_CreateFn(i->plg,
			     i->Vendor_IDs, is_cfgmode ? CPIKE_AUTH_HYBRID_INIT_GOST : i->SAtype.am,
			     IKE_INITIATOR,
			     i->SAtype.enc_mac_id, i->SAtype.hash_id,
			     i->SAtype.gtype_id, i->SAtype.group_id,
			     0,
			     &i->p1));
    //   ( RECOMMENDED   )
    i->plg->p1_SetParamFn(i->p1, CPIKE_AC_Life_Duration, 31*24*60*60, CPIKE_LIFET_SECONDS /*1 */, 0);
    i->plg->p1_SetParamFn(i->p1, CPIKE_AC_Max_Messages, CPIKE_NONPFS_MAX_MSGS, 0 /*64*/, 0);
    i->plg->p1_SetParamFn(i->p1, CPIKE_AC_PFS_Control, CPIKE_PFSC_Enable_Non_PFS, 0, 0);

    CERR(i->plg->p1_SetupFn(i->p1, i->CKY, 0, &pKEi_b, &pNi_b));

    // Send HDR<KEi, Ni>
    // --------------Responder
    // Receive HDR<KEi, Ni>

    CERR(r->plg->p1_SetupFn(r->p1, r->CKY, 0, &pKEr_b, &pNr_b));
    CERR(r->plg->p1_AgreeFn(r->p1, r->SA_b, pKEi_b, pNi_b, i->CKY, 0));
    vdelete(&pKEi_b);
    vdelete(&pNi_b);

    // Send HDR<KEr, Nr>
    // --------------Initiator
    // Receive HDR<KEr, Nr>

    //  ,    .
    //   : . example.cpp:check_get_cert()
    // -->    
    CERR(i->plg->p1_AgreeFn(i->p1, i->SA_b, pKEr_b, pNr_b, r->CKY, 0));
    vdelete(&pKEr_b);
    vdelete(&pNr_b);

    if( !is_cfgmode )
    {
	PRIVKEY hPrivI;
	hPrivI.hModule = GetNewModule_Crypt();
#if defined TEST_CONFORMITY
	CHAR * pContName = (CHAR*)malloc(strlen(i->pszCont) + 2);
	if (!pContName)
	{
	    line = __LINE__;
	    goto err;
	}
	strcpy(pContName, i->pszCont);
	strcpy(pContName + strlen(i->pszCont), "2");

	if( CapiAcquireContext( hPrivI.hModule, &hPrivI.hProv, pContName, i->pszProv, i->dwPT, i->dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001 ) ) {
	    line = __LINE__;
	    rc = GetLastError();
	    free(pContName);
	    example_certificate_usage();
	    goto err;
	}
	free(pContName);
#else
	if (CapiAcquireContext(hPrivI.hModule, &hPrivI.hProv, (CHAR *)i->pszCont, i->pszProv, i->dwPT, i->dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001)) {
	    line = __LINE__;
	    rc = GetLastError();
	    example_certificate_usage();
	    goto err;
	}
#endif
	CERR(CapiSetProvParam(hPrivI.hModule, hPrivI.hProv, PP_KEYEXCHANGE_PIN, i->pbPIN, 0));
	CERR( CapiGetUserKey( hPrivI.hModule, hPrivI.hProv, AT_KEYEXCHANGE, &hPrivI.hKey ) );
	BYTE pbCert[4096];
	DWORD dwCert = sizeof( pbCert );
	CERR( CapiGetKeyParam( hPrivI.hModule, hPrivI.hProv, hPrivI.hKey, KP_CERTIFICATE, pbCert, &dwCert, 0 ) );
	vblob * Cert = vcreate( GetCPCConfig(), DT_EXTDATA, (char *)pbCert, dwCert );
	HCRYPTPROV hProvTemp;
	CERR( CapiAcquireContext( hModuleIke, &hProvTemp, 0, 0, 0, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001 ) );
	PRIVKEY hPrivI_Ephem;
	CERR(i->plg->sadb.CreateEphemFn( hModuleIke, hProvTemp, FLAG_SADB_DUPLICATE_EPHEM, &hPrivI_Ephem, 0, (unsigned *)(void *)&hPrivI ));
	CERR( CapiDestroyKey( hPrivI.hModule, hPrivI.hProv, hPrivI.hKey ) );
	CERR( CapiReleaseContext( hPrivI.hModule, hPrivI.hProv, 0 ) );
	ReleaseModule_Crypt( hPrivI.hModule );
	CERR(i->plg->p1_SetMyCertProvFn(i->p1, &hPrivI_Ephem, Cert, 0));
	vdelete( &Cert );
	CERR(i->plg->p1_AuthIRFn(i->p1, i->ID_b, 0, &pSIG_I));
	CERR( CapiDestroyKey( hPrivI_Ephem.hModule, hPrivI_Ephem.hProv, hPrivI_Ephem.hKey ) );
	CERR( CapiReleaseContext( hPrivI_Ephem.hModule, hPrivI_Ephem.hProv, 0 ) );	
    }
    else
    {
	CERR(i->plg->p1_AuthIRFn(i->p1, i->ID_b, 0, &pSIG_I));
    }

    // Send HDR*<IDii, [CERTi], SIG_I>
    memset(buf, 0, sizeof(buf) );
    memcpy(ih->CKY_I, vref((vblob *)i->CKY), sizeof(ih->CKY_I));
    memcpy(ih->CKY_R, vref((vblob *)r->CKY), sizeof(ih->CKY_R));
    memset(ih->MessageID, 0, sizeof(ih->MessageID));
    enc_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    CERR(send2buf(i->ID_b, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(i->CERT_b, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(pSIG_I, buf, &enc_len, sizeof(buf)));
    ih->flags = IKEPACKET_ENCRYPT;

    unsigned al;
    char *d;
    vblob *v;

    al = 42;
    al *= 4;			//  Payloads ..  4
    d = (char*) calloc(al,1);
    v = vcreate( GetCPCConfig(), DT_EXTDATA, d, al);
    CERR(send2buf(v, buf, &enc_len, sizeof(buf)));
    vdelete(&v);
    free(d);
#else
    PLTYPE PlT;
    ih->next_header = Identification;
    ih->version = 1; 
    ih->exchange_type = 0;//Identity_Protection;
    ih->flags = IKEPACKET_ENCRYPT;
    PlT.next=Certificate;	PlT.curr=Identification;
    PlT.id=ID_IPV4_ADDR;
    CERR(send2bufex(PlT, i->ID_b, buf, &enc_len, sizeof(buf)));
    PlT.next=Signature;	    PlT.curr=Certificate;
    PlT.cert=X_509_Certificate_Signature;
    CERR(send2bufex(PlT, i->CERT_b, buf, &enc_len, sizeof(buf)));
    PlT.next=0;		    PlT.curr=Signature;	
    CERR(send2bufex(PlT, pSIG_I, buf, &enc_len, sizeof(buf)));
    CERR(reinitvblob(DT_BYTE, (BYTE*)vref( i->CERT_b ), (DWORD)vsize( i->CERT_b ), &p1I->SigCert, p1I, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */

    save_enc_len = enc_len;
    CERR(i->plg->p1_EncapFn(i->p1, 0, NULL, &enc_len, sizeof(buf)));
    ih->Length = htonl(enc_len);
    ih->flags = IKEPACKET_ENCRYPT;
    enc_len = save_enc_len;
#ifdef TEST_CONFORMITY
    pikepckt = &p1I->P_2;
    pC_pikepckt = p1I;
    //CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1I->P_2));
#endif  /* TEST_CONFORMITY */
    CERR(i->plg->p1_EncapFn(i->p1, 0, buf, &enc_len, sizeof(buf)));

    // --------------Responder
    // Receive HDR*<IDii, [CERTi], SIG_I>
#ifdef TEST_CONFORMITY
    p1I->P_2=*pikepckt;
    CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1R->P_2, p1R, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    CERR(r->plg->p1_DecapFn(r->p1, 0, buf, &enc_len));
    dec_len=sizeof(ikeHDR);

    {
	vblob *IDi_b_rcv;
	vblob *CERTi_b_rcv;
	vblob *SIG_I_rcv;
	//    vblob/    
#ifndef TEST_CONFORMITY
	CERR(recv4buf(&IDi_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	CERR(recv4buf(&CERTi_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	CERR(recv4buf(&SIG_I_rcv, DT_SIG_IR, buf, &dec_len, enc_len));
#else
	PlT.curr=Identification;
	CERR(recv4bufex(&PlT, &IDi_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	PlT.curr=Certificate;
	CERR(recv4bufex(&PlT, &CERTi_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	PlT.curr=Signature;	
	CERR(recv4bufex(&PlT, &SIG_I_rcv, DT_SIG_IR, buf, &dec_len, enc_len));
#endif  /* TEST_CONFORMITY */
	// XXX dim:   i->ID_b  IDi_b_rcv
	// XXX dim:   i->CERT_b  CERTi_b_rcv
	// XXX dim:   SIG_I  SIG_I_rcv
	vdelete(&IDi_b_rcv);
	vdelete(&CERTi_b_rcv);
	vdelete(&SIG_I_rcv);
    }

    //  ,    .
    //   : . example.cpp:check_get_cert()
    // -->    
    
    {
	PRIVKEY hPrivR;
	hPrivR.hModule = GetNewModule_Crypt();
#if defined TEST_CONFORMITY
	CHAR * pContName = (CHAR*)malloc(strlen(r->pszCont) + 2);
	if (!pContName)
	{
	    line = __LINE__;
	    goto err;
	}
        strcpy(pContName, r->pszCont);
        strcpy(pContName + strlen(r->pszCont), "2");

	if( CapiAcquireContext( hPrivR.hModule, &hPrivR.hProv, pContName, r->pszProv, r->dwPT, r->dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001)) {
	    free(pContName);
	    line = __LINE__;
	    rc = GetLastError();
	    example_certificate_usage();
	    goto err;
	}
	free(pContName);
#else
	if (CapiAcquireContext(hPrivR.hModule, &hPrivR.hProv, (CHAR *)r->pszCont, r->pszProv, r->dwPT, r->dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001)) {
	    line = __LINE__;
	    rc = GetLastError();
	    example_certificate_usage();
	    goto err;
	}
#endif
	CERR( CapiSetProvParam( hPrivR.hModule, hPrivR.hProv, PP_KEYEXCHANGE_PIN, (BYTE *)r->pbPIN, 0 ) );
	CERR( CapiGetUserKey( hPrivR.hModule, hPrivR.hProv, AT_KEYEXCHANGE, &hPrivR.hKey ) );
	BYTE pbCert[4096];
	DWORD dwCert = sizeof( pbCert );
	CERR( CapiGetKeyParam( hPrivR.hModule, hPrivR.hProv, hPrivR.hKey, KP_CERTIFICATE, pbCert, &dwCert, 0 ) );
	vblob * Cert = vcreate( GetCPCConfig(), DT_EXTDATA, (char *)pbCert, dwCert );
	HCRYPTPROV hProvTemp;
	CERR( CapiAcquireContext( hModuleIke, &hProvTemp, 0, 0, 0, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001 ) );
	PRIVKEY hPrivR_Ephem;
	CERR(r->plg->sadb.CreateEphemFn( hModuleIke, hProvTemp, FLAG_SADB_DUPLICATE_EPHEM, &hPrivR_Ephem, 0, (unsigned *)(void *)&hPrivR ));
	CERR( CapiDestroyKey( hPrivR.hModule, hPrivR.hProv, hPrivR.hKey ) );
	CERR( CapiReleaseContext( hPrivR.hModule, hPrivR.hProv, 0 ) );
	ReleaseModule_Crypt( hPrivR.hModule );
	CERR(r->plg->p1_SetMyCertProvFn(r->p1, &hPrivR_Ephem, Cert, 0));
	vdelete( &Cert );
	CERR(r->plg->p1_AuthIRFn(r->p1, r->ID_b, 0, &pSIG_R));
	CERR( CapiDestroyKey( hPrivR_Ephem.hModule, hPrivR_Ephem.hProv, hPrivR_Ephem.hKey ) );
	CERR( CapiReleaseContext( hPrivR_Ephem.hModule, hPrivR_Ephem.hProv, 0 ) );	
    }  

    //    
    //       example.cpp:check_get_cert()
    //    --  
    PCCERT_CONTEXT pCertCtx;
    pCertCtx = ::CertCreateCertificateContext(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING, (LPCBYTE)vref( i->CERT_b ), vsize( i->CERT_b ));
    if( !is_cfgmode )
	CERR(r->plg->p1_SetOtherCertFn(r->p1, i->BLOB_b, i->CERT_b, 0));
    CertFreeCertificateContext(pCertCtx);
    CERR(r->plg->p1_VerifyIRFn(r->p1, i->ID_b, pSIG_I, 0));
    vdelete(&pSIG_I);

    // Send HDR*<IDir, [CERTr], SIG_R>
    memset(buf, 0, sizeof(buf) );
    memcpy( ih->CKY_I, vref((vblob *)i->CKY), sizeof(ih->CKY_I) );
    memcpy( ih->CKY_R, vref((vblob *)r->CKY), sizeof(ih->CKY_R) );
    memset( ih->MessageID, 0, sizeof(ih->MessageID) );
    enc_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    CERR(send2buf(r->ID_b, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(r->CERT_b, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(pSIG_R, buf, &enc_len, sizeof(buf)));
    al = 42;
    al *= 4;			//  Payloads ..  4
    d = (char*) calloc(al,1);
    v = vcreate( GetCPCConfig(), DT_EXTDATA, d, al);
    CERR(send2buf(v, buf, &enc_len, sizeof(buf)));
    vdelete(&v);
    free(d);
#else
    ih->next_header = Identification;
    ih->version = 1; 
    ih->exchange_type = 0;//Identity_Protection;
    ih->flags = IKEPACKET_ENCRYPT;
    PlT.next=Certificate;	PlT.curr=Identification;
    PlT.id=ID_IPV4_ADDR;
    CERR(send2bufex(PlT, r->ID_b, buf, &enc_len, sizeof(buf)));
    PlT.next=Signature;		PlT.curr=Certificate;
    PlT.cert=X_509_Certificate_Signature;
    CERR(send2bufex(PlT, r->CERT_b, buf, &enc_len, sizeof(buf)));
    PlT.next=0;			PlT.curr=Signature;	
    CERR(send2bufex(PlT, pSIG_R, buf, &enc_len, sizeof(buf)));
    CERR(reinitvblob(DT_BYTE, (BYTE*)vref( r->CERT_b ), (DWORD)vsize( r->CERT_b ), &p1R->SigCert, p1R, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */

    save_enc_len = enc_len;
    CERR(r->plg->p1_EncapFn(r->p1, 0, NULL, &enc_len, sizeof(buf)));
    ih->Length = htonl(enc_len);
    ih->flags = IKEPACKET_ENCRYPT;
    enc_len = save_enc_len;
#ifdef TEST_CONFORMITY
    pikepckt = &p1R->P_3;
    pC_pikepckt = p1R;
    //CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1R->P_3));
#endif  /* TEST_CONFORMITY */
    CERR(r->plg->p1_EncapFn(r->p1, 0, buf, &enc_len, sizeof(buf)));

    // --------------Initiator
    // Receive HDR*<IDir, [CERTr], SIG_R>
#ifdef TEST_CONFORMITY
    //CERR(reinitvblob(DT_BYTE, (LPBYTE)r->p1->Last_ICV,  4, &p1R->LastICV));
    p1R->P_3=*pikepckt;
    CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1I->P_3, p1I, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    CERR(i->plg->p1_DecapFn(i->p1, 0, buf, &enc_len));
    dec_len=sizeof(ikeHDR);

    {
	vblob *IDr_b_rcv;
	vblob *CERTr_b_rcv;
	vblob *SIG_R_rcv;
	//    vblob/    
#ifndef TEST_CONFORMITY
	CERR(recv4buf(&IDr_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	CERR(recv4buf(&CERTr_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	CERR(recv4buf(&SIG_R_rcv, DT_SIG_IR, buf, &dec_len, enc_len));
	// XXX dim:   r->ID_b  IDr_b_rcv
	// XXX dim:   r->CERT_b  CERTr_b_rcv
	// XXX dim:   SIG_R  SIG_R_rcv
#else
	PlT.curr=Identification;
	CERR(recv4bufex(&PlT, &IDr_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	PlT.curr=Certificate;
	CERR(recv4bufex(&PlT, &CERTr_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	PlT.curr=Signature;
	CERR(recv4bufex(&PlT, &SIG_R_rcv, DT_SIG_IR, buf, &dec_len, enc_len));
	//CERR(reinitvblob(DT_BYTE, (LPBYTE)i->p1->Last_ICV,  4, &p1I->LastICV));
#endif  /* TEST_CONFORMITY */
	vdelete(&IDr_b_rcv);
	vdelete(&CERTr_b_rcv);
	vdelete(&SIG_R_rcv);
    }

    //    
    //       example.cpp:check_get_cert()
    //    --  
    pCertCtx = ::CertCreateCertificateContext(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING, (LPCBYTE)vref( r->CERT_b ), vsize( r->CERT_b ));
    CERR(i->plg->p1_SetOtherCertFn(i->p1, r->BLOB_b, r->CERT_b, 0));
    CertFreeCertificateContext(pCertCtx);
    pCertCtx = 0;

    //  ""   -->     
    CERR(i->plg->p1_VerifyIRFn(i->p1, r->ID_b, pSIG_R, 0));
    vdelete(&pSIG_R);

    return 0;

err:
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    return rc;
}

unsigned
ph1_SIGNATURE_Aggressive(p1_ir_state *i, p1_ir_state *r)
{
    unsigned rc;
    int line;
    unsigned enc_len, save_enc_len, dec_len;
    vblob *pSIG_I;
    vblob *pSIG_R;
    vblob *pKEi_b;
    vblob *pKEr_b;
    vblob *pNi_b;
    vblob *pNr_b;
    vblob * CertI = NULL;
    vblob * CertR = NULL;

    // --------------Initiator
    CERR(i->plg->p1_CreateFn(i->plg,
			     i->Vendor_IDs, i->SAtype.am,
			     IKE_INITIATOR,
			     i->SAtype.enc_mac_id, i->SAtype.hash_id,
			     i->SAtype.gtype_id, i->SAtype.group_id,
			     0,
			     &i->p1));
    //   ( RECOMMENDED   )
    //i->plg->p1_SetParamFn(i->p1, CPIKE_AC_Life_Duration, 31*24*60*60, CPIKE_LIFET_SECONDS /*1 */, 0);
    //i->plg->p1_SetParamFn(i->p1, CPIKE_AC_Max_Messages, CPIKE_NONPFS_MAX_MSGS, 0 /*64*/, 0);
    //i->plg->p1_SetParamFn(i->p1, CPIKE_AC_PFS_Control, CPIKE_PFSC_Enable_Non_PFS, 0, 0);

    CERR(i->plg->p1_SetupFn(i->p1, i->CKY, 0, &pKEi_b, &pNi_b));

    // Send HDR(CKYi,0)<SA,KEi,Ni>
    // --------------Responder
    // Receive HDR(CKYi,0)<SA,KEi,Ni>

    CERR(r->plg->p1_CreateFn(r->plg,
			     r->Vendor_IDs, r->SAtype.am,
			     IKE_RESPONDER,
			     r->SAtype.enc_mac_id, r->SAtype.hash_id,
			     r->SAtype.gtype_id, r->SAtype.group_id,
			     0,
			     &r->p1));
    //   ( RECOMMENDED   )
    r->plg->p1_SetParamFn(r->p1, CPIKE_AC_Life_Duration, 31*24*60*60, CPIKE_LIFET_SECONDS /*1 */, 0);
    r->plg->p1_SetParamFn(r->p1, CPIKE_AC_Max_Messages, CPIKE_NONPFS_MAX_MSGS, 0 /*64*/, 0);
    r->plg->p1_SetParamFn(r->p1, CPIKE_AC_PFS_Control, CPIKE_PFSC_Enable_Non_PFS, 0, 0);

    CERR(r->plg->p1_SetupFn(r->p1, r->CKY, 0, &pKEr_b, &pNr_b));
    CERR(r->plg->p1_AgreeFn(r->p1, r->SA_b, pKEi_b, pNi_b, i->CKY, 0));
    vdelete(&pKEi_b);
    vdelete(&pNi_b);

    //  ,    .
    //   : . example.cpp:check_get_cert()
    // -->    
    HCRYPTMODULE hModuleTemp;
    HCRYPTPROV hP;
    hModuleTemp = GetNewModule_Crypt();
    if( CapiAcquireContext( hModuleTemp, &hP, (CHAR *)r->pszCont, r->pszProv, r->dwPT, r->dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001)) {
	line = __LINE__;
	rc = GetLastError();
	example_certificate_usage();
	goto err;
    }
    CERR( CapiSetProvParam( hModuleTemp, hP, PP_KEYEXCHANGE_PIN, (BYTE *)r->pbPIN, 0 ) );

#if defined TEST_CONFORMITY
    {
	CHAR * pContName = (CHAR*)malloc(strlen(r->pszCont) + 2);
	if (!pContName)
	{
	    line = __LINE__;
	    goto err;
	}
	strcpy(pContName, r->pszCont);
	strcpy(pContName + strlen(r->pszCont), "2");

	HCRYPTPROV hProvTmp;
	HCRYPTKEY hKeyTmp;
	if (CapiAcquireContext(hModuleTemp, &hProvTmp, pContName, r->pszProv, r->dwPT, r->dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001)) {
	    line = __LINE__;
	    rc = GetLastError();
	    free(pContName);
	    example_certificate_usage();
	    goto err;
	}
	free(pContName);
	CERR(CapiSetProvParam(hModuleTemp, hProvTmp, PP_KEYEXCHANGE_PIN, r->pbPIN, 0));
	CERR(CapiGetUserKey(hModuleTemp, hProvTmp, AT_KEYEXCHANGE, &hKeyTmp));
	BYTE pbCert[4096];
	DWORD dwCert = sizeof(pbCert);
	CERR(CapiGetKeyParam(hModuleTemp, hProvTmp, hKeyTmp, KP_CERTIFICATE, pbCert, &dwCert, 0));
	CertR = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)pbCert, dwCert);
	CERR(CapiDestroyKey(hModuleTemp, hProvTmp, hKeyTmp));
	CERR(CapiReleaseContext(hModuleTemp, hProvTmp, 0));
    }
#endif
    PRIVKEY hPrivR;
    hPrivR.hModule = hModuleTemp;
    hPrivR.hProv = hP;
    hPrivR.hKey = 0;
    CERR(r->plg->p1_SetMyCertProvFn(r->p1, &hPrivR, CertR, 0));
    CERR(r->plg->p1_AuthIRFn(r->p1, r->ID_b, 0, &pSIG_R));

    CERR( CapiReleaseContext( hModuleTemp, hP, 0 ) );
    vdelete(&CertR);
    hP = 0;

    // Send HDR(CKYi,CKYr)<SA,KEr,Nr,IDir,[CERTr],SIG_R>
    // --------------Initiator
    // Receive HDR(CKYi,CKYr)<SA,KEr,Nr,IDir,[CERTr],SIG_R>
    CERR(i->plg->p1_AgreeFn(i->p1, i->SA_b, pKEr_b, pNr_b, r->CKY, 0));
    vdelete(&pKEr_b);
    vdelete(&pNr_b);

    if( CapiAcquireContext( hModuleTemp, &hP, (CHAR *)i->pszCont, i->pszProv, i->dwPT, i->dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001)) {
	line = __LINE__;
	rc = GetLastError();
	example_certificate_usage();
	goto err;
    }
    CERR(CapiSetProvParam(hModuleTemp, hP, PP_KEYEXCHANGE_PIN, (BYTE *)i->pbPIN, 0));
    
#if defined TEST_CONFORMITY
    {
	CHAR * pContName = (CHAR*)malloc(strlen(i->pszCont) + 2);
	if (!pContName)
	{
	    line = __LINE__;
	    goto err;
	}
	strcpy(pContName, i->pszCont);
	strcpy(pContName + strlen(i->pszCont), "2");

	HCRYPTPROV hProvTmp;
	HCRYPTKEY hKeyTmp;
	if (CapiAcquireContext(hModuleTemp, &hProvTmp, pContName, i->pszProv, i->dwPT, i->dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001)) {
	    line = __LINE__;
	    rc = GetLastError();
	    free(pContName);
	    example_certificate_usage();
	    goto err;
	}
	free(pContName);
	CERR(CapiSetProvParam(hModuleTemp, hProvTmp, PP_KEYEXCHANGE_PIN, i->pbPIN, 0));
	CERR(CapiGetUserKey(hModuleTemp, hProvTmp, AT_KEYEXCHANGE, &hKeyTmp));
	BYTE pbCert[4096];
	DWORD dwCert = sizeof(pbCert);
	CERR(CapiGetKeyParam(hModuleTemp, hProvTmp, hKeyTmp, KP_CERTIFICATE, pbCert, &dwCert, 0));
	CertI = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)pbCert, dwCert);
	CERR(CapiDestroyKey(hModuleTemp, hProvTmp, hKeyTmp));
	CERR(CapiReleaseContext(hModuleTemp, hProvTmp, 0));
    }
#endif
    PRIVKEY hPrivI;
    hPrivI.hModule = hModuleTemp;
    hPrivI.hProv = hP;
    hPrivI.hKey = 0;
    CERR(i->plg->p1_SetMyCertProvFn(i->p1, &hPrivI, CertI, 0));
    CERR(i->plg->p1_AuthIRFn(i->p1, i->ID_b, 0, &pSIG_I));
    CERR( CapiReleaseContext( hModuleTemp, hP, 0 ) );
    hP = 0;
    ReleaseModule_Crypt( hModuleTemp );
    vdelete(&CertI);

    //    
    //       example.cpp:check_get_cert()
    //    --  
    PCCERT_CONTEXT pCertCtx;
    pCertCtx = ::CertCreateCertificateContext(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING, (LPCBYTE)vref( r->CERT_b ), vsize( r->CERT_b ));
    CERR(i->plg->p1_SetOtherCertFn(i->p1, r->BLOB_b, r->CERT_b, 0));
    CertFreeCertificateContext(pCertCtx);
    pCertCtx = 0;

    CERR(i->plg->p1_VerifyIRFn(i->p1, r->ID_b, pSIG_R, 0));
    vdelete(&pSIG_R);

    // Send HDR*<IDii,[CERTi],SIG_I>
    memset(buf, 0, sizeof(buf) );
    memcpy(ih->CKY_I, vref((vblob *)i->CKY), sizeof(ih->CKY_I));
    memcpy(ih->CKY_R, vref((vblob *)r->CKY), sizeof(ih->CKY_R));
    memset(ih->MessageID, 0, sizeof(ih->MessageID));
    enc_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    CERR(send2buf(i->ID_b, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(i->CERT_b, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(pSIG_I, buf, &enc_len, sizeof(buf)));

    unsigned al;
    char *d;
    vblob *v;
    al = 42;
    al *= 4;			//  Payloads ..  4
    d = (char*) calloc(al,1);
    v = vcreate( GetCPCConfig(), DT_EXTDATA, d, al);
    CERR(send2buf(v, buf, &enc_len, sizeof(buf)));
    vdelete(&v);
    free(d);
#else
    PLTYPE PlT;
    ih->next_header = Identification;
    ih->version = 1; 
    ih->exchange_type = 0;//Aggressive;
    ih->flags = IKEPACKET_ENCRYPT;
    PlT.next=Certificate;	PlT.curr=Identification;
    PlT.id=ID_IPV4_ADDR;
    CERR(send2bufex(PlT, i->ID_b, buf, &enc_len, sizeof(buf)));
    PlT.next=Signature;		PlT.curr=Certificate;
    PlT.cert=X_509_Certificate_Signature;
    CERR(send2bufex(PlT, i->CERT_b, buf, &enc_len, sizeof(buf)));
    PlT.next=0;			PlT.curr=Signature;	
    CERR(send2bufex(PlT, pSIG_I, buf, &enc_len, sizeof(buf)));
    CERR(reinitvblob(DT_BYTE, (BYTE*)vref( r->CERT_b ), (DWORD)vsize( r->CERT_b ), &p1R->SigCert, p1R, __FUNCTION__, __LINE__));
    CERR(reinitvblob(DT_BYTE, (BYTE*)vref( i->CERT_b ), (DWORD)vsize( i->CERT_b ), &p1I->SigCert, p1I, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */

    save_enc_len = enc_len;
    CERR(i->plg->p1_EncapFn(i->p1, 0, NULL, &enc_len, sizeof(buf)));
    ih->Length = htonl(enc_len);
    ih->flags = IKEPACKET_ENCRYPT;
    enc_len = save_enc_len;
#ifdef TEST_CONFORMITY
    pikepckt = &p1I->P_2;
    pC_pikepckt = p1I;
    //CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1I->P_2));
#endif  /* TEST_CONFORMITY */
    CERR(i->plg->p1_EncapFn(i->p1, 0, buf, &enc_len, sizeof(buf)));

    // --------------Responder
    // Receive HDR*<IDii, [CERTi], SIG_I>
#ifdef TEST_CONFORMITY
    //CERR(reinitvblob(DT_BYTE, (LPBYTE)i->p1->Last_ICV,  4, &p1I->LastICV));
    p1I->P_2=*pikepckt;
    CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1R->P_2, p1R, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    CERR(r->plg->p1_DecapFn(r->p1, 0, buf, &enc_len));
    dec_len=sizeof(ikeHDR);
    {
	vblob *IDi_b_rcv;
	vblob *CERTi_b_rcv;
	vblob *SIG_I_rcv;
	//    vblob/    
#ifndef TEST_CONFORMITY
	CERR(recv4buf(&IDi_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	CERR(recv4buf(&CERTi_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	CERR(recv4buf(&SIG_I_rcv, DT_SIG_IR, buf, &dec_len, enc_len));
	// XXX dim:   IDi_b  IDi_b_rcv
	// XXX dim:   i->CERT_b  CERTi_b_rcv
	// XXX dim:   SIG_I  SIG_I_rcv
#else
	PlT.curr=Identification;
	CERR(recv4bufex(&PlT, &IDi_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	PlT.curr=Certificate;
	CERR(recv4bufex(&PlT, &CERTi_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	PlT.curr=Signature;
	CERR(recv4bufex(&PlT, &SIG_I_rcv, DT_SIG_IR, buf, &dec_len, enc_len));
	//CERR(reinitvblob(DT_BYTE, (LPBYTE)r->p1->Last_ICV,  4, &p1R->LastICV));
#endif  /* TEST_CONFORMITY */
	vdelete(&IDi_b_rcv);
	vdelete(&CERTi_b_rcv);
	vdelete(&SIG_I_rcv);
    }

    //    
    //       example.cpp:check_get_cert()
    //    --  
    pCertCtx = ::CertCreateCertificateContext(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING, (LPCBYTE)vref( i->CERT_b ), vsize( i->CERT_b ));
    CERR(r->plg->p1_SetOtherCertFn(r->p1, i->BLOB_b, i->CERT_b, 0));
    CertFreeCertificateContext(pCertCtx);
    pCertCtx = 0;

    CERR(r->plg->p1_VerifyIRFn(r->p1, i->ID_b, pSIG_I, 0));
    vdelete(&pSIG_I);

    return 0;

err:
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    return rc;
}
