/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2005-2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 *
 * \brief
 *
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef HAVE_CPRO_CONFIG_H
#include "myconfig.h"
#endif

#ifdef _WIN32
#   include <Windows.h>
#   include <WinCrypt.h>
#   include "platformstream.h"
#else
#   include <arpa/inet.h> // htonl()
#endif
#include "wincspc.h"
#include "typedefs.h"
#include "ike_gost.h"
#include "init_plg.h"
#include "example.h"

#ifdef TEST_CONFORMITY
#include "../../Conformity/ConformityIPSEC.h"
extern vblob **pikepckt;
extern LPCONF_IPSEC pC_pikepckt;
#include "ConformityIKEp1.h"
#endif  /* TEST_CONFORMITY */
#define IKEPACKET_ENCRYPT 1

static char buf[10000];
static ikeHDR *ih = (ikeHDR*) buf;

unsigned
ph1_PSK_Main(p1_ir_state *i, p1_ir_state *r, unsigned uFlags)
{
    unsigned rc = CAPI_INTERNAL_ERROR;
    int line;
    unsigned enc_len, save_enc_len, dec_len;
    vblob *pHASH_I;
    vblob *pHASH_R;
    vblob *pKEi_b;
    vblob *pKEr_b;
    vblob *pNi_b;
    vblob *pNr_b;

    HCRYPTMODULE hModuleI = GetNewModule_Crypt();
    HCRYPTPROV hProvI = 0;
    HCRYPTKEY hKeyI = 0;
    HCRYPTMODULE hModuleR = GetNewModule_Crypt();
    HCRYPTPROV hProvR = 0;    
    HCRYPTKEY hKeyR = 0;

    // --------------Initiator
    // Send HDR(CKYi,0)<SA>

    // --------------Responder
    // Receive HDR(CKYi,0)<SA>

    CERR(r->plg->p1_CreateFn(r->plg,
			     r->Vendor_IDs, r->SAtype.am,
			     IKE_RESPONDER,
			     r->SAtype.enc_mac_id, r->SAtype.hash_id,
			     r->SAtype.gtype_id, r->SAtype.group_id,
			     0,
			     &r->p1));
    //   ( RECOMMENDED   )
    //r->plg->p1_SetParamFn(r->p1, CPIKE_AC_Life_Duration, 31*24*60*60, CPIKE_LIFET_SECONDS /*1 */, 0);
    //r->plg->p1_SetParamFn(r->p1, CPIKE_AC_Max_Messages, CPIKE_NONPFS_MAX_MSGS, 0 /*64*/, 0);
    //r->plg->p1_SetParamFn(r->p1, CPIKE_AC_PFS_Control, CPIKE_PFSC_Enable_Non_PFS, 0, 0);

    time_t tNotAfter;
    CERR(r->plg->getPSKnotAfterFn(r->plg, r->PSK, r->NetID, r->Site_ID, 0, &tNotAfter));
    CERR(correct_p1_LifeDur(r->plg, r->p1, tNotAfter));

    // Send HDR(CKYi,CKYr)<SA>

    // --------------Initiator
    // Receive HDR<SA>

    CERR(i->plg->p1_CreateFn(i->plg,
			     i->Vendor_IDs, i->SAtype.am,
			     IKE_INITIATOR,
			     i->SAtype.enc_mac_id, i->SAtype.hash_id,
			     i->SAtype.gtype_id, i->SAtype.group_id,
			     0,
			     &i->p1));
    //   ( RECOMMENDED   )
    i->plg->p1_SetParamFn(i->p1, CPIKE_AC_Life_Duration, 31*24*60*60, CPIKE_LIFET_SECONDS /*1 */, 0);
    i->plg->p1_SetParamFn(i->p1, CPIKE_AC_Max_Messages, CPIKE_NONPFS_MAX_MSGS, 0 /*64*/, 0);
    i->plg->p1_SetParamFn(i->p1, CPIKE_AC_PFS_Control, CPIKE_PFSC_Enable_Non_PFS, 0, 0);

    CERR(i->plg->getPSKnotAfterFn(i->plg, i->PSK, i->NetID, i->Site_ID, 0, &tNotAfter));
    CERR(correct_p1_LifeDur(i->plg, i->p1, tNotAfter));

    CERR(i->plg->p1_SetupFn(i->p1, i->CKY, 0, &pKEi_b, &pNi_b));
    // Send HDR<KEi, Ni>

    // --------------Responder
    // Receive HDR<KEi, Ni>
    

#if defined _WIN32
    static char ContainerIName[] = "\\\\.\\REGISTRY\\ike_example_I";
    static char ContainerRName[] = "\\\\.\\REGISTRY\\ike_example_R";
#else
    static char ContainerIName[] = "\\\\.\\hdimage\\ike_example_I";
    static char ContainerRName[] = "\\\\.\\hdimage\\ike_example_R";
#endif	// _WIN32
    static BYTE ContainerIPin[] = "123456";
    static BYTE ContainerRPin[] = "654321";

    if( uFlags == P1_SETPSK_HCRYPT && (
	ikeGetPSKKeyFromContainer( DEFAULT_PROV_NAME_A, ContainerIName, ContainerIPin, &hKeyI, &hProvI ) != CAPI_NOERROR ||
	ikeGetPSKKeyFromContainer( DEFAULT_PROV_NAME_A, ContainerRName, ContainerRPin, &hKeyR, &hProvR ) != CAPI_NOERROR ) )
    {
	BYTE bBlob[MAX_PRIVATEKEYBLOB_LEN];
	DWORD dwLen = sizeof( bBlob );
	DWORD dwTemp = CALG_PRO_EXPORT;
	HCRYPTKEY hKeyI_AT = 0;
	HCRYPTKEY hKeyR_AT = 0;
	HCRYPTHASH hHashI = 0;
	HCRYPTHASH hHashR = 0;
	static const BYTE SuperSecret[] = "012342034289034792384790238479287427534853439048509385012849012342913481234-284";
	CryptAcquireContextA( &hProvI, ContainerIName, DEFAULT_PROV_NAME_A, PROV_GOST_2001_DH, CRYPT_DELETEKEYSET );
	CryptAcquireContextA( &hProvR, ContainerRName, DEFAULT_PROV_NAME_A, PROV_GOST_2001_DH, CRYPT_DELETEKEYSET );
	{
	    CERR( !CryptAcquireContextA( &hProvI, ContainerIName, DEFAULT_PROV_NAME_A, PROV_GOST_2001_DH, CRYPT_NEWKEYSET ) );
	    CERR( !CryptSetProvParam( hProvI, PP_KEYEXCHANGE_PIN, (BYTE *)ContainerIPin, 0 ) );
	    CERR( !CryptGenKey( hProvI, AT_KEYEXCHANGE, CRYPT_EXPORTABLE, &hKeyI_AT ) );
	    CERR( !CryptCreateHash( hProvI, CALG_GR3411, 0, 0, &hHashI ) );
	    CERR( !CryptHashData( hHashI, SuperSecret, sizeof(SuperSecret), 0 ) );
	    CERR( !CryptDeriveKey( hProvI, CALG_G28147, hHashI, CRYPT_EXPORTABLE, &hKeyI ) );
	    CERR( !CryptSetKeyParam( hKeyI, KP_ALGID, (BYTE *)&dwTemp, 0 ) );
	    CERR( !CryptExportKey( hKeyI_AT, hKeyI, PRIVATEKEYBLOB, 0, bBlob, &dwLen ) );
	    CERR( !CryptAcquireContextA( &hProvR, ContainerRName, DEFAULT_PROV_NAME_A, PROV_GOST_2001_DH, CRYPT_NEWKEYSET ) );
	    CERR( !CryptSetProvParam( hProvR, PP_KEYEXCHANGE_PIN, (BYTE *)ContainerRPin, 0 ) );
	    CERR( !CryptCreateHash( hProvR, CALG_GR3411, 0, 0, &hHashR ) );
	    CERR( !CryptHashData( hHashR, SuperSecret, sizeof(SuperSecret), 0 ) );
	    CERR( !CryptDeriveKey( hProvR, CALG_G28147, hHashI, CRYPT_EXPORTABLE, &hKeyR ) );
	    CERR( !CryptSetKeyParam( hKeyR, KP_ALGID, (BYTE *)&dwTemp, 0 ) );
	    CERR( !CryptImportKey( hProvR, bBlob, dwLen, hKeyR, 0, &hKeyR_AT ) );
	    CERR( !CryptReleaseContext( hProvI, 0 ) );
	    CERR( !CryptReleaseContext( hProvR, 0 ) );
	}
	{
	    hProvI = 0;
	    hKeyI = 0;
	    hProvR = 0;
	    hKeyR = 0;
	    if( ikeGetPSKKeyFromContainer( DEFAULT_PROV_NAME_A, ContainerIName, ContainerIPin, &hKeyI, &hProvI ) != CAPI_NOERROR ||
		ikeGetPSKKeyFromContainer( DEFAULT_PROV_NAME_A, ContainerRName, ContainerRPin, &hKeyR, &hProvR ) != CAPI_NOERROR )
		CERR( true );
	}
    }
    
    CERR(r->plg->p1_SetupFn(r->p1, r->CKY, 0, &pKEr_b, &pNr_b));
    if( uFlags == P1_SETPSK_HCRYPT )
    {
	CERR(r->plg->p1_SetPSKFn(r->p1, (vblob *)hKeyR, (vblob *)hProvR, (vblob *)hModuleR, P1_SETPSK_HCRYPT));
    }
    else
    {
	CERR(r->plg->p1_SetPSKFn(r->p1, r->PSK, r->NetID, r->Site_ID, 0));
    }    
    CERR(r->plg->p1_AgreeFn(r->p1, r->SA_b, pKEi_b, pNi_b, i->CKY, 0));
    vdelete(&pKEi_b);
    vdelete(&pNi_b);

    // Send HDR<KEr, Nr>

    // --------------Initiator
    // Receive HDR<KEr, Nr>

    if( uFlags == P1_SETPSK_HCRYPT )
    {
	CERR(r->plg->p1_SetPSKFn(i->p1, (vblob *)hKeyI, (vblob *)hProvI, (vblob *)hModuleI, P1_SETPSK_HCRYPT));
    }
    else
    {
	CERR(i->plg->p1_SetPSKFn(i->p1, i->PSK, i->NetID, i->Site_ID, 0));
    }
    CERR(i->plg->p1_AgreeFn(i->p1, i->SA_b, pKEr_b, pNr_b, r->CKY, 0));
    vdelete(&pKEr_b);
    vdelete(&pNr_b);

    if( uFlags == P1_SETPSK_HCRYPT )
    {
	ikeReleasePSKKeyFromContainer( hKeyI, hProvI );
	ikeReleasePSKKeyFromContainer( hKeyR, hProvR );
	hKeyI = 0;
	hProvI = 0;
	ReleaseModule_Crypt( hModuleI );
	hKeyR = 0;
	hProvR = 0;
	ReleaseModule_Crypt( hModuleR );
    }

    CERR(i->plg->p1_AuthIRFn(i->p1, i->ID_b, 0, &pHASH_I));

    // Send HDR*<IDii,HASH_I>
    memset(buf, 0, sizeof(buf));
    memcpy(ih->CKY_I, vref((vblob *)i->CKY), sizeof(ih->CKY_I));
    memcpy(ih->CKY_R, vref((vblob *)r->CKY), sizeof(ih->CKY_R));
    memset(ih->MessageID, 0, sizeof(ih->MessageID));
    enc_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    CERR(send2buf(i->ID_b, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(pHASH_I, buf, &enc_len, sizeof(buf)));

    unsigned al;
    char *d;
    vblob *v;
    al = 42;
    al *= 4;			//  Payloads ..  4
    d = (char*) calloc(al,1);
    v = vcreate(GetCPCConfig(), DT_EXTDATA, d, al);
    CERR(send2buf(v, buf, &enc_len, sizeof(buf)));
    vdelete(&v);
    free(d);
#else
    PLTYPE PlT;
    ih->next_header = Identification;
    ih->version = 1; 
    ih->exchange_type = 0;//Identity_Protection;
    ih->flags = IKEPACKET_ENCRYPT;
    PlT.next=tHash;		PlT.curr=Identification;	
    PlT.id=ID_IPV4_ADDR;
    CERR(send2bufex(PlT,i->ID_b, buf, &enc_len, sizeof(buf)));
    PlT.next=0;			PlT.curr=tHash;
    CERR(send2bufex(PlT, pHASH_I, buf, &enc_len, sizeof(buf)));
#endif  /* TEST_CONFORMITY */

    save_enc_len = enc_len;
    CERR(i->plg->p1_EncapFn(i->p1, 0, NULL, &enc_len, sizeof(buf)));
    ih->Length = htonl(enc_len);
    ih->flags = IKEPACKET_ENCRYPT;
    enc_len = save_enc_len;
#ifdef TEST_CONFORMITY 
    pikepckt = &p1I->P_2;
    pC_pikepckt = p1I;
    //CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1I->P_2));
#endif  /* TEST_CONFORMITY */
    CERR(i->plg->p1_EncapFn(i->p1, 0, buf, &enc_len, sizeof(buf)));

    // --------------Responder
    // Receive HDR*<IDii,HASH_I>
#ifdef TEST_CONFORMITY
    p1I->P_2=*pikepckt;
    CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1R->P_2, p1R, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    CERR(r->plg->p1_DecapFn(r->p1, 0, buf, &enc_len));
    dec_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    {
	vblob *IDi_b_rcv;
	vblob *HASH_I_rcv;
	//    vblob/    
	CERR(recv4buf(&IDi_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	CERR(recv4buf(&HASH_I_rcv, DT_HASH_IR, buf, &dec_len, enc_len));
	// XXX dim:   HASH_I  HASH_I_rcv
	// XXX dim:   IDi_b  IDi_b_rcv
	vdelete(&IDi_b_rcv);
	vdelete(&HASH_I_rcv);
    }
#else
    PlT.curr=Identification;
    CERR(recv4bufex(&PlT, 0, DT_EXTDATA, buf, &dec_len, enc_len));
    PlT.curr=tHash;
    CERR(recv4bufex(&PlT, 0, DT_HASH_IR, buf, &dec_len, enc_len));
#endif  /* TEST_CONFORMITY */

    CERR(r->plg->p1_AuthIRFn(r->p1, r->ID_b, 0, &pHASH_R));
    //  Decap/recv4buf   -->   "",    
    CERR(r->plg->p1_VerifyIRFn(r->p1, i->ID_b, pHASH_I, 0));
    vdelete(&pHASH_I);

    // Send HDR*<IDir,HASH_R>
    memset(buf, 0, sizeof(buf));
    memcpy(ih->CKY_I, vref((vblob *)i->CKY), sizeof(ih->CKY_I));
    memcpy(ih->CKY_R, vref((vblob *)r->CKY), sizeof(ih->CKY_R));
    memset(ih->MessageID, 0, sizeof(ih->MessageID));
    enc_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    CERR(send2buf(r->ID_b, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(pHASH_R, buf, &enc_len, sizeof(buf)));

    al = 42;
    al *= 4;			//  Payloads ..  4
    d = (char*) calloc(al,1);
    v = vcreate(GetCPCConfig(), DT_EXTDATA, d, al);
    CERR(send2buf(v, buf, &enc_len, sizeof(buf)));
    vdelete(&v);
    free(d);
#else
    ih->next_header = Identification;
    ih->version = 1; 
    ih->exchange_type = 0;//Identity_Protection;
    ih->flags = IKEPACKET_ENCRYPT;
    PlT.next=tHash;	    PlT.curr=Identification;	
    PlT.id=ID_IPV4_ADDR;
    CERR(send2bufex(PlT, r->ID_b, buf, &enc_len, sizeof(buf)));
    PlT.next=0;		    PlT.curr=tHash;
    CERR(send2bufex(PlT, pHASH_R, buf, &enc_len, sizeof(buf)));
#endif  /* TEST_CONFORMITY */

    save_enc_len = enc_len;
    CERR(r->plg->p1_EncapFn(r->p1, 0, NULL, &enc_len, sizeof(buf)));
    ih->Length = htonl(enc_len);
    ih->flags = IKEPACKET_ENCRYPT;
    enc_len = save_enc_len;
#ifdef TEST_CONFORMITY
    pikepckt = &p1R->P_3;
    pC_pikepckt = p1R;
    //CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1R->P_3));
#endif  /* TEST_CONFORMITY */
    CERR(r->plg->p1_EncapFn(r->p1, 0, buf, &enc_len, sizeof(buf)));

    // --------------Initiator
    // Receive HDR*<IDir,HASH_R>
#ifdef TEST_CONFORMITY
    //CERR(reinitvblob(DT_BYTE, r->p1->Last_ICV, 4, &p1R->LastICV));
    p1R->P_3=*pikepckt;
    CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1I->P_3, p1I, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    CERR(i->plg->p1_DecapFn(i->p1, 0, buf, &enc_len));
    dec_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    {
	vblob *IDr_b_rcv;
	vblob *HASH_R_rcv;
	//    vblob/    
	CERR(recv4buf(&IDr_b_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	CERR(recv4buf(&HASH_R_rcv, DT_HASH_IR, buf, &dec_len, enc_len));
	// XXX dim:   HASH_R  HASH_R_rcv
	// XXX dim:   IDr_b  IDr_b_rcv
	vdelete(&IDr_b_rcv);
	vdelete(&HASH_R_rcv);
    }
#else
    PlT.curr=Identification;	
    CERR(recv4bufex(&PlT, 0, DT_EXTDATA, buf, &dec_len, enc_len));
    PlT.curr=tHash;
    CERR(recv4bufex(&PlT, 0, DT_HASH_IR, buf, &dec_len, enc_len));
    //CERR(reinitvblob(DT_BYTE, i->p1->Last_ICV,  4, &p1I->LastICV));
#endif  /* TEST_CONFORMITY */
    //  Decap/recv4buf   -->   "",    
    CERR(i->plg->p1_VerifyIRFn(i->p1, r->ID_b, pHASH_R, 0));
    vdelete(&pHASH_R);

    return 0;

err:
    if( uFlags == P1_SETPSK_HCRYPT && hModuleI )
    {
	ikeReleasePSKKeyFromContainer( hKeyI, hProvI );
	ikeReleasePSKKeyFromContainer( hKeyR, hProvR );
	hKeyI = 0;
	hProvI = 0;
	ReleaseModule_Crypt( hModuleI );
	hKeyR = 0;
	hProvR = 0;
	ReleaseModule_Crypt( hModuleR );
    }
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    return rc;
}

unsigned
ph1_PSK_Aggressive(p1_ir_state *i, p1_ir_state *r)
{
    unsigned rc = CAPI_INTERNAL_ERROR;
    int line;
    unsigned enc_len, save_enc_len, dec_len;
    vblob *pHASH_I;
    vblob *pHASH_R;
    vblob *pKEi_b;
    vblob *pKEr_b;
    vblob *pNi_b;
    vblob *pNr_b;

    // --------------Initiator

    CERR(i->plg->p1_CreateFn(i->plg,
			    i->Vendor_IDs, i->SAtype.am,
			    IKE_INITIATOR,
			    i->SAtype.enc_mac_id, i->SAtype.hash_id,
			    i->SAtype.gtype_id, i->SAtype.group_id,
			    0,
			    &i->p1));
    //   ( RECOMMENDED   )
    //i->plg->p1_SetParamFn(i->p1, CPIKE_AC_Life_Duration, 31*24*60*60, CPIKE_LIFET_SECONDS /*1 */, 0);
    //i->plg->p1_SetParamFn(i->p1, CPIKE_AC_Max_Messages, CPIKE_NONPFS_MAX_MSGS, 0 /*64*/, 0);
    //i->plg->p1_SetParamFn(i->p1, CPIKE_AC_PFS_Control, CPIKE_PFSC_Enable_Non_PFS, 0, 0);

    time_t tNotAfter;
    CERR(i->plg->getPSKnotAfterFn(i->plg, i->PSK, i->NetID, i->Site_ID, 0, &tNotAfter));
    CERR(correct_p1_LifeDur(i->plg, i->p1, tNotAfter));

    CERR(i->plg->p1_SetupFn(i->p1, i->CKY, 0, &pKEi_b, &pNi_b));

    // Send HDR(CKYi,0)<SA,KEi,Ni,IDii>

    // --------------Responder
    // Receive HDR(CKYi,0)<SA,KEi,Ni,IDii>

    CERR(r->plg->p1_CreateFn(r->plg,
			    r->Vendor_IDs, r->SAtype.am,
			    IKE_RESPONDER,
			    r->SAtype.enc_mac_id, r->SAtype.hash_id,
			    r->SAtype.gtype_id, r->SAtype.group_id,
			    0,
			    &r->p1));
    //   ( RECOMMENDED   )
    r->plg->p1_SetParamFn(r->p1, CPIKE_AC_Life_Duration, 31*24*60*60, CPIKE_LIFET_SECONDS /*1 */, 0);
    r->plg->p1_SetParamFn(r->p1, CPIKE_AC_Max_Messages, CPIKE_NONPFS_MAX_MSGS, 0 /*64*/, 0);
    r->plg->p1_SetParamFn(r->p1, CPIKE_AC_PFS_Control, CPIKE_PFSC_Enable_Non_PFS, 0, 0);

    CERR(r->plg->getPSKnotAfterFn(r->plg, r->PSK, r->NetID, r->Site_ID, 0, &tNotAfter));
    CERR(correct_p1_LifeDur(r->plg, r->p1, tNotAfter));

    CERR(r->plg->p1_SetupFn(r->p1, r->CKY, 0, &pKEr_b, &pNr_b));
    CERR(r->plg->p1_SetPSKFn(r->p1, r->PSK, r->NetID, r->Site_ID, 0));
    CERR(r->plg->p1_AgreeFn(r->p1, r->SA_b, pKEi_b, pNi_b, i->CKY, 0));
    vdelete(&pKEi_b);
    vdelete(&pNi_b);

    CERR(r->plg->p1_AuthIRFn(r->p1, r->ID_b, 0, &pHASH_R));

    // Send HDR(CKYi,CKYr)<SA,KEr,Nr,IDir,HASH_R>

    // --------------Initiator
    // Receive HDR<SA>

    CERR(i->plg->p1_SetPSKFn(i->p1, i->PSK, i->NetID, i->Site_ID, 0));
    CERR(i->plg->p1_AgreeFn(i->p1, i->SA_b, pKEr_b, pNr_b, r->CKY, 0));
    vdelete(&pKEr_b);
    vdelete(&pNr_b);

    CERR(i->plg->p1_AuthIRFn(i->p1, i->ID_b, 0, &pHASH_I));
    CERR(i->plg->p1_VerifyIRFn(i->p1, r->ID_b, pHASH_R, 0));
    vdelete(&pHASH_R);

    //   
    // Send HDR*<HASH_I>
    memset(buf, 0, sizeof(buf) );
    memcpy(ih->CKY_I, vref((vblob *)i->CKY), sizeof(ih->CKY_I));
    memcpy(ih->CKY_R, vref((vblob *)r->CKY), sizeof(ih->CKY_R));
    memset(ih->MessageID, 0, sizeof(ih->MessageID));
    enc_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    CERR(send2buf(pHASH_I, buf, &enc_len, sizeof(buf)));

    unsigned al;
    char *d;
    vblob *v;
    al = 42;
    al *= 4;			//  Payloads ..  4
    d = (char*) calloc(al,1);
    v = vcreate(GetCPCConfig(), DT_EXTDATA, d, al);
    CERR(send2buf(v, buf, &enc_len, sizeof(buf)));
    vdelete(&v);
    free(d);
#else
    PLTYPE PlT;
    ih->next_header = tHash;
    ih->version = 1; 
    ih->exchange_type = 0;//Aggressive;
    ih->flags = IKEPACKET_ENCRYPT;
    PlT.next=0;		    PlT.curr=tHash;
    CERR(send2bufex(PlT, pHASH_I, buf, &enc_len, sizeof(buf)));
#endif  /* TEST_CONFORMITY */

    save_enc_len = enc_len;
    CERR(i->plg->p1_EncapFn(i->p1, 0, NULL, &enc_len, sizeof(buf)));
    ih->Length = htonl(enc_len);
    ih->flags = IKEPACKET_ENCRYPT;
    enc_len = save_enc_len;
#ifdef TEST_CONFORMITY
    pikepckt = &p1I->P_2;
    pC_pikepckt = p1I;
    //CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1I->P_2));
#endif  /* TEST_CONFORMITY */
    CERR(i->plg->p1_EncapFn(i->p1, 0, buf, &enc_len, sizeof(buf)));

    // --------------Responder
    // Receive HDR*<HASH_I>
#ifdef TEST_CONFORMITY
    //CERR(reinitvblob(DT_BYTE, i->p1->Last_ICV,  4, &p1I->LastICV));
    p1I->P_2=*pikepckt;
    CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &p1R->P_2, p1R, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    CERR(r->plg->p1_DecapFn(r->p1, 0, buf, &enc_len));
    dec_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    {
	vblob *HASH_I_rcv;
	//    vblob/    
	CERR(recv4buf(&HASH_I_rcv, DT_HASH_IR, buf, &dec_len, enc_len));
	// XXX dim:   HASH_I  HASH_I_rcv
	vdelete(&HASH_I_rcv);
    }
#else
    PlT.curr=tHash;
    CERR(recv4bufex(&PlT, 0, DT_HASH_IR, buf, &dec_len, enc_len));
    //CERR(reinitvblob(DT_BYTE, r->p1->Last_ICV,  4, &p1R->LastICV));
#endif  /* TEST_CONFORMITY */

    //  Decap/recv4buf   -->   "",    
    CERR(r->plg->p1_VerifyIRFn(r->p1, i->ID_b, pHASH_I, 0));
    vdelete(&pHASH_I);

    return 0;

err:
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    return rc;
}
