/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2005-2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 *
 * \brief
 *
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef HAVE_CPRO_CONFIG_H
#include "myconfig.h"
#endif

#ifdef _WIN32
#   include <Windows.h>
#   include <WinCrypt.h>
#   include "platformstream.h"
#else
#   include <arpa/inet.h> // htonl()
#endif
#include "wincspc.h"
#include "ike_gost.h"
#include "init_plg.h"
#include "example.h"

#ifdef TEST_CONFORMITY
#   include "../../Conformity/ConformityIPSEC.h"
#endif  /* TEST_CONFORMITY */

static char buf[1000];
static ikeHDR *ih = (ikeHDR*) buf;

unsigned
phase_2_inf(p2_ir_state *i2, p2_ir_state *r2, bool new_group, bool is_cfgmode = true)
{
    unsigned rc;
    int line;

    unsigned enc_len, save_enc_len, dec_len;

    static const char d_M_ID[4] = { 'a', 'b', 'c', 'd'};
    vblob * M_ID = vcreate(GetCPCConfig(), DT_M_ID, (char *)d_M_ID, sizeof(d_M_ID));

    static const char d_NtfyDel[] = "Message";
    vblob * NtfyDel = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)d_NtfyDel, sizeof(d_NtfyDel));

    vblob *pHASH_1;

    //////////////////////////////////////////////////////////////////////////
    // N/D  (Notification or Deletion)
    // --------------Initiator
    P2_HANDLE p2_i;
    CERR(i2->plg->p2_CreateFn(i2->plg, i2->p1, IKE_INITIATOR, M_ID, 0, &p2_i));

    // HASH(1) = prf(SKEYID_a, M-ID | N/D)
    CERR(i2->plg->p2_HashAFn(p2_i, 0, &pHASH_1, 1, NtfyDel));

    // Send HDR*<HASH(1), N/D>
    memset(buf, 0, sizeof(buf));
    memcpy(ih->CKY_I, vref( (vblob *)i2->CKY ), sizeof(ih->CKY_I));
    memcpy(ih->CKY_R, vref( (vblob *)r2->CKY ), sizeof(ih->CKY_R));
    memcpy(ih->MessageID, vref( (vblob *)M_ID ), sizeof(ih->MessageID));
    enc_len=sizeof(ikeHDR);
    CERR(send2buf(pHASH_1, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(NtfyDel, buf, &enc_len, sizeof(buf)));
    save_enc_len = enc_len;
    CERR(i2->plg->p2_EncapFn(p2_i, 0, NULL, &enc_len, sizeof(buf)));
    ih->Length = htonl(enc_len);
    ih->flags = 1;
    ih->exchange_type = is_cfgmode ? 6 : 5;
    enc_len = save_enc_len;
    CERR(i2->plg->p2_EncapFn(p2_i, 0, buf, &enc_len, sizeof(buf)));

    // --------------Responder
    // Receive HDR*<HASH(1), N/D>
    P2_HANDLE p2_r;
    CERR(r2->plg->p2_CreateFn(r2->plg, r2->p1, IKE_RESPONDER, M_ID, 0, &p2_r));

    CERR(r2->plg->p2_DecapFn(p2_r, 0, buf, &enc_len));
    dec_len=sizeof(ikeHDR);
    {
	vblob *HASH_1_rcv;
	vblob *NtfyDel_rcv;
	CERR(recv4buf(&HASH_1_rcv, DT_HASH, buf, &dec_len, enc_len));
	CERR(recv4buf(&NtfyDel_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	//     
	vdelete(&HASH_1_rcv);
	vdelete(&NtfyDel_rcv);
    }
    // Verify HASH(1) = prf(SKEYID_a, M-ID | N/D)
    CERR(r2->plg->p2_VerifyAFn(p2_r, 0, pHASH_1, 1, NtfyDel));
    vdelete(&pHASH_1);
    vdelete(&NtfyDel);

    if(new_group) {
	//  ,  New Group Mode
	// --------------Responder [continue]
	// HASH(2) = prf(SKEYID_a, M-ID | SA)
	vblob *pHASH_2;
	static const char d_SAqm[] = {2,2,2,2};
	vblob *SAqm = vcreate(GetCPCConfig(), DT_SA, (char *)d_SAqm, sizeof(d_SAqm));

	CERR(r2->plg->p2_HashAFn(p2_r, 0, &pHASH_2, 1, SAqm));

	// Send HDR*<HASH(1'), SA>
	memset(buf, 0, sizeof(buf) );
	memcpy(ih->CKY_I, vref( (vblob *)i2->CKY ), sizeof(ih->CKY_I));
	memcpy(ih->CKY_R, vref( (vblob *)r2->CKY ), sizeof(ih->CKY_R));
	memcpy(ih->MessageID, vref( (vblob *)M_ID ), sizeof(ih->MessageID));
	enc_len=sizeof(ikeHDR);
	CERR(send2buf(pHASH_2, buf, &enc_len, sizeof(buf)));
	CERR(send2buf(SAqm, buf, &enc_len, sizeof(buf)));
	save_enc_len = enc_len;
	CERR(r2->plg->p2_EncapFn(p2_r, 0, NULL, &enc_len, sizeof(buf)));
	ih->Length = htonl(enc_len);
	ih->flags = 1;
	enc_len = save_enc_len;
	CERR(r2->plg->p2_EncapFn(p2_r, 0, buf, &enc_len, sizeof(buf)));

	// Receive HDR*<HASH(2), SA>
	CERR(i2->plg->p2_DecapFn(p2_i, 0, buf, &enc_len));
	dec_len=sizeof(ikeHDR);
	{
	    vblob *HASH_2_rcv;
	    vblob *SAqm_rcv;
	    CERR(recv4buf(&HASH_2_rcv, DT_HASH, buf, &dec_len, enc_len));
	    CERR(recv4buf(&SAqm_rcv, DT_SA, buf, &dec_len, enc_len));
	    //     
	    vdelete(&HASH_2_rcv);
	    vdelete(&SAqm_rcv);
	}

	// Verify HASH(2) = prf(SKEYID_a, M-ID | SA)
	CERR(i2->plg->p2_VerifyAFn(p2_i, 0, pHASH_2, 1, SAqm));
	vdelete(&pHASH_2);
	vdelete(&SAqm);
    }
    if( is_cfgmode )
    {
	CERR( i2->plg->p1_SetParamFn(i2->p1,CPIKE_AC_Peer_CFGMODE_Status, CPIKE_CFGMODE_OK,0,0) );
	CERR( r2->plg->p1_SetParamFn(r2->p1,CPIKE_AC_Own_CFGMODE_Status, CPIKE_CFGMODE_OK,0,0) );
    }
    // --------------Initiator
    i2->plg->p2_DestroyFn(p2_i, 0);

    // --------------Responder
    r2->plg->p2_DestroyFn(p2_r, 0);

    vdelete(&M_ID);

    return 0;

err:
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    return rc;
}
