/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2005-2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

/*!
 * \file $RCSfile: example_ike_esp.cpp,v $
 * \version $Revision: 206367 $
 * \date $Date:: 2020-02-09 15:28:05 +0300#$
 * \author $Author: dim $
 *
 * \brief   ESP  IKE  user mode
 *
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <cstring>
#ifdef HAVE_CPRO_CONFIG_H
#   include "myconfig.h"
#endif

#ifdef _WIN32
#   include <WinSock2.h>
#   include <Windows.h>
#   include <WinCrypt.h>
#   include <tchar.h>
#endif	/* _WIN32 */
#include "wincspc.h"
#include "sadb.h"
#include "ike_gost.h"
#include "esp_gost.h"
#include "example.h"

#ifdef UNIX
    #include <sys/uio.h>
#else
        #include <WinSock2.h>
#endif

#if defined TEST_CONFORMITY
#include "ConformityIPSEC.h"
#define DEVL
extern int iP;
extern capi_result CAPI_INTC
Conf_SetFlags(unsigned satype, unsigned encrypt, unsigned auth, 
	      FLGS* pFlgs, LPCONF_IPSEC* ppC);
#endif	// TEST_CONFORMITY

#if defined _WIN32
#   include "platformstream.h"
#else
#   include <netinet/in.h>
#endif	// _WIN32

#define StartPacket_2 1100
//   seq#l    2^31,      seq#h
#ifdef TEST_CONFORMITY
static unsigned S_N_[10] = {0x7d,0x0bf,0x0c0,0x000fffff,0x80000000,0xffffffff, 0x3,63,51,65,};
static unsigned S_N_n[10] = {0x7d,0x0bf,0x0c0,0x000fffff,0x80000000,0x80ffffff, 0x81ffff03,0x81ffff33,0x81ffff21,0x81ffff65,};
#    include "../../Conformity/ConformityIPSEC.h"
#    define StartPacket_1   61
#    define EndPacket_1	    (StartPacket_1+espNP)
#    define EndPacket_2	    (StartPacket_2+espNP)
#else
#    define StartPacket_1   61
#    define EndPacket_1	    (StartPacket_1+200)
#    define EndPacket_2	    (StartPacket_2+200)
#endif  /* TEST_CONFORMITY */

extern GlobalParams globalParamState;

static DWORD
BuftoIOVec(CSP_iovec * iov,DWORD iovs, BYTE* Buf, DWORD *pBuflen);

static DWORD
IOVectoBuf_D(DWORD enc, DWORD decap, BYTE* Buf, DWORD Buflen, 
	   CSP_iovec **piov, DWORD *piovlen, DWORD *piovs);

static void DestroyIOVec(CSP_iovec * iov, DWORD iovs);
// unused DWORD cpyIOVec( CSP_iovec * iov, DWORD iovs, CSP_iovec **piov);

/*
 *   IKE  ESP,  ESP/ESP  
 *  - user space ESP (Conformity)
 *  -  kernel space  ESP  user-space
 *  - kernel space  ESP (ESP_IO_KERNEL)
 *
 *  :
 *  !ESP_IO_KERNEL,     user space, 
 *      .
 *
 *  ESP_IO_KERNEL,      esp_gost.ko,
 *  testesp.ko  .      .
 *
 * ESP_IO_KERNEL   ike/test/example_ike_esp.cpp
 *
 *   :
 *       ESP_IO_KERNEL
 *
 *  1.   ESP: cpesp_init_gost(esp), shutdown(esp)
 *  2. esp_init(esp1, esp2)
 *  3. CreateEphem()  esp1  esp2
 *  4. CreatePSK/CreateProv  ik1/ike2
 *  5. ike::spiSerialize(spi1/spi2)  esp1/esp2
 *  6.     ESP-
 *    . spiCreate (esp1,spi1)
 *    . delete (esp1,spi1)
 *  7.     ESP-: spiCreate(esp2,spi1)
 *  8. ike::reSerialize(spi1 -> spi1f2)  esp2, spiCreate()/destroy
 *  9. spiCreate 4    
 *
 * 10.  
 *    .      
 *    .       -- 100--300 
 *    .       -- 10--30 
 *    .    
 *
 * 11.  
 *    . delete (esp1,spi1) (esp2,spi2)
 *    . shutdown esp1  esp2
 *
 * 12.    ESP_IO_KERNEL
*/

//  3      
static esp_gost_handle
init_esp_module(unsigned NumSessions);

static void
shutdown_esp_module(esp_gost_handle h, DWORD flags);

static HCRYPTMODULE CreateHCRYPTMODULE();
static DWORD DestroyHCRYPTMODULE(HCRYPTMODULE m);

typedef struct {
    DWORD spi;
    DWORD SeqNum;
} esp_buf;
typedef struct {
    DWORD prt;
    DWORD spi;
    DWORD SeqNum;
} ah_buf;

#ifndef TEST_CONFORMITY
#if !defined ESP_IO_KERNEL
/* 10.  
 * .    
 *   128
 *     SegNum=EndPacket_2 
 */
static void check_wnd_processing(esp_gost_handle esp1, esp_gost_handle esp2,
				 DWORD spi,
				 ESP_HANDLE spi_i_snd,
				 ESP_HANDLE spi_r_rcv)
{
    enum awaited {
	N_PASS,
	N_FAIL
    };
    struct test_pnum {
	enum awaited status;
	unsigned pnum;
    };
    //    `snd'       ,
    //      
    const struct test_pnum snd[] = {
	{ N_PASS,   1}, // [1..128]
	{ N_FAIL,   1}, //  
	{ N_PASS,   3},
	{ N_FAIL,   1}, //  
	{ N_PASS,   4},
	{ N_PASS,  32},
	{ N_PASS,  31},
	{ N_PASS,  33},
	{ N_FAIL,  32}, //  
	{ N_FAIL,  31}, //  
	{ N_PASS,  34}, //   ,    - 
	{ N_FAIL,  32}, //  
	{ N_FAIL,  31}, //  
	{ N_PASS, 128},
	{ N_PASS, 129}, // [2..129]  
	{ N_FAIL,   1}, //  
	{ N_FAIL,   3}, //  
	{ N_PASS, 131}, // [4..131]  
	{ N_FAIL,   3}, //  
	{ N_PASS,  62},
	{ N_PASS,  61},
	{ N_PASS, 127}
    };
    const unsigned snd_len = sizeof(snd)/sizeof(snd[0]);
    unsigned inlen = 42;
    capi_result rc;
    rc = esp1->espEncapFn(spi_i_snd, 0, 0, 0, &inlen, 0, 0);
    if(rc != CAPI_NOERROR) {
	printf("check_wnd_processing: unexpected err:%d %d\n", __LINE__, rc);
	exit(1);
    }
    const unsigned buflen = inlen;	//    
    inlen = 42;	//  
    printf("ilen = %u buflen=%u\n", inlen, buflen);

    char pkts[snd_len][100];
    memset(pkts, 0, snd_len*buflen);

    CPC_CONFIG * config;
    config = GetCPCConfig();

    for(unsigned indSeqNum=0; indSeqNum < snd_len; indSeqNum++) {
	char *ibuf = pkts[indSeqNum];
	esp_buf *esp_ibuf = reinterpret_cast<esp_buf*>(ibuf);
	unsigned ilen = inlen;
	int blen = buflen;

	esp_ibuf->spi = spi;
	esp_ibuf->SeqNum = htonl(snd[indSeqNum].pnum+EndPacket_2);

	char protocol_id = 4;

	rc = esp1->espEncapFn(spi_i_snd, 0, &protocol_id, ibuf, &ilen, blen, config);
	if(rc != CAPI_NOERROR && rc != CAPI_SN_ERROR) {
	    printf("check_wnd_processing: SND unexpected err:%d rc=%u indSeqNum=%u pnum=%u\n", __LINE__, rc, indSeqNum, snd[indSeqNum].pnum);
	    exit(1);
	}
	if(snd[indSeqNum].status == N_FAIL && rc == CAPI_NOERROR) {
	    printf("check_wnd_processing: SND unexpected PASS:%d indSeqNum=%u pnum=%u\n", __LINE__, indSeqNum, snd[indSeqNum].pnum);
	    continue;
	} else if(snd[indSeqNum].status == N_PASS && rc == CAPI_SN_ERROR) {
	    printf("check_wnd_processing: SND unexpected FAIL:%d indSeqNum=%u pnum=%u\n", __LINE__, indSeqNum, snd[indSeqNum].pnum);
	    continue;
	} else if(snd[indSeqNum].status == N_FAIL && rc == CAPI_SN_ERROR) {
	    printf("check_wnd_processing: SND FAIL pnum=%u\n", snd[indSeqNum].pnum);
	} else if(snd[indSeqNum].status == N_PASS && rc == CAPI_NOERROR) {
	    printf("check_wnd_processing: SND PASS pnum=%u\n", snd[indSeqNum].pnum);
	}
    }

/*
         N_PASS
 0 { N_PASS,   1}, // [1..128]
	{ N_FAIL,   1}, //  
 2 { N_PASS,   3},
	{ N_FAIL,   1}, //  
 4 { N_PASS,   4},
 5 { N_PASS,  32},
 6 { N_PASS,  31},
 7 { N_PASS,  33},
	{ N_FAIL,  32}, //  
	{ N_FAIL,  31}, //  
10  { N_PASS,  34}, //   ,    - 
	{ N_FAIL,  32}, //  
	{ N_FAIL,  31}, //  
13 { N_PASS, 128},
14 { N_PASS, 129}, // [2..129]  
	{ N_FAIL,   1}, //  
	{ N_FAIL,   3}, //  
17 { N_PASS, 131}, // [4..131]  
	{ N_FAIL,   3}, //  
19 { N_PASS,  62},
20 { N_PASS,  61},
21 { N_PASS, 127}
*/
    //   ,    `snd'
    //    `snd'    
    const struct test_pnum rcv [] = {
	{ N_PASS,  0}, //  1,  [1..128]
	{ N_FAIL,  0}, //  
	{ N_PASS,  2},
	{ N_PASS,  4},
	{ N_PASS,  5},
	{ N_PASS,  6},
	{ N_PASS,  7},
	{ N_FAIL,  5}, //  
	{ N_FAIL,  6}, //  
	{ N_PASS, 10},
	{ N_PASS, 13}, //   
	{ N_PASS, 14}, // [2..129]  
	{ N_FAIL,  0}, //  
	{ N_PASS, 17}, // [4..131]  
	{ N_PASS, 19},
	{ N_PASS, 20}
    };
    const unsigned rcv_len = sizeof(rcv) / sizeof(rcv[0]);
    for(unsigned indSeqNum=0; indSeqNum < rcv_len; indSeqNum++) {
	unsigned olen = buflen;
	char oNextProto;
	const unsigned ind_in_snd = rcv[indSeqNum].pnum;
	const unsigned pkt_num = snd[ind_in_snd].pnum;
	char *ibuf = pkts[ind_in_snd];

	rc = esp2->espDecapFn(spi_r_rcv, 0, &oNextProto, ibuf, &olen, config);

	if(rc != CAPI_NOERROR && rc != CAPI_SN_ERROR) {
	    printf("check_wnd_processing: RCV unexpected err:%d rc=%u indSeqNum=%u ind_in_snd=%u pnum=%u\n", __LINE__, rc, indSeqNum, ind_in_snd, pkt_num);
	    exit(1);
	}
	if(rcv[indSeqNum].status == N_FAIL && rc == CAPI_NOERROR) {
	    printf("check_wnd_processing: RCV unexpected PASS:%d indSeqNum=%u ind_in_snd=%u pnum=%u\n", __LINE__, indSeqNum, ind_in_snd, pkt_num);
	    continue;
	} else if(rcv[indSeqNum].status == N_PASS && rc == CAPI_SN_ERROR) {
	    printf("check_wnd_processing: RCV unexpected FAIL:%d indSeqNum=%u ind_in_snd=%u pnum=%u\n", __LINE__, indSeqNum, ind_in_snd, pkt_num);
	    continue;
	} else if(rcv[indSeqNum].status == N_FAIL && rc == CAPI_SN_ERROR) {
	    printf("check_wnd_processing: RCV FAIL pnum=%u\n", pkt_num);
	} else if(rcv[indSeqNum].status == N_PASS && rc == CAPI_NOERROR) {
	    printf("check_wnd_processing: RCV PASS pnum=%u\n", pkt_num);
	}
    }
}
#endif	// !ESP_IO_KERNEL
#endif // TEST_CONFORMITY

#if defined TEST_CONFORMITY
//   Conformity
kernel_space::kernel_space(unsigned n)
{
    hPrivKERNEL.hKey = 0;
    hProvKERNEL = 0;
    for(unsigned i=0; i<(sizeof(spi)/sizeof(spi[0])); i++ )
	spi[i] = 0;
    esp_plg = 0;
    esp_plg = init_esp_module(n);
    if(!esp_plg)
    	return;
    if(CapiAcquireContext( hModuleIke, &hProvKERNEL, 0, 0/*DEBUG_PROVIDER_W*/, PROV_GOST_2001_DH, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001))
	return;
    if( !hProvKERNEL )
	return;
    PublicData.pbData = &buf[0];
    PublicData.cbData = sizeof(buf);
}

kernel_space::~kernel_space()
{
    for(unsigned i=0; i<(sizeof(spi)/sizeof(spi[0])); i++ ){
	if(spi[i])
	    esp_plg->destroyFn(0, spi[i]);}
    if( hProvKERNEL )
	CapiReleaseContext( hModuleIke, hProvKERNEL, 0 );
    if( esp_plg )
	shutdown_esp_module( esp_plg, 0 );
}
#endif	// TEST_CONFORMITY

/*
 *  
 */
unsigned
ike_esp(p2_ir_state* i2, p2_ir_state* r2,
#ifdef TEST_CONFORMITY
	user_space* sadb_s,
	DWORD is_iov,
#endif
	CPIPSEC_PROTOCOL_ID_T satype, CPESP_TRANSFORM_ID_T encrypt, CPAH_TRANSFORM_ID_T auth)
{
    unsigned rc = 0;
    int line = 0;
#if !defined TEST_CONFORMITY
    const DWORD is_iov = 0;
#endif /* !defined TEST_CONFORMITY */

    esp_gost_handle esp1 = 0, esp2 = 0;

    ESP_HANDLE spi_i_snd = 0, spi_i_rcv = 0;
    ESP_HANDLE spi_r_snd = 0, spi_r_rcv = 0;

    vblob *pspi_data_i_rcv; //   spi
    vblob *pspi_data_i_snd;
    vblob *pspi_data_r_rcv;
    vblob *pspi_data_r_snd;

    vblob *pspi_data_i_rcv_f2; //   spi   esp2

#if !defined TEST_CONFORMITY
    DWORD SPI1 = rand();
    DWORD SPI2 = rand();
    vblob * vspir = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)&SPI1, 4); // Initiator => Responder
    vblob * vspri = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)&SPI2, 4); // Responder => Initiator
#else
    vblob * vspir = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)"1234", 4); // Initiator => Responder
    vblob * vspri = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)"4321", 4); // Responder => Initiator
#endif
    HCRYPTMODULE m1, m2;
    m1 = m2 = 0;

    /*  1.   ESP: : cpesp_init_gost(esp), shutdown(esp) */
    {
	esp_gost_handle esp;
	printf("Test create/destroy esp...");
	CERRASSERT(NULL != (esp = init_esp_module(32)), CAPI_INTERNAL_ERROR);
	esp->SetLogLvlUfn(esp->pUfnArg, EXAMPLE_LOG_LEVEL, 0);
	shutdown_esp_module(esp, 0);
	printf("...done\n");
    }

    /*  2. esp_init(esp1, esp2) */
    printf("init esp modules...");
    CERRASSERT(NULL != (esp1 = init_esp_module(17)), CAPI_INTERNAL_ERROR);
    esp1->SetLogLvlUfn(esp1->pUfnArg, EXAMPLE_LOG_LEVEL, 0);
    CERRASSERT(NULL != (esp2 = init_esp_module(64)), CAPI_INTERNAL_ERROR);
    esp2->SetLogLvlUfn(esp2->pUfnArg, EXAMPLE_LOG_LEVEL, 0);
    printf("...done\n");

    CPC_CONFIG * config;
    config = GetCPCConfig();

    /*  2- HCRYPTMODULE */
    printf("Test create/destroy HCRYPTMODULEs\n");
    printf("Create HCRYPTMODULEs...");
    m1 = CreateHCRYPTMODULE();
    m2 = CreateHCRYPTMODULE();
    if(!m1 || !m2) {
	printf("error create HCRYPTMODULEs %lu %lu", (unsigned long)(ULONG_PTR)m1, (unsigned long)(ULONG_PTR)m2);
	goto err;
    }
    printf("...done\n");
    printf("Destroy HCRYPTMODULEs...");
    CERR(DestroyHCRYPTMODULE(m1));
    m1 = 0;
    CERR(DestroyHCRYPTMODULE(m2));
    m2 = 0;
    printf("...done\n");

    printf("Again create HCRYPTMODULEs...");
    m1 = CreateHCRYPTMODULE();
    m2 = CreateHCRYPTMODULE();
    if(!m1 || !m2) {
	printf("error create HCRYPTMODULEs %lu %lu", (unsigned long)(ULONG_PTR)m1, (unsigned long)(ULONG_PTR)m2);
	goto err;
    }
    printf("...done\n");

    /*  3. CreateEphem()  esp1  esp2 */
    PRIVKEY espPriv1, espPriv2;

    BYTE *espPub1t, *espPub2t;
    uint32_t espPub1tLen, espPub2tLen;
    HCRYPTPROV hProv1, hProv2;
    hProv1 = hProv2 = 0;

#ifndef ESP_IO_KERNEL
    CERR( CapiAcquireContext( m1, &hProv1, 0, 0/*DEBUG_PROVIDER_W*/, PROV_GOST_2001_DH, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001));
    CERR( CapiAcquireContext( m2, &hProv2, 0, 0/*DEBUG_PROVIDER_W*/, PROV_GOST_2001_DH, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001));
#endif

    CERRSTACK(esp1->sadb.CreateEphemFn(0, 0, 0, 0, 0, &espPub1tLen), 1);
    CERR(esp2->sadb.CreateEphemFn(0, 0, 0, 0, 0, &espPub2tLen));
    espPub1t = (BYTE*) malloc(espPub1tLen);
    espPub2t = (BYTE*) malloc(espPub2tLen);
    CERRSTACK(esp1->sadb.CreateEphemFn(m1, hProv1, 0, &espPriv1, espPub1t, &espPub1tLen), 1);
    CERR(esp2->sadb.CreateEphemFn(m2, hProv2, 0, &espPriv2, espPub2t, &espPub2tLen));

    /*  4. CreatePSK/CreateProv  ike1/ike2 */
    HCRYPTPROV hProvI;
    PRIVKEY hPrivI;
    PUBKEY_2012 hPubI;
    BYTE pcsadbSA_i[512];
    unsigned usadbSALen_i;
    usadbSALen_i = sizeof(pcsadbSA_i);

    //   PSK
    CERR( CapiAcquireContext( hModuleIke, &hProvI, 0, 0/*DEBUG_PROVIDER_W*/, PROV_GOST_2001_DH, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001));
    CERR(i2->plg->sadb.CreatePSKFn(hModuleIke, hProvI, i2->parent->Site_PSK, i2->parent->NetID, i2->parent->Site_ID,
				   0, &hPrivI, pcsadbSA_i, &usadbSALen_i, GetCPCConfig() ));

    //   
    HCRYPTPROV hProvR;
    PRIVKEY hPrivR;
    PUBKEY_2012 hPubR;
    BYTE pcsadbSA_r[512];
    unsigned usadbSALen_r;
    usadbSALen_r = sizeof(pcsadbSA_r);

    HCRYPTMODULE hModuleTemp;
    hModuleTemp = GetNewModule_Crypt();

    // dim:     (  IKE)
#ifndef TEST_CONFORMITY
    CERR( CapiAcquireContext( hModuleTemp, &hProvR, (CHAR *)r2->parent->pszCont, r2->parent->pszProv, r2->parent->dwPT, r2->parent->dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001 ));
    CERR( CapiSetProvParam( hModuleTemp, hProvR, PP_KEYEXCHANGE_PIN, (BYTE *)r2->parent->pbPIN, 0));
    CERR( r2->plg->sadb.CreateEphemFn( hModuleTemp, hProvR, 0, &hPrivR, pcsadbSA_r, &usadbSALen_r ) );
#else
    CERR( CapiAcquireContext( hModuleTemp, &hProvR, (*sadb_s).cert_data[0].pszCont, 
	(*sadb_s).cert_data[0].pszProv, (*sadb_s).cert_data[0].dwPT, (*sadb_s).cert_data[0].dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001));
    CERR( CapiSetProvParam(hModuleTemp, hProvR, PP_KEYEXCHANGE_PIN, (*sadb_s).cert_data[0].pbPIN, 0));
    CERR(r2->plg->sadb.CreateProvFn(hModuleTemp, hProvR, 0, &hPrivR, pcsadbSA_r, &usadbSALen_r));
#endif

    printf("...done\n");

    /*    */
    printf("Test p2_SetParam()...");
    if(encrypt == CPESP_GOST_4M_IMIT || auth == CPAH_GOST_HMAC_4M) {
	//     ESP_GOST-4M
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Life_Duration, (uintptr_t)-1, CPIPSEC_LIFET_KILOBYTES, 0)); // 2^80 
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Max_Packet_Len, 64, 0, 0));	// 64 
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Max_Auth_Error, 100*1000, 0, 0));	// 10^5

	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Life_Duration, (uintptr_t)-1, CPIPSEC_LIFET_KILOBYTES, 0)); // 2^80 
	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Max_Packet_Len, 64, 0, 0));	// 64 
	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Max_Auth_Error, 100*1000, 0, 0));	// 10^5
    } else if(encrypt == CPESP_GOST_1K_IMIT || auth == CPAH_GOST_HMAC_1K) {
	//     ESP_GOST-1K
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Life_Duration, (uintptr_t)-1, CPIPSEC_LIFET_KILOBYTES, 0)); // 2^80 
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Max_Packet_Len, 4*1024*1024, 0, 0)); // 4 
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Max_Auth_Error, 100*1000, 0, 0));	// 10^5

	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Life_Duration, (uintptr_t)-1, CPIPSEC_LIFET_KILOBYTES, 0)); // 2^80 
	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Max_Packet_Len, 4*1024*1024, 0, 0)); // 4 
	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Max_Auth_Error, 100*1000, 0, 0));	// 10^5
    } else {
	rc = CAPI_INTERNAL_ERROR;
	line = __LINE__;
	goto err;
    }

    CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Life_Duration, 24*3600, CPIPSEC_LIFET_SECONDS, 0)); // 24 
#ifdef TEST_CONFORMITY
    bool is_ESN;
    is_ESN = false;
    if(satype==CPIPSEC_PROTO_IPSEC_ESP && encrypt==CPESP_GOST_1K_IMIT && auth==CPESP_MAC_NULL) {
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Ext_Serial_Number, CPESP_ESN_Enable, 0, 0));
	is_ESN = true;
    } else {
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Ext_Serial_Number, CPESP_ESNP_Disable, 0, 0));
    }
#else
    CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Ext_Serial_Number, CPESP_ESNP_Disable, 0, 0));
#endif  /* TEST_CONFORMITY */
    CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_ATP_Check_SN, CPESP_CHKSN_Enable, 0, 0));
//    CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_GOST_28147_SBOX, CPESP_SBOX_B, 0, 0));
 
    if( !strcmp( globalParamState.g28147oid, szOID_Gost28147_89_CryptoPro_B_ParamSet ) )
    {
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_GOST_28147_SBOX, CPESP_SBOX_B, 0, 0));
    }
    else if( !strcmp( globalParamState.g28147oid, szOID_Gost28147_89_TC26_A_ParamSet ) )
    {
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_GOST_28147_SBOX, CPESP_SBOX_TC26Z, 0, 0));
    }
    else
    {
	CERR( FALSE );
    }
    CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Life_Duration, 24*3600, CPIPSEC_LIFET_SECONDS, 0)); // 24 
#ifdef TEST_CONFORMITY
    if(satype==CPIPSEC_PROTO_IPSEC_ESP && encrypt==CPESP_GOST_1K_IMIT && auth==CPESP_MAC_NULL) {
	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Ext_Serial_Number, CPESP_ESN_Enable, 0, 0));
	is_ESN = true;
    } else {
	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Ext_Serial_Number, CPESP_ESNP_Disable, 0, 0));
    }
#else
    CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Ext_Serial_Number, CPESP_ESNP_Disable, 0, 0));
#endif  /* TEST_CONFORMITY */
    CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_ATP_Check_SN, CPESP_CHKSN_Enable, 0, 0));
//    CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_GOST_28147_SBOX, CPESP_SBOX_B, 0, 0));
 
    if( !strcmp( globalParamState.g28147oid, szOID_Gost28147_89_CryptoPro_B_ParamSet ) )
    {
	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_GOST_28147_SBOX, CPESP_SBOX_B, 0, 0));
    }
    else if( !strcmp( globalParamState.g28147oid, szOID_Gost28147_89_TC26_A_ParamSet ) )
    {
	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_GOST_28147_SBOX, CPESP_SBOX_TC26Z, 0, 0));
    }
    else
    {
	CERR( FALSE );
    }


    printf("...done\n");

    /*  5. ike::spiSerialize(spi1/spi2)  esp1/esp2 */
    /* ike(Initiator) esp1 */
    printf("Test spiSerialize...");

    PUBKEY_2012 espPub1;
    //    esp1   
    // '0'  , ..  user-space   (HCRYPTMODULE) 
    CERR(i2->plg->sadb.deSerializePubKeyFn(hModuleIke, hProvI, espPub1t, espPub1tLen, 0, &espPub1, config) != CAPI_NOERROR);
    free(espPub1t);
    espPub1t = 0;

    //  SPI  esp1       
    CERR(i2->plg->spiSerializeFn(i2->p2,
				 &hPrivI, &espPub1,
				 vspri, CPESP_INBOUND, satype,
				 encrypt, auth,
				 0,
				 &pspi_data_i_rcv));
    CERR(i2->plg->spiSerializeFn(i2->p2,
				 &hPrivI, &espPub1,
				 vspir, CPESP_OUTBOUND, satype,
				 encrypt, auth,
				 0,
				 &pspi_data_i_snd));

    /* ike(Responder) esp2 */
    PUBKEY_2012 espPub2;
    //    esp2   
    // '0'  , ..  user-space   (HCRYPTMODULE)  
    CERR(i2->plg->sadb.deSerializePubKeyFn(hModuleTemp, hProvR, espPub2t, espPub2tLen, 0, &espPub2, config) != CAPI_NOERROR);
    free(espPub2t);
    espPub2t = 0;

    //  SPI  esp2       
    CERR(r2->plg->spiSerializeFn(r2->p2,
				 &hPrivR, &espPub2,
				 vspir, CPESP_INBOUND, satype,
				 encrypt, auth,
				 0,
				 &pspi_data_r_rcv));
    CERR(r2->plg->spiSerializeFn(r2->p2,
				 &hPrivR, &espPub2,
				 vspri, CPESP_OUTBOUND, satype,
				 encrypt, auth,
				 0,
				 &pspi_data_r_snd));
    vdelete( &vspri );
    printf("...done\n");

    /*  6.     ESP-
     *     spiCreate(esp1,spi_i_snd)
     *     delete(spi_i_snd)
     */
    printf("Test spi Create/destroy...");
    //       esp1
    CERRSTACK(esp1->sadb.deSerializePubKeyFn(m1, hProv1, (LPCBYTE)pcsadbSA_i, usadbSALen_i, 0, &hPubI, config), 1);
   
    //  ESP-   esp1  ,  
    CERR(esp1->spiCreateFn(esp1,
			   &espPriv1, &hPubI,
			   (const unsigned char*)vref( pspi_data_i_snd ), (uint32_t)vsize( pspi_data_i_snd ),
			   0, &spi_i_snd, config));
    esp1->destroyFn(0, spi_i_snd);
    printf("...done\n");

    /*  7.     ESP-: spiCreate(esp2,spi1)
     *    .  (esp2,spi1)
     *    .     (esp2,spi1) (    )
     */
    printf("Test incorrect spiCreate()...\n");
    printf("Errors ignoring ON\n");
    printf("Expected error message\n\tspiCreateFn:....  abort rc=0x80090005\n");
    

    //   esp2       ,    esp2
    rc = esp2->spiCreateFn(esp2,
			   &espPriv2, &hPubI, /*     */
			   (const unsigned char*)vref( pspi_data_r_snd ), (uint32_t)vsize( pspi_data_r_snd ),
			   0, &spi_r_rcv, config);
    if(rc==CAPI_NOERROR) {
	printf("Error: create uncreatable session\n");
	rc = CAPI_INTERNAL_ERROR;
	line = __LINE__ - 4;
	goto err;
    }
    esp2->destroyFn(0, spi_r_rcv);
    printf("check incorrect PublicKey OK.\n");

    printf("Expected error message\n\tspiCreateFn:....  abort rc=0x80090005\n");
     //       esp2
    CERR(esp2->sadb.deSerializePubKeyFn(m2, hProv2, (LPCBYTE)pcsadbSA_r, usadbSALen_r, 0, &hPubR, config));

    //   esp2    esp1  ,    esp2
    rc = esp2->spiCreateFn(esp2,
			   &espPriv1, &hPubR, /*     */
			   (const unsigned char*)vref( pspi_data_r_snd ), (uint32_t)vsize( pspi_data_r_snd ),
			   0, &spi_r_rcv, config);
    if(rc==CAPI_NOERROR) {
	printf("Error: create uncreatable session\n");
	rc = CAPI_INTERNAL_ERROR;
	line = __LINE__ - 4;
	goto err;
    }
    esp2->destroyFn(0, spi_r_rcv);
    printf("check incorrect PrivateKey OK.\n");
    printf("...done\n");

    /*  8. ike::reSerialize(spi1 -> spi1f2)  esp2 */
    printf("Test reSerialize()...\n");

    printf("Expected error message\n\tspireSerializeFn:....  abort rc=0x80090005\n");
    //  ,    esp1   esp2
    //    
    rc = i2->plg->spireSerializeFn(i2->plg,
				   &hPrivR, &hPrivR, &espPub1, &espPub2, //    
				   pspi_data_i_rcv,
				   0,
				   &pspi_data_i_rcv_f2);
    if(rc==CAPI_NOERROR) {
	printf("Error: create uncreatable session\n");
	rc = CAPI_INTERNAL_ERROR;
	line = __LINE__ - 4;
	goto err;
    }
    printf("Errors ignoring OFF\n");
    printf("...done\n");
    CERR(r2->plg->sadb.DestroyPrivKeyFn(0, &hPrivR)); //   
    CERR(CapiReleaseContext(hModuleTemp, hProvR, 0 ) );

    //  ,    esp1   esp2
    CERR(i2->plg->spireSerializeFn(i2->plg,
				   &hPrivI, &hPrivI, &espPub1, &espPub2,
				   pspi_data_i_rcv,
				   0,
				   &pspi_data_i_rcv_f2));
    printf("...done\n");
    CERR(i2->plg->sadb.DestroyPrivKeyFn(0, &hPrivI)); //   
    CERR(CapiReleaseContext(hModuleIke, hProvI, 0 ) );
    CERR(i2->plg->sadb.DestroyPubKeyFn(0, &espPub1));
    CERR(i2->plg->sadb.DestroyPubKeyFn(0, &espPub2));

    //   ESP-    
    printf("Test reserialized data: spiCreate/destroy...");
    CERR(esp1->spiCreateFn(esp2,
			   &espPriv2, &hPubI,
			   (const unsigned char*)vref( pspi_data_i_rcv_f2 ), (uint32_t)vsize( pspi_data_i_rcv_f2 ),
			   0, &spi_i_snd, config));
    esp1->destroyFn(0, spi_i_snd);
    vdelete(&pspi_data_i_rcv_f2);
    pspi_data_i_rcv_f2 = 0;
    printf("...done\n");

/*  9. spiCreate 4     */
    printf("Xchg test: create spiCreate...");
    CERRSTACK(esp1->spiCreateFn(esp1,
			   &espPriv1, &hPubI,
			   (const unsigned char*)vref( pspi_data_i_snd ), (uint32_t)vsize( pspi_data_i_snd ),
			   0, &spi_i_snd, config), 1);
    CERRSTACK(esp1->spiCreateFn(esp1,
			   &espPriv1, &hPubI,
			   (const unsigned char*)vref( pspi_data_i_rcv ), (uint32_t)vsize( pspi_data_i_rcv ),
			   0, &spi_i_rcv, config), 1);

    vdelete(&pspi_data_i_snd);
    vdelete(&pspi_data_i_rcv);
    pspi_data_i_snd = 0;
    pspi_data_i_rcv = 0;
    CERR(i2->plg->sadb.DestroyPubKeyFn(0, &hPubI)); //   

    CERR(esp2->spiCreateFn(esp2,
			   &espPriv2, &hPubR,
			   (const unsigned char*)vref( pspi_data_r_snd ), (uint32_t)vsize( pspi_data_r_snd ),
			   0, &spi_r_snd, config));
    CERR(esp2->spiCreateFn(esp2,
			   &espPriv2, &hPubR,
			   (const unsigned char*)vref( pspi_data_r_rcv ), (uint32_t)vsize( pspi_data_r_rcv ),
			   0, &spi_r_rcv, config));
    printf("...done\n");

    vdelete(&pspi_data_r_snd);
    vdelete(&pspi_data_r_rcv);
    pspi_data_r_snd = 0;
    pspi_data_r_rcv = 0;
    CERR(i2->plg->sadb.DestroyPubKeyFn(0, &hPubR)); //   

/*  10.   */
    char iNextProto, oNextProto;// NextProto    
    unsigned ilen, ilen_, olen;	//      
    unsigned buflen;		//  
    esp_buf *esp_ibuf, *esp_obuf; //  x86     ,   
    ah_buf *ah_ibuf;
    DWORD espFlafs; // len of ip header for AH
    DWORD ahbgn;
    char *ibuf, *obuf, *ibuf_e;	//   esp-

#ifndef TEST_CONFORMITY
    espFlafs=((satype==CPIPSEC_PROTO_IPSEC_AH)?IPhdrlen:ESP_PADDING_SEQ|ESP_PADDING_SIZE|231);
#else
    espFlafs=((satype==CPIPSEC_PROTO_IPSEC_AH)?IPhdrlen:ESP_PADDING_ZERO);
#endif

    ilen = sizeof(esp_buf);
    buflen = 0; //  
#ifndef TEST_CONFORMITY
    CERRSTACK(esp1->espEncapFn(spi_i_snd, 0, 0, 0, &ilen, buflen, config), 1);
#endif  /* TEST_CONFORMITY */
    buflen = ilen;
    ilen = sizeof(esp_buf);	//   
    ibuf = (char*) malloc(buflen);
    esp_ibuf = (esp_buf*) ibuf;
    obuf = 0;
    esp_obuf = 0;
    iNextProto = (satype==CPIPSEC_PROTO_IPSEC_AH)?1:4;	//  0   

/*    .       */
    memset(ibuf+sizeof(esp_buf), 0, buflen-sizeof(esp_buf));
    DWORD spi;
    memcpy(&spi, vref( vspir ), 4);
    esp_ibuf->spi = spi + 7; 	// incorrect value
    esp_ibuf->SeqNum = 4;	// any value
    vdelete( &vspir );

#ifndef TEST_CONFORMITY
    
    if( satype == CPIPSEC_PROTO_IPSEC_ESP )
    {
	printf("\nExpected error message\n\tespEncapFn:... sid=... incorrect SPI: req. ..., rcv ...\n");
	CERRSTACK( esp1->espEncapFn(spi_i_snd, 0, &iNextProto, ibuf, &ilen, buflen, config), 0 );
	if(rc==CAPI_NOERROR) {
	    printf("Error: incorrect SPI in espEncapFn() not detected\n");
	    rc = CAPI_INTERNAL_ERROR;
	    line = __LINE__;
	    goto err;
	}
    }// TODO: AH   
#endif  /* TEST_CONFORMITY */
    free(ibuf);
    ibuf = 0;
    esp_ibuf = 0;
    printf("check OK.\n");

    unsigned SeqNum_;

#ifndef TEST_CONFORMITY
/*    .       -- 100--300  */
    for(unsigned SeqNum=StartPacket_1; SeqNum<EndPacket_1; SeqNum++) {
	ilen = SeqNum;
	SeqNum_ = SeqNum;
#else
    LPCONF_IPSEC pC;
    FLGS Flgs;
    unsigned isn;
    isn = 0;
    pC=NULL;
    Flgs.d=0;
    CERR(Conf_SetFlags( satype,  encrypt,  auth, &Flgs,&pC));

    iP=0;
    for(unsigned SeqNum=StartPacket_1; SeqNum < EndPacket_1; SeqNum++) {
	isn++;
	if(is_ESN) SeqNum_ = S_N_[(isn-1)%10];
	else SeqNum_ = S_N_n[(isn-1)%10];
	if(satype==CPIPSEC_PROTO_IPSEC_AH) {
	    ilen = 84 + isn-1;
	} else {
	    ilen = SeqNum;
	    if(encrypt==CPESP_GOST_1K_IMIT /*&& isn==1*/) {
		 ilen = 1057 + isn-1;
	    }
	}
	Flgs.f.ilen=ilen;
	if(pC && (isn==1))
	    CERR(reinitvblob(DT_DWORD, (LPBYTE)&Flgs,  sizeof(DWORD), &pC->FlgsESP, pC, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
	ilen_ = ilen;
	if(espFlafs & ESP_DATA_IOVEC) espFlafs ^= ESP_DATA_IOVEC;
	CERRSTACK(esp1->espEncapFn(spi_i_snd, espFlafs, 0, 0, &ilen, buflen, config), 1);
	buflen = ilen;
	ilen = ilen_;		     //   

	obuf = (char*) malloc(buflen); //     
	ibuf = (char*) malloc(buflen);
	ibuf_e = (char*) malloc(buflen);
#if defined TEST_CONFORMITY
	memset(ibuf, 0, buflen);
#endif	// TEST_CONFORMITY
	if(satype==CPIPSEC_PROTO_IPSEC_ESP) {
	    esp_obuf = (esp_buf*) obuf;
	    esp_ibuf = (esp_buf*) ibuf;
	    esp_ibuf->spi = spi;	   // correct value
	    esp_ibuf->SeqNum = htonl(SeqNum_); // variable value

	    for(unsigned j=0; j<ilen-sizeof(esp_buf); j++)
		ibuf[sizeof(esp_buf)+j] = (char)j;
	    ibuf[sizeof(esp_buf)] = 0x45;
	    ibuf[sizeof(esp_buf)+1] = 0;
	    ibuf[sizeof(esp_buf)+2] = 0;
	    ibuf[sizeof(esp_buf)+3] = 0x1d;
	    memcpy(obuf, ibuf, ilen);
	    memcpy(ibuf_e, ibuf, ilen);
	} else { //satype==CPIPSEC_PROTO_IPSEC_AH
	    ahbgn=(espFlafs&0x000000ff)+sizeof(ah_buf)+12;
	    for(unsigned j=0; j<ilen-ahbgn; j++)
		ibuf[ahbgn+j] = (char)j;
	    ah_ibuf = (ah_buf*) (ibuf+(espFlafs&0x000000ff));
	    ah_ibuf->prt = iNextProto + 0x00000400;	   // correct value
	    ah_ibuf->spi = spi;	   // correct value
	    ah_ibuf->SeqNum = htonl(SeqNum_); // variable value
	    memset(((BYTE*)ah_ibuf)+sizeof(ah_buf),0,12);
	    for(unsigned j=0; j<(espFlafs&0x000000ff); j++)
		ibuf[j] = (char)j+0x20;
	    DWORD* dibuf = (DWORD*)ibuf;
	    dibuf[0]=0x54000045; dibuf[1]=0x00002C0A; 
	    dibuf[2]=0x00003300; dibuf[3]=0xA855A8C0;  dibuf[4]=0x7055A8C0; 
	    dibuf[11]=0x47550000; dibuf[12]=0x14000100; 
	    memcpy(obuf, ibuf, ilen);
	    memcpy(ibuf_e, ibuf, ilen);
	}

	unsigned store_ilen = ilen;
	unsigned ilen_ein = ilen;
	//if(encrypt == CPESP_GOST_1K_IMIT) {
	//    ESP_HANDLE esp = spi_i_snd;
	//    esp->sn.prevh=0x0000000b;
	//}
	bool ysl = !is_iov;
	if(ysl) {
	    CERRSTACK( esp1->espEncapFn(spi_i_snd, espFlafs, &iNextProto, ibuf, &ilen, buflen, config), 0);
	    if(rc == CAPI_TTL_BYTES_EXPIRED_ERROR) {
		printf("espEncap ttlkb reached. line %d\n", __LINE__);
		free(obuf);
		free(ibuf);
		free(ibuf_e);
		break;
	    }
	    if(rc == CAPI_CSP_ERROR) {
		printf("espEncap return CAPI_CSP_ERROR. SeqNum=%d. line %d\n", SeqNum, __LINE__);
		line = __LINE__;
		goto err;
	    }
	    if(rc != CAPI_NOERROR) {
		printf("espEncap return %u. line %d\n", rc, __LINE__);
		line = __LINE__;
		goto err;
	    }
	} else {
	    CSP_iovec *iov;
	    DWORD iovs = 7;
	    DWORD iovlen = ilen;
	    rc = IOVectoBuf_D(encrypt,false,(BYTE*)ibuf,buflen,&iov,&iovlen,&iovs);
	    if(rc) {
		free(obuf);
		free(ibuf);
		free(ibuf_e);
		DestroyIOVec(iov,7);
		break;
	    }
	    rc = BuftoIOVec(iov,iovs,(BYTE*)ibuf_e,(DWORD *)&buflen);
	    if(rc) {
		free(obuf);
		free(ibuf);
		free(ibuf_e);
		DestroyIOVec(iov,7);
		break;
	    }
	    espFlafs |= ESP_DATA_IOVEC;
	    CERRSTACK( esp1->espEncapFn(spi_i_snd, espFlafs, 
				  &iNextProto, (BYTE*)iov, (unsigned int *)&ilen_ein, iovs, config), 0);
	    espFlafs &= 0xFFFF;
	    if(rc == CAPI_TTL_BYTES_EXPIRED_ERROR) {
		printf("espEncap ttlkb reached. line %d\n", __LINE__);
		free(obuf);
		free(ibuf);
		free(ibuf_e);
		break;
	    }
	    if(rc == CAPI_CSP_ERROR) {
		printf("espEncap return CAPI_CSP_ERROR. line %d\n", __LINE__);
		line = __LINE__;
		goto err;
	    }
	    if(rc != CAPI_NOERROR) {
		printf("espEncap return %u. line %d\n", rc, __LINE__);
		line = __LINE__;
		goto err;
	    }

	    rc = BuftoIOVec(iov,iovs,(BYTE*)ibuf,(DWORD *)&buflen);
	    if(rc) {
		free(obuf);
		free(ibuf);
		free(ibuf_e);
		DestroyIOVec(iov,7);
		break;
	    }
	    DestroyIOVec(iov,iovs);
	}
	olen = ilen;
	//   esp-   
	if(satype==CPIPSEC_PROTO_IPSEC_ESP) {
	    if(memcmp(ibuf,obuf,sizeof(esp_buf))) {
		printf("esp_hdr corrupted after Encap:SeqNum=%u\n", SeqNum);
		rc = CAPI_INTERNAL_ERROR;
		line = __LINE__;
		goto err;
	    }
	    if(encrypt == CPESP_NULL) {
		// CPAH_GOST_HMAC_4M | CPAH_GOST_HMAC_1K
		//  /HMAC    
		if(memcmp(ibuf+sizeof(esp_buf), obuf+sizeof(esp_buf), ilen_-sizeof(esp_buf))) { // '8' -- SEANCE_VECTOR_LEN
		    printf("data changed after Encap(HMAC):SeqNum=%u\n", SeqNum);
		    rc = CAPI_INTERNAL_ERROR;
		    line = __LINE__;
		    goto err;
		}
	    } else {
		//  /CRYPTO   
		if(!memcmp(ibuf+sizeof(esp_buf)+8, obuf+sizeof(esp_buf), ilen_-sizeof(esp_buf))) { // '8' -- SEANCE_VECTOR_LEN
		    printf("data not changed after Encap(CRYPT)):SeqNum=%u\n", SeqNum);
		    rc = CAPI_INTERNAL_ERROR;
		    line = __LINE__;
		    goto err;
		}
	    }
	} else { //satype==CPIPSEC_PROTO_IPSEC_AH
	}

	if(ysl) {

	    CERRSTACK(
		esp2->espDecapFn(spi_r_rcv,
				 espFlafs & (satype==CPIPSEC_PROTO_IPSEC_ESP ? 0xFFFFFF00 : 0xFFFFFFFF),
				 &oNextProto, ibuf, &olen, config), 0);
	    if(rc == CAPI_TTL_BYTES_EXPIRED_ERROR) {
		printf("espEncap ttlkb reached. line %d\n", __LINE__);
		free(obuf);
		free(ibuf);
		free(ibuf_e);
		break;
	    }
	    if(rc == CAPI_CSP_ERROR) {
		printf("espEncapFn return CAPI_CSP_ERROR. line %d\n", __LINE__);
		line = __LINE__;
		goto err;
	    }
	    if(rc != CAPI_NOERROR) {
		printf("espEncap return %u. line %d\n", rc, __LINE__);
		line = __LINE__;
		goto err;
	    }
	} else {

	    CSP_iovec *iov;
	    DWORD iovs;
	    DWORD iovlen;
	    rc = IOVectoBuf_D(encrypt,true,(BYTE*)ibuf,buflen,&iov,&iovlen,&iovs);
	    if(rc) {
		free(obuf);
		free(ibuf);
		free(ibuf_e);
		DestroyIOVec(iov,7);
		break;
	    }
	    rc = BuftoIOVec(iov,iovs,(BYTE*)ibuf_e,(DWORD *)&buflen);
	    if(rc) {
		free(obuf);
		free(ibuf);
		free(ibuf_e);
		DestroyIOVec(iov,7);
		break;
	    }
	    espFlafs |= ESP_DATA_IOVEC;
	    unsigned int iovs_ = iovs;
	    CERRSTACK(
		esp2->espDecapFn(spi_r_rcv,
				 espFlafs & (satype==CPIPSEC_PROTO_IPSEC_ESP ? 0xFFFFFF00 : 0xFFFFFFFF),
				 &oNextProto, (BYTE*)iov, &iovs_, config), 0);
	    espFlafs &= 0xFFFF;
	    if(rc == CAPI_TTL_BYTES_EXPIRED_ERROR) {
		printf("espDecap ttlkb reached. line %d\n", __LINE__);
		free(obuf);
		free(ibuf);
		free(ibuf_e);
		break;
	    }
	    if(rc == CAPI_CSP_ERROR) {
		printf("espDecap return CAPI_CSP_ERROR. line %d\n", __LINE__);
		line = __LINE__;
		goto err;
	    }
	    if(rc != CAPI_NOERROR) {
		printf("espDecap return %u. line %d\n", rc, __LINE__);
		line = __LINE__;
		goto err;
	    }

	    rc = BuftoIOVec(iov,iovs,(BYTE*)ibuf_e,(DWORD*)&buflen);
	    if(rc) {
		free(obuf);
		free(ibuf);
		free(ibuf_e);
		DestroyIOVec(iov,7);
		break;
	    }
	    if(encrypt!=CPESP_NULL) {
		memcpy(ibuf,ibuf_e,8);
		memcpy(ibuf+8,ibuf_e+16,buflen-16);
	    } else {
		memcpy(ibuf,ibuf_e,buflen);
	    }
	    DestroyIOVec(iov,iovs);

	}

	if(satype==CPIPSEC_PROTO_IPSEC_ESP) {

	    if(store_ilen != olen) {
		printf("SeqNum=%u datalen corrupted: %u != %u\n", SeqNum, store_ilen, olen);
		rc = CAPI_INTERNAL_ERROR;
		line = __LINE__;
		goto err;
	    }

	    if(esp_ibuf->spi != esp_obuf->spi) {
		printf("SeqNum=%u SPI corrupted: %x != %x\n", SeqNum, esp_ibuf->spi, esp_obuf->spi);
		rc = CAPI_INTERNAL_ERROR;
		line = __LINE__;
		goto err;
	    }
	    if(esp_ibuf->SeqNum != esp_obuf->SeqNum) {
		printf("SeqNum corrupted: %x != %x\n", esp_ibuf->SeqNum, esp_obuf->SeqNum);
		rc = CAPI_INTERNAL_ERROR;
		line = __LINE__;
		goto err;
	    }
	    if(iNextProto != oNextProto) {
		printf("SeqNum=%u nextProto corrupted: %2x != %2x\n", SeqNum, iNextProto, oNextProto);
		rc = CAPI_INTERNAL_ERROR;
		line = __LINE__;
		goto err;
	    }
	    if(memcmp(ibuf+sizeof(esp_buf), obuf+sizeof(esp_buf), olen-sizeof(esp_buf))) {
		printf("SeqNum=%u data corrupted\n", SeqNum);
		rc = CAPI_INTERNAL_ERROR;
		line = __LINE__;
		goto err;
	    }
	} else { //satype==CPIPSEC_PROTO_IPSEC_AH
	}
	free(ibuf);
	free(obuf);
	free(ibuf_e);
    }
#ifndef TEST_CONFORMITY
/*    .      -- 25--35  */
/*     SPLAT -      ioctl() */
#if !defined ESP_IO_KERNEL
    for(unsigned SeqNum=StartPacket_2; SeqNum<EndPacket_2; SeqNum++) {
	ilen = SeqNum*23;
	CERRSTACK( esp1->espEncapFn(spi_i_snd, espFlafs, 0, 0, &ilen, buflen, config), 0);
	if(rc == CAPI_TTL_BYTES_EXPIRED_ERROR) {
	    printf("Too much data for session -- check canceled\n");
	    break;
	}
	buflen = ilen;
	ilen = SeqNum*23;	//  
	obuf = (char*) malloc(ilen);
	esp_obuf = (esp_buf*) obuf;
	ibuf = (char*) malloc(buflen);
	
	memset(ibuf+sizeof(esp_buf), (char)(SeqNum-1000), ilen-sizeof(esp_buf)); // variable data
	
	if( satype == CPIPSEC_PROTO_IPSEC_ESP )
	{
	    esp_ibuf = (esp_buf*) ibuf;
	    esp_ibuf->spi = spi;	   // correct value
	    esp_ibuf->SeqNum = htonl(SeqNum); // variable value
	}
	else
	{
	    ah_ibuf = (ah_buf*) (ibuf+(espFlafs&0x000000ff));
	    ah_ibuf->prt = iNextProto + 0x00000400;	   // correct value
	    ah_ibuf->spi = spi;	   // correct value
	    ah_ibuf->SeqNum = htonl(SeqNum); // variable value
	    memset(((BYTE*)ah_ibuf)+sizeof(ah_buf),0,12);
	    for(unsigned j=0; j<(espFlafs&0x000000ff); j++)
		ibuf[j] = (char)j+0x20;
	    DWORD* dibuf = (DWORD*)ibuf;
	    dibuf[0]=0x54000045; dibuf[1]=0x00002C0A; 
	    dibuf[2]=0x00003300; dibuf[3]=0xA855A8C0;  dibuf[4]=0x7055A8C0; 
	    dibuf[11]=0x47550000; dibuf[12]=0x14000100;
	}	

	memcpy(obuf, ibuf, ilen);

	unsigned store_ilen = ilen;
	CERRSTACK( esp1->espEncapFn(spi_i_snd, espFlafs, &iNextProto, ibuf, &ilen, buflen, config), 0);
	if(rc == CAPI_TTL_BYTES_EXPIRED_ERROR) {
	    printf("espEncap ttlkb reached. line %d\n", __LINE__);
	    free(obuf);
	    free(ibuf);
	    break;
	}
	if(rc == CAPI_CSP_ERROR) {
	    printf("espEncap return CAPI_CSP_ERROR. line %d\n", __LINE__);
	    line = __LINE__;
	    goto err;
	}
	if(rc != CAPI_NOERROR) {
	    printf("espEncap return %u. line %d\n", rc, __LINE__);
	    line = __LINE__;
	    goto err;
	}

	olen = ilen;
	CERRSTACK(
	    esp2->espDecapFn(spi_r_rcv,
			     espFlafs & (satype==CPIPSEC_PROTO_IPSEC_ESP ? 0xFFFFFF00 : 0xFFFFFFFF),
			     &oNextProto, ibuf, &olen, config), 0);
	if(rc == CAPI_TTL_BYTES_EXPIRED_ERROR) {
	    printf("espDecap ttlkb reached. line %d\n", __LINE__);
	    free(obuf);
	    free(ibuf);
	    break;
	}

	if(store_ilen != olen) {
	    printf("SeqNum=%u datalen corrupted: %u != %u\n", SeqNum, store_ilen, olen);
	    rc = CAPI_INTERNAL_ERROR;
	    line = __LINE__;
	    goto err;
	}

	if( satype == CPIPSEC_PROTO_IPSEC_ESP )
	{
	    if(esp_ibuf->spi != esp_obuf->spi) {
		printf("SeqNum=%u SPI corrupted: %x != %x\n", SeqNum, esp_ibuf->spi, esp_obuf->spi);
		rc = CAPI_INTERNAL_ERROR;
		line = __LINE__;
		goto err;
	    }
	    if(esp_ibuf->SeqNum != esp_obuf->SeqNum) {
		printf("SeqNum corrupted: %x != %x\n", esp_ibuf->SeqNum, esp_obuf->SeqNum);
		rc = CAPI_INTERNAL_ERROR;
		line = __LINE__;
		goto err;
	    }
	}
	if(iNextProto != oNextProto) {
	    printf("SeqNum=%u nextProto corrupted: %2x != %2x\n", SeqNum, iNextProto, oNextProto);
	    rc = CAPI_INTERNAL_ERROR;
	    line = __LINE__;
	    goto err;
	}
	if(memcmp(ibuf+sizeof(esp_buf), obuf+sizeof(esp_buf), olen-sizeof(esp_buf))) {
	    printf("SeqNum=%u data corrupted\n", SeqNum);
	    rc = CAPI_INTERNAL_ERROR;
	    line = __LINE__;
	    goto err;
	}
	free(ibuf);
	free(obuf);
    }

    //  
    if(satype == CPIPSEC_PROTO_IPSEC_ESP) {
	printf("Check repeated packets...");
	check_wnd_processing(esp1, esp2, spi, spi_i_snd, spi_r_rcv); //   
	printf("... done\n");
    }
    
#endif	// !ESP_IO_KERNEL
#endif /*TEST_CONFORMITY*/
/* 10.   */
    esp1->sadb.DestroyPrivKeyFn(0, &espPriv1);
    esp2->sadb.DestroyPrivKeyFn(0, &espPriv2);
    
    esp1->destroyFn(0, spi_i_snd);
    esp1->destroyFn(0, spi_i_rcv);
    shutdown_esp_module(esp1, 0);

    esp2->destroyFn(0, spi_r_snd);
    esp2->destroyFn(0, spi_r_rcv);
    shutdown_esp_module(esp2, 0);

    if( hProv1 )
	CapiReleaseContext(m1, hProv1,0);
    if( hProv2 )
	CapiReleaseContext(m2, hProv2,0);

    printf("Destroy HCRYPTMODULE...");
    CERR(DestroyHCRYPTMODULE(m1));
    m1 = 0;
    CERR(DestroyHCRYPTMODULE(m2));
    m2 = 0;
    printf("...done\n");
    return 0;

  err:
    printf("\n%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);

    if(esp1) {
	esp1->destroyFn(0, spi_i_snd);
	shutdown_esp_module(esp1, 0);
    }
    if(esp2) {
	esp2->destroyFn(0, spi_r_rcv);
	shutdown_esp_module(esp2, 0);

    }
#if defined ESP_IO_KERNEL
    if(m1)
	DestroyHCRYPTMODULE(m1);
    if(m2)
	DestroyHCRYPTMODULE(m2);
#endif	// ESP_IO_KERNEL
    return rc;
}

typedef struct log_data_ {
    esp_gost_handle h;
    log_severity_t level;
} Log_Data_t, *pLog_Data_t;

/* support funcs */
static void CAPI_EXTC 
log_func(void *a, 
	 log_severity_t severity, unsigned uFlags, 
	 const char *fmt, ...)
{
    UNUSED(uFlags);
    va_list ap;
    pLog_Data_t pld = (pLog_Data_t)a; 

    if(severity <= pld->level){
	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);
	printf("\n");
    }
}

static void CAPI_EXTC 
set_log_level(void *a, log_severity_t level, unsigned uFlags)
{
    UNUSED(uFlags);
    pLog_Data_t pld = (pLog_Data_t)a; 
    pld->level = level;
}

#if defined ESP_IO_KERNEL
#   include "io_krn.h"
#ifndef _WIN32
#   include <unistd.h>
#   include <sys/types.h>
#   include <sys/stat.h>
#   include <fcntl.h>
#   include <cerrno>
#   include <sys/ioctl.h>
#endif //_WIN32
#   include <map>

static char iobuf[128*1024];
static int fd = -1;
static int was_opened = 0;

#ifdef _WIN32
static int ioctl( int hf, unsigned code, void * )
{
    unsigned buflen = sizeof(iobuf);
    if( !DeviceIoControl( (HANDLE)(long long)hf, code, iobuf, sizeof(iobuf), iobuf, sizeof(iobuf), (LPDWORD)&buflen, 0 ) )
	return true;
    return 0;
}
static int open( char * , int )
{
    //      
    HANDLE hDrv = CreateFile( TEXT("\\\\.\\CPIPSEC_TEST"),
	    GENERIC_READ | GENERIC_WRITE,
	    0,
	    NULL,
	    OPEN_EXISTING,
	    FILE_ATTRIBUTE_NORMAL,
	    NULL );
    return (int)(long long)hDrv;
}

static int close( int hf )
{
    CloseHandle( (HANDLE)(long long)hf );
    return true;
}

#endif//_WIN32

//       esp_gost_handle
//  esp_gost_handle  
//   esp-   
//   

//   esp_init  esp_shutdown
typedef std::map<esp_gost_handle,void*> shadow_handles;
static shadow_handles shadow;

capi_result io_krn_CreateEphem(
    HCRYPTMODULE m,   
    HCRYPTPROV hProv,
    unsigned uFlags,
    PRIVKEY *hPriv,   /*     */
    unsigned char* pcsadbSA, /*      */
    unsigned* pusadbSALen) /*       */
{
    UNUSED(hProv); //     

    struct create_ephem *ce;
    ce = (struct create_ephem*) iobuf;
    ce->hdr.uFlags = uFlags;
    ce->hdr.len = sizeof(ce->hm);
    ce->hm = (unsigned)(UINT_PTR)m;
    //   
    CERR_START;
    CERR(ioctl(fd, IOCTL_CREATEEPHEM, iobuf));

    *pusadbSALen = ce->pusadbSALen;
    if(pcsadbSA) {
	hPriv->hKey = (HCRYPTKEY)(UINT_PTR)ce->hpK;
	hPriv->hModule = (HCRYPTMODULE)(UINT_PTR)ce->hpM;
	hPriv->hProv = (HCRYPTPROV)(UINT_PTR)ce->hpP;
	memcpy(pcsadbSA, &ce->pcsadbSA[0], ce->pusadbSALen);
    }

 CERR_END:
    printf("ioctl error:%d %d\n", line, errno);
    return CAPI_INTERNAL_ERROR;
}

capi_result io_krn_deSerializePubKey(
    HCRYPTMODULE m,
    HCRYPTPROV hProv,
    const unsigned char* pcsadbSA, 
    unsigned pcsadbSALen, 
    unsigned uFlags,
    PUBKEY_2012 *hPub,
    CPC_CONFIG * config) /*     */
{
    UNUSED(config);
    UNUSED(hProv); //       

    struct deserializePubKey *ds = (struct deserializePubKey*) iobuf;
    ds->hdr.uFlags = uFlags;
    ds->hdr.len = sizeof(ds->hm)+sizeof(ds->key)+sizeof(unsigned)+pcsadbSALen;
    ds->hm = (unsigned)(UINT_PTR)m;
    ds->pcsadbSALen = pcsadbSALen;
    memcpy(&ds->pcsadbSA[0], pcsadbSA, pcsadbSALen);

    CERR_START;
    CERR(ioctl(fd, IOCTL_DESERPUBKEY, iobuf));

    memcpy(hPub, &ds->key, sizeof(PUBKEY_2012));

 CERR_END:
    printf("ioctl error:%d %d res = %x\n", line, errno, ds->hdr.res);
    return ds->hdr.res;
}

capi_result io_krn_DestroyPrivKey(
    unsigned uFlags,
    PRIVKEY *hPriv)  /*     */
{
    struct destroyPrivKey *dp;
    dp = (struct destroyPrivKey*) iobuf;
    dp->hdr.uFlags = uFlags;
    dp->hdr.len = sizeof(dp->hpK)+sizeof(dp->hpM)+sizeof(dp->hpP);
    dp->hpK = (unsigned)(UINT_PTR)hPriv->hKey;
    dp->hpM = (unsigned)(UINT_PTR)hPriv->hModule;
    dp->hpP = (unsigned)(UINT_PTR)hPriv->hProv;

    CERR_START;
    CERR(ioctl(fd, IOCTL_DESTROYPRIV, iobuf));

 CERR_END:
    printf("ioctl error:%d %d\n", line, errno);
    return CAPI_INTERNAL_ERROR;
}

capi_result io_krn_DestroyPubKey(
    unsigned uFlags,
    PUBKEY_2012 *hPub) /*     */
{
    struct destroyPubKey *dp;
    dp = (struct destroyPubKey*) iobuf;
    dp->hdr.uFlags = uFlags;
    dp->hdr.len = sizeof(dp->key);
    memcpy(&dp->key, hPub, sizeof(PUBKEY_2012));

    CERR_START;
    CERR(ioctl(fd, IOCTL_DESTROYPUB, iobuf));

 CERR_END:
    printf("ioctl error:%d %d\n", line, errno);
    return CAPI_INTERNAL_ERROR;
}
#endif // ESP_IO_KERNEL

#if defined ESP_IO_KERNEL
static HCRYPTMODULE
CreateHCRYPTMODULE()
{
    DWORD dwDatalen = 115; /* XXX dim:   GetProvParam() */
    HCRYPTPROV hProv;

    struct create_hmodule *cm;
    cm = (struct create_hmodule*) iobuf;

    /*       */
    CERR_START;

    CERR( CapiAcquireContext( hModuleIke, &hProv, 0, 0, PROV_GOST_2001_DH, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001));
    CERR( CapiGetProvParam( hModuleIke, hProv, PP_RANDOM, (BYTE*)&cm->rnd[0], &dwDatalen, 0)); //  .      .
    CERR( CapiReleaseContext( hModuleIke, hProv, 0));

    cm->hdr.uFlags = 0;
    cm->hdr.len = dwDatalen + sizeof(cm->hm);
    //       CryptGetProvParam()   
    if(!was_opened) { //   h
	CERRASSERT(0 <= (fd = open("/dev/tstesp", 0)), CAPI_INTERNAL_ERROR);
    }
    was_opened++;
    CERR(ioctl(fd, IOCTL_CREATEHMODULE, iobuf));

    return (HCRYPTMODULE)(UINT_PTR)cm->hm;
 err:
    printf("cant create cryptmodule, line %d, rc=%x", line, rc);
    return 0;
}

static DWORD
DestroyHCRYPTMODULE(HCRYPTMODULE m)
{
    struct destroy_hmodule *dm;
    DWORD res;

    dm = (struct destroy_hmodule*) iobuf;
    dm->hdr.uFlags = 0;
    dm->hdr.len = sizeof(dm->hm);
    dm->hm = (unsigned)(UINT_PTR)m;
    res = ioctl(fd, IOCTL_DESTROYHMODULE, iobuf);
    if(res != CAPI_NOERROR) {
	printf("cant destroy cryptmodule, line %d, rc=%x", __LINE__, res);
	return res;
    }
    if(was_opened>0)
	was_opened--;
    if(!was_opened) {
	close(fd);
	fd = -1;
    }
    return 0;
}
#else
#ifndef TEST_CONFORMITY
static HCRYPTMODULE
CreateHCRYPTMODULE()
{
    HCRYPTMODULE m;
    GetNewModule( &m, 0, 0 );
    return m;
}
static DWORD
DestroyHCRYPTMODULE(HCRYPTMODULE m)
{
    (void)m;
    return 0;
}
#else //TEST_CONFORMITY
static HCRYPTMODULE 
CreateHCRYPTMODULE()
{
    return GetNewModule_Crypt();
}
static DWORD
DestroyHCRYPTMODULE( HCRYPTMODULE m )
{
    ReleaseModule_Crypt( m );
    return 0;
}
#endif //TEST_CONFORMITY
#endif	// !ESP_IO_KERNEL

static esp_gost_handle
init_esp_module(unsigned NumSessions)
{
    unsigned rc = CAPI_INTERNAL_ERROR;
    int line;
    esp_gost_handle h = 0;

    esp_gost_out esp_out_init_data;
    esp_gost_in esp_in_init_data = {
	API_IPSEC_GOST_MAJOR, API_IPSEC_GOST_MINOR, 
	NumSessions, 
	0, log_func, set_log_level,
	0, "123" };
    pLog_Data_t pld = new Log_Data_t;

    pld->level = CAPI_INFO;
    esp_in_init_data.pUfnArg = pld;
#if !defined ESP_IO_KERNEL
    CERR(cpesp_init_gost(h, &esp_in_init_data, 0, &esp_out_init_data));
    CERRASSERT(NULL != (h = (esp_gost_handle)
			malloc(esp_out_init_data.requiredMem)), CAPI_INTERNAL_ERROR);
    esp_in_init_data.allocatedMem = esp_out_init_data.requiredMem;
    CERR(cpesp_init_gost(h, &esp_in_init_data, 0, &esp_out_init_data));
#else
    CERRASSERT(NULL != (h = (esp_gost_handle)
			malloc(sizeof(*h))), CAPI_INTERNAL_ERROR);
    if(!was_opened) { //   h
	CERRASSERT(0 <= (fd = open("/dev/tstesp", 0)), CAPI_INTERNAL_ERROR);
    }
    was_opened++;

    struct init_data *id;
    id = (struct init_data*) iobuf;

    id->hdr.uFlags = 0;
    id->hdr.len = 4*sizeof(unsigned);
    id->major = esp_in_init_data.apiVersionMajor;
    id->minor = esp_in_init_data.apiVersionMinor;
    id->num_session = esp_in_init_data.maxSessions;
    id->datalen = 0;

    CERR(ioctl(fd, IOCTL_INIT_MODULE, iobuf));

    CERRASSERT(id->hdr.res == CAPI_NOERROR, CAPI_INTERNAL_ERROR);

    // dim:    , ..  ,
    // dim:  malloc   
    shadow[h] = (void *)(UINT_PTR)id->hh;

    esp_out_init_data = id->u.eou; //  
    printf("Kernel memory used %f Kb\n", esp_out_init_data.requiredMem/1024.);
    printf("Vendor-ID: ");
    for(unsigned i = 0; i < esp_out_init_data.cVIDLen; i++) {
	printf("%02x", esp_out_init_data.cVID[i]&0xff);
    }
    printf("\n");	
    h->pUfnArg = pld;
    h->LogUfn = log_func;
    h->SetLogLvlUfn = io_krn_SetLogLvl;
    h->destroyFn = io_krn_destroy;
    h->spiCreateFn = io_krn_spiCreate;
    h->espEncapFn = io_krn_espEncap;
    h->espDecapFn = io_krn_espDecap;
    h->sadb.CreateEphemFn = io_krn_CreateEphem;
    h->sadb.deSerializePubKeyFn = io_krn_deSerializePubKey;
    h->sadb.DestroyPrivKeyFn = io_krn_DestroyPrivKey;
    h->sadb.DestroyPubKeyFn = io_krn_DestroyPubKey;
#endif // ESP_IO_KERNEL
    pld->h = h;

    return h;

err:
    printf("\n%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    free(h);
    if(pld)
	delete pld;
    return 0;
}

static void shutdown_esp_module(esp_gost_handle h, DWORD flags)
{
    delete (pLog_Data_t)h->pUfnArg;
#if !defined ESP_IO_KERNEL
    cpesp_shutdown_gost(h,flags);
#else

    struct shutdown_data *sd = (struct shutdown_data*) iobuf;
    sd->hdr.uFlags = flags;
    sd->hdr.len = sizeof(sd->hh);
    sd->hh = (unsigned)(UINT_PTR)shadow[h];
    shadow.erase(h);
    
    int res;
    res = ioctl(fd, IOCTL_SHUTDOWN_MODULE, iobuf);

    if(res == -1) {		// ioctl() error
	perror("shutdown_esp_module:ioctl fail");
	close(fd);
	exit(errno);
    }
    if(was_opened>0)
	was_opened--;
    if(!was_opened) {
	close(fd);
	fd = -1;
    }
    h->pUfnArg = 0;
    h->LogUfn = 0;
    h->SetLogLvlUfn = 0;
    h->destroyFn = 0;
    h->spiCreateFn = 0;
    h->espEncapFn = 0;
    h->espDecapFn = 0;
#endif
    free(h);
}

#if defined ESP_IO_KERNEL
capi_result io_krn_spiCreate(esp_gost_handle h,
			     PRIVKEY *hPriv,
			     PUBKEY_2012 *hPub,
			     const unsigned char *pcIPsecSA, 	/*   */
			     unsigned uIPsecSALen,
			     unsigned uFlags, ESP_HANDLE *sid, CPC_CONFIG *config)
{
    UNUSED(config);
    if(uFlags) {
	printf("io_krn_spiCreate:uFlags != 0\n");
	return CAPI_INTERNAL_ERROR;
    }
    struct spi_create *sc = (struct spi_create*) iobuf;
    
    sc->hdr.uFlags = uFlags;
    sc->hdr.len = sizeof(sc->hsid) + sizeof(sc->hh) + sizeof(sc->hpK) + sizeof(sc->hpM) + sizeof(sc->hpP) + sizeof(sc->keyPub) + sizeof(sc->uIPsecSALen) + uIPsecSALen;
    sc->hh = (unsigned)(UINT_PTR)shadow[h];
    sc->hpK = (unsigned)(UINT_PTR)hPriv->hKey;
    sc->hpM = (unsigned)(UINT_PTR)hPriv->hModule;
    sc->hpP = (unsigned)(UINT_PTR)hPriv->hProv;
    memcpy(&sc->keyPub, hPub, sizeof(PUBKEY_2012));
    sc->uIPsecSALen = uIPsecSALen;
    memcpy(&sc->pcIPsecSA[0], pcIPsecSA, uIPsecSALen);

    int res;
    res = ioctl(fd, IOCTL_SPICREATE, iobuf);

    if(res == -1) {		// ioctl() error
	perror("io_krn_spiCreate:ioctl fail");
	close(fd);
	return CAPI_INTERNAL_ERROR;
    }
    *sid = (ESP_HANDLE)(UINT_PTR)sc->hsid;

    return sc->hdr.res;
}

capi_result io_krn_destroy(unsigned uFlags, ESP_HANDLE sid)
{
    struct spi_delete *sd = (struct spi_delete*) iobuf;
    sd->hdr.uFlags = uFlags;
    sd->hdr.len = sizeof(sd->hsid);
    sd->hsid = (unsigned)(UINT_PTR)sid;

    int res;
    res = ioctl(fd, IOCTL_SPIDELETE, iobuf);
    if(res == -1) {		// ioctl() error
	perror("shutdown_esp_module:ioctl fail");
	close(fd);
	return CAPI_INTERNAL_ERROR;
    }
    return CAPI_NOERROR;
}

void io_krn_SetLogLvl(void *pUfnAgr, log_severity_t severity, unsigned uFlags)
{
    set_log_level(pUfnAgr, severity, uFlags);
    struct set_loglevel *sl = (struct set_loglevel*) iobuf;
    sl->hdr.uFlags = uFlags;
    sl->hdr.len = sizeof(sl->level);
    sl->level = severity;

    int res;
    res = ioctl(fd, IOCTL_SET_LOGLVL, iobuf);
    if(res) {
	perror("io_krn_SetLogLvl:ioctl fail");
	close(fd);
	exit(errno);
    }
}

capi_result io_krn_espEncap(ESP_HANDLE sid,
			    unsigned uFlags,
			    char * cNextProto, void *pData,
			    unsigned *puDataLen, unsigned uBufLen, CPC_CONFIG *config)
{
    UNUSED(config);
    struct encap *ed = (struct encap*) iobuf;
    ed->hdr.uFlags = uFlags;
    ed->hdr.len = sizeof(ed->hsid) + sizeof(ed->datalen) + sizeof(ed->buflen);
    ed->hsid = (unsigned)(UINT_PTR)sid;
    ed->datalen = *puDataLen;
    if(pData) {
	ed->hdr.len += sizeof(ed->NextProto);
	ed->hdr.len += *puDataLen;	 /*  */
	ed->buflen = uBufLen;
	ed->NextProto = (*cNextProto) & 0xff;
	memcpy(ed->d, pData, *puDataLen);
    } else {
	ed->buflen = 0;
    }

    int res;
    res = ioctl(fd, IOCTL_ENCAP, iobuf);
    if(res == -1) {		// ioctl() error
	perror("io_krn_espEncap:ioctl fail");
	close(fd);
	return CAPI_INTERNAL_ERROR;
    }

    *puDataLen = ed->datalen;
    if(pData) {
	memcpy(pData, ed->d, ed->datalen);
    }

    return ed->hdr.res;
}

capi_result io_krn_espDecap(ESP_HANDLE sid,
			    unsigned uFlags,
			    char *pcNextProto,
			    void *pData, unsigned *puDataLen, CPC_CONFIG *config)
{
    UNUSED(config);
    if(!pcNextProto) {
	printf("io_krn_espDecap:pcNextProto=0\n");
	close(fd);
	return CAPI_INTERNAL_ERROR;
    }
    if(!pData) {
	printf("io_krn_espDecap:pData=0\n");
	close(fd);
	return CAPI_INTERNAL_ERROR;
    }
    if(!puDataLen) {
	printf("io_krn_espDecap:puDataLen=0\n");
	close(fd);
	return CAPI_INTERNAL_ERROR;
    }

    struct decap *dd = (struct decap*) iobuf;
    dd->hdr.uFlags = uFlags;
    dd->hdr.len = sizeof(dd->hsid) + 2*sizeof(unsigned) + dd->datalen;
    dd->hsid = (unsigned)(UINT_PTR)sid;
    dd->datalen = *puDataLen;
    memcpy(dd->d, pData, dd->datalen);

    int res;
    res = ioctl(fd, IOCTL_DECAP, iobuf);
    if(res == -1) {		// ioctl() error
	perror("io_krn_espDecap:ioctl fail");
	close(fd);
	return CAPI_INTERNAL_ERROR;
    }
    *pcNextProto = dd->NextProto & 0xff;
    memcpy(pData, dd->d, dd->datalen);
    *puDataLen = dd->datalen;

    return dd->hdr.res;
}
#endif	// ESP_IO_KERNEL


/*  Buf  IOVec,
       IOVec   Encap()
    encrypt: CPESP_NULL,CPESP_GOST_4M_IMIT,CPESP_GOST_1K_IMIT
    ilen - espHDR + PL
    
    */
/* 0-       IOV_0_COORD=1 
   0-        IOV_0_COORD=0 */
#define IOV_0_COORD 1
/* POST-       E2 IOV_POST_COORD=1 
   POST-        E2 IOV_POST_COORD=0 */
#define IOV_POST_COORD 1

#if 0
static DWORD
IOVectoBuf_E(DWORD encrypt, BYTE* Buf, DWORD Buflen,  DWORD ilen,
	   CSP_iovec ** piov, DWORD * piovlen, DWORD * piovs)
{
    UNUSED(Buflen);

    if(encrypt!=CPESP_NULL) {
	if(*piovs < 5) {
	return CAPI_CSP_ERROR;
	}
    } else {
	if(*piovs < 4) {
	return CAPI_CSP_ERROR;
	}
    }
    
    CSP_iovec *iov = NULL;
    iov = (CSP_iovec *)malloc((*piovs+IOV_0_COORD)*sizeof(CSP_iovec));
    if(!iov) return CAPI_CSP_ERROR;
    BYTE* p = Buf;
    DWORD espHDRlen = 8;
    DWORD IVlen =8;
    DWORD res= ilen;
    DWORD lio,olen=0;
    DWORD padlen, Imlen = 0;
    switch(encrypt) {
	case CPESP_NULL:
	    Imlen = 12;
	    break;
	case CPESP_GOST_4M_IMIT:
	    Imlen = 4;
	    break;
	case CPESP_GOST_1K_IMIT:
	    Imlen = 8;
	    break;
    }
    if(IOV_0_COORD) {
	iov[0].CSPiov_ptr = NULL;
	iov[0].CSPiov_len = 0;
    }

    iov[0+IOV_0_COORD].CSPiov_ptr = (CHAR *)malloc(espHDRlen);
    iov[0+IOV_0_COORD].CSPiov_len = espHDRlen;
    memcpy(iov[0+IOV_0_COORD].CSPiov_ptr,p,espHDRlen);
    p+=espHDRlen;
    res-= espHDRlen;
    olen+=espHDRlen;
    int b,e,r;
    if(encrypt!=CPESP_NULL) {
	iov[1+IOV_0_COORD].CSPiov_ptr = (CHAR *)malloc(IVlen);
	iov[1+IOV_0_COORD].CSPiov_len = IVlen;
	b=2;e=*piovs-1;r=*piovs-3;
	lio = res/(r);
	olen+=IVlen;
    } else {
	b=1;e=*piovs-1;r=*piovs-2;
	lio = res/(r);
    }

    for(int n = b; n<e ;n++) {
	if(n==e-1) {
	    lio = res-(r-1)*lio;
	}
	iov[n+IOV_0_COORD].CSPiov_ptr = (CHAR *)malloc(lio);
	iov[n+IOV_0_COORD].CSPiov_len = lio;
	memcpy(iov[n+IOV_0_COORD].CSPiov_ptr,p,lio);
	p+=lio;
	olen+=lio;
    }

    switch(encrypt) {
	case CPESP_NULL:
	    Imlen = 12;
	    break;
	case CPESP_GOST_4M_IMIT:
	    Imlen = 4;
	    break;
	case CPESP_GOST_1K_IMIT:
	    Imlen = 8;
	    break;
    }

    padlen = ( 8 - (ilen+2) % 8 ) % 8 + 2 + Imlen;
    iov[*piovs+IOV_0_COORD-1].CSPiov_ptr = (CHAR *)malloc(padlen);
    iov[*piovs+IOV_0_COORD-1].CSPiov_len = padlen;
    olen+=padlen;


    *piovs+=IOV_0_COORD;
    *piov = iov;
    *piovlen = olen;

    return CAPI_NOERROR;
}
#endif /* 0 */

/*  Buf  IOVec,
         IOVec   Decap()
      { a,b,c ... }, LS = k -     
    */
#define LS 2
static DWORD Sh[LS] = {2,1};
//#define LS 3
//DWORD Sh[LS] = {2,3,1};

static DWORD
IOVectoBuf_D(DWORD encrypt, DWORD decap, BYTE* Buf, DWORD Buflen, 
	   CSP_iovec **piov, DWORD *piovlen, DWORD *piovs)
{
    DWORD Ss, iovs_, res, iovcoord;
    Ss = 0;
    for(int n=0; n<LS; n++) Ss+=Sh[n];
    iovs_ = LS*(Buflen/Ss);
    res = Buflen%Ss;
    if(res) iovs_++;
    
    CSP_iovec *iov = NULL;
    iov = (CSP_iovec *)malloc((iovs_+IOV_0_COORD+IOV_POST_COORD)*sizeof(CSP_iovec));
    if(!iov) return CAPI_CSP_ERROR;
    iovcoord = IOV_0_COORD;
    if(iovcoord) {
	iov[0].CSPiov_ptr = NULL;
	iov[0].CSPiov_len = 0;
    }
    if(encrypt!=CPESP_NULL && !decap) {
	memmove( (char *)Buf + 16, (char *)Buf + 8, Buflen - 16 );
    }

    BYTE* p = Buf;
    DWORD olen=0;
    if(res) iovs_--;
    for(int n_ = IOV_0_COORD; n_ < (int)(iovs_+IOV_0_COORD);n_++) {
	int n = n_ - IOV_0_COORD;
	iov[n_].CSPiov_ptr = (CHAR *)malloc(Sh[n%LS]);
	iov[n_].CSPiov_len = Sh[n%LS];
	memcpy(iov[n_].CSPiov_ptr,p,Sh[n%LS]);
	p+=Sh[n%LS];
	olen+=Sh[n%LS];
    }

    if(res){
	iovs_++;
	iov[iovs_+IOV_0_COORD-1].CSPiov_ptr = (CHAR *)malloc(res);
	iov[iovs_+IOV_0_COORD-1].CSPiov_len = res;
	memcpy(iov[iovs_+IOV_0_COORD-1].CSPiov_ptr,p,res);
	olen+=res;
    }
    iovcoord = IOV_POST_COORD;
    if(iovcoord==1) {
	iov[iovs_+IOV_0_COORD].CSPiov_ptr = NULL;
	iov[iovs_+IOV_0_COORD].CSPiov_len = 0;
    }
    if(olen!=Buflen)
    {
	free(iov);
	return CAPI_CSP_ERROR;
    }

    *piov = iov;
    *piovs = iovs_+IOV_0_COORD+IOV_POST_COORD;
    *piovlen = olen;

    return CAPI_NOERROR;
}



/*   IOVec  Buf,
     Buf, Buf    *pBuflen*/
static DWORD
BuftoIOVec( CSP_iovec * iov, DWORD iovs,
	   BYTE* Buf, DWORD *pBuflen)
{
    DWORD iovlen=0;
    for(int i=0;i<(int)iovs; i++) {
	iovlen+=iov[i].CSPiov_len;
    }
    if(iovlen>*pBuflen) {
	*pBuflen = iovlen;
	return CAPI_CSP_ERROR;
    }
    BYTE* p = Buf;
    iovlen = 0;
    for(int i=0;i<(int)iovs; i++) {
	if(iov[i].CSPiov_ptr) {
	    memcpy(p,iov[i].CSPiov_ptr,iov[i].CSPiov_len);
	    p+=iov[i].CSPiov_len;
	    iovlen+=iov[i].CSPiov_len;
	}
    }
    if(iovlen!=*pBuflen)
	return CAPI_CSP_ERROR;

    return CAPI_NOERROR;
}

static void DestroyIOVec(CSP_iovec * iov, DWORD iovs)
{
    for(int i=0; i<(int)iovs; i++) {
	free(iov[i].CSPiov_ptr);
    }
    free(iov);
    return;    
}

#if 0
DWORD
cpyIOVec( CSP_iovec * iov, DWORD iovs,
	  CSP_iovec **piov)
{
    DWORD iovlen=0;
    for(int i=0;i<(int)iovs; i++) {
	iovlen+=iov[i].CSPiov_len;
    }

    CSP_iovec *iov_ = NULL;
    iov_ = (CSP_iovec *)malloc(iovs*sizeof(CSP_iovec));
    if(!iov_) return CAPI_CSP_ERROR;

    for(int n_ = 0; n_ < (int)(iovs);n_++) {
	if(iov[n_].CSPiov_len) {
	    iov_[n_].CSPiov_ptr = (CHAR *)malloc(iov[n_].CSPiov_len);
	    if(!iov_[n_].CSPiov_ptr) return CAPI_CSP_ERROR;
	    iov_[n_].CSPiov_len = iov[n_].CSPiov_len;
	    memcpy(iov_[n_].CSPiov_ptr,iov[n_].CSPiov_ptr,iov[n_].CSPiov_len);
	}
    }
    *piov = iov_;

    return CAPI_NOERROR;
}
#endif	// 0
