/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2005-2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 221303 $
 * \date $Date:: 2020-11-12 18:10:04 +0300#$
 * \author $Author: pdn $
 *
 * \brief
 *
 */
#include "common.h"
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef _WIN32
    #include <windows.h>
    #include <wincrypt.h>
    #include <tchar.h>
#else
    #include <reader/tchar.h>
#endif
#include "wincspc.h"
#include "WinCryptEx.h"
#include "typedefs.h"
#include "ike_gost.h"
#include "psk_gost.h"
#include "sadb.h"
#include "init_plg.h"
#include "example.h"
#include "cryptmodule.hpp"

static bool
check_get_cert(p1_ir_state* i, vblob **CERT, vblob **BLOB);

static bool
check_p1_serdeser(p1_ir_state* i, p1_ir_state* r);

void example_certificate_usage()
{
    printf(
"Usage of IPsec certificate example:\n"
"  Your must have two keys, 'IPsecA' and 'IPsecB' with certificates\n"
//XTODO:     cryptcp
//"  in 'Current User Store'. Keys must have password 'IPsecA' and\n"
//"  'IPsecB'.\n"
"  in 'Current User Store'. Both this keys must have empty password.\n"
"  Also Your need certificate chain (for example, Root certificate of\n"
"  'Test Center CRYPTO-PRO').\n"
"\n"
"For Windows (IE):\n"
"  0. See TechNet 'Using Windows Server 2003 Certificate Services Web\n"
"     pages' <http://technet.microsoft.com/en-us/library/cc757425.aspx>\n"
"     <http://support.microsoft.com/kb/323342>,\n"
"     <http://support.microsoft.com/kb/253498>;\n"
"  1. Open URL <http://www.cryptopro.ru/certsrv> for Windows\n"
"     2000/XP/2003, or <http://www.cryptopro.ru/certsrv_vista> for\n"
"     Windows Vista/2008 (Your need to enable unsigned ActiveX,\n"
"     see 'Internet options'->'Security');\n"
"  2. Fill 'Name' field ('IPsecA' or 'IPsecB');\n"
"  3. Choice 'IPsec Certificate' type;\n"
"  4. Choice 'Crypto-Pro GOST R 34.10-2001...' CSP;\n"
"  5. Choice 'Both' button;\n"
"  6. Choice 'User specified key container name' button;\n"
"  7. Fill 'Container Name' field ('IPsecA' or 'IPsecB');\n"
"  8. Choice 'Mark keys as exportable' button (for debug);\n"
"  9. Check for unselected choice 'Store certificate in the local;\n"
"     computer certificate store';\n"
//XTODO:     cryptcp
//" 10. Enter password '1', when keys and certificate request "
//"     generating;\n"
" 10. Enter empty password;\n"
"For SPLAT (or other Unix, Linux, Solaris, etc.):\n"
"  0. See CryptCP.pdf and certmgr.pdf form CryptoPro CSP CD-ROM\n"
"     or 'man certmgr'\n"
"     <\\\\cp.ru\\dfs\\prerelease\\csp-3-6\\Doc\\certmgr\\certmgr.pdf>\n"
"     <\\\\cp.ru\\dfs\\prerelease\\csp-3-6\\checked\\csp\\sdk\\CHM\\ 'CryptCP'.doc>\n"
"  1. /opt/cprocsp/bin/ia32/cryptcp -creatcert \\\n"
"     -CA 'http://www.cryptopro.ru/certsrv' -dn CN=IPsecA \\\n"
"     -certusage 1.3.6.1.5.5.8.2.2 -provtype 75 -both \\\n"
"     -cont '\\\\.\\HDIMAGE\\IPsecA' -exprt -ku;\n"/* -askpin;\n"*/
"  2. /opt/cprocsp/bin/ia32/cryptcp -creatcert \\\n"
"     -CA 'http://www.cryptopro.ru/certsrv' -dn CN=IPsecB \\\n"
"     -certusage 1.3.6.1.5.5.8.2.2 -provtype 75 -both \\\n"
"     -cont '\\\\.\\HDIMAGE\\IPsecB' -exprt -ku;\n"/* -askpin;\n"*/
    );
    #if defined(_WIN32)
	fprintf(stderr, "Press <Enter> to exit.");
	getchar();
    #endif
}

static const char fp1[] = "11783"; //    (, )
static const char fp2[] = "01:23:45:67:89:01:2345678901234567890123456780"; //    (, )
static const char NetID[] = "Net73"; //   (    )
static const char IDii[8]={13,33,77,1,0,0,0,1};
static const char IDir[8]={99,66,33,2,0,0,0,2};
static const char d_SA[4]={2,2,2,3};

GlobalParams globalParamState;

int main_old(int argc, char** argv);

int main( int argc, char** argv )
{
    char aszOID_Gost28147_89_CryptoPro_B_ParamSet[]=szOID_Gost28147_89_CryptoPro_B_ParamSet;
    char aszOID_Gost28147_89_TC26_A_ParamSet[]=szOID_Gost28147_89_TC26_A_ParamSet;
    char * g28147oids[] = { aszOID_Gost28147_89_CryptoPro_B_ParamSet, aszOID_Gost28147_89_TC26_A_ParamSet };

    for( int i = 0; i < 2; i++ )
    {
	globalParamState.g28147oid = g28147oids[ i ];
	DWORD rc = main_old( argc, argv );
	if( rc )
	{
	    return rc; // Error
	}
    }
    return 0;
}

#if defined _WIN32
#define CONT_IPSEC_A "\\\\.\\registry\\IPsecA"
#define CONT_IPSEC_B "\\\\.\\registry\\IPsecB"
#else
#define CONT_IPSEC_A "\\\\.\\hdimage\\IPsecA"
#define CONT_IPSEC_B "\\\\.\\hdimage\\IPsecB"
#endif // _WIN32

int main_old(int argc, char** argv)
{
    unsigned rc;
    int line;
    const int PSK_LENGTH = 28;
    char PSK1[PSK_LENGTH + 1], PSK2[PSK_LENGTH + 1], d_PSKir[2 * PSK_LENGTH + 1];
    
    if (argc == 4) {
	strcpy(PSK1, argv[1]);
	strcpy(PSK2, argv[2]);
	strcpy(d_PSKir, argv[3]);
    } else {
	printf("USAGE: ike_example  <PSK1>  <PSK2>  <PSK3>\n");
	return 1;
    }
    {
	HCRYPTMODULE htemp;
	GetNewModule( &htemp, 0, 0 );
    }
    //IPSEC-436   64,      
    {
	const int blobcount = 1024;
	const int blobsize = 65536;
	vblob * memtestblobs[blobcount];
	char cc[blobsize];
	for( int i = 1; i < blobcount; i++ ) 
	{
	    memtestblobs[i] = vcreate( GetCPCConfig(), DT_EXTDATA, cc, sizeof(cc) );
	    if( !memtestblobs[i] )
	    {
		printf("ERROR: out of memory");
		return 1;
	    }
	}
	for( int i = 1; i < blobcount; i++ )
	    vdelete( &memtestblobs[i] );	
    }    

    // Vendor_IDs    
    // For example, DPD Vendor ID [RFC 3706]
    char s_vid_1[] = "\xAF\xCA\xD7\x13\x68\xA1\xF1\xC9\x6B\x86\x96\xFC\x77\x57\x01\x00";
    const vblob * vid_1 = vcreate(GetCPCConfig(), DT_EXTDATA, s_vid_1, sizeof(s_vid_1));
    // Next example, Microsoft IKE Protocol with GSS-API
    char s_vid_2[] = "\x1e\x2b\x51\x69\x05\x99\x1c\x7d\x7c\x96\xfc\xbf\xb5\x87\xe4\x61\x00\x00\x00\x04";
    const vblob * vid_2 = vcreate(GetCPCConfig(), DT_EXTDATA, s_vid_2, sizeof(s_vid_2));
    const vblob * Vendor_IDs[7] = { vid_1, vid_2, 0, 0, 0, 0, 0 };

    // SA    
    const vblob * SA = vcreate(GetCPCConfig(), DT_SA, (char *)d_SA, sizeof(d_SA));
//    const sa_type_t SAtype_PSK = {CPIKE_AUTH_GOST_PSK, CPIKE_ENC_B, CPIKE_HASH_A, CPIKE_GTYPE_VKO_GOST_R_34_10_2001, CPIKE_GROUP_XchB};
//    const sa_type_t SAtype_SIGN = {CPIKE_AUTH_GOST_SIGNATURE, CPIKE_ENC_B, CPIKE_HASH_A, CPIKE_GTYPE_VKO_GOST_R_34_10_2001, CPIKE_GROUP_XchB};
    sa_type_t SAtype_PSK;
    sa_type_t SAtype_SIGN;
    if( !strcmp( globalParamState.g28147oid, szOID_Gost28147_89_CryptoPro_B_ParamSet ) )
    {
	SAtype_PSK.am = CPIKE_AUTH_GOST_PSK;
        SAtype_PSK.enc_mac_id = CPIKE_ENC_B;
        SAtype_PSK.hash_id = CPIKE_HASH_A;
        SAtype_PSK.gtype_id = CPIKE_GTYPE_VKO_GOST_R_34_10_2001;
        SAtype_PSK.group_id = CPIKE_GROUP_XchB;

	SAtype_SIGN.am = CPIKE_AUTH_GOST_SIGNATURE;
	SAtype_SIGN.enc_mac_id = CPIKE_ENC_B;
	SAtype_SIGN.hash_id = CPIKE_HASH_A;
	SAtype_SIGN.gtype_id = CPIKE_GTYPE_VKO_GOST_R_34_10_2001;
	SAtype_SIGN.group_id = CPIKE_GROUP_XchB;
    }
    else if( !strcmp( globalParamState.g28147oid, szOID_Gost28147_89_TC26_A_ParamSet ) )
    {
	SAtype_PSK.am = CPIKE_AUTH_GOST_PSK;
	SAtype_PSK.enc_mac_id = CPIKE_ENC_TC26Z;
	SAtype_PSK.hash_id = CPIKE_HASH_A;
	SAtype_PSK.gtype_id = CPIKE_GTYPE_VKO_GOST_R_34_10_2001;
	SAtype_PSK.group_id = CPIKE_GROUP_XchB;

	SAtype_SIGN.am = CPIKE_AUTH_GOST_SIGNATURE;
	SAtype_SIGN.enc_mac_id = CPIKE_ENC_TC26Z;
	SAtype_SIGN.hash_id = CPIKE_HASH_A;
	SAtype_SIGN.gtype_id = CPIKE_GTYPE_VKO_GOST_R_34_10_2001;
	SAtype_SIGN.group_id = CPIKE_GROUP_XchB;
    } else {
	printf("SAtype_* not inited. Cant continue\n");
	exit(1);
    }
    // CKY    
    const char d_CKYi[8] = {5,3,9,3,0,3,6,4};
    const char d_CKYr[8] = {6,7,1,4,3,1,1,4};
    const vblob * CKYi = vcreate(GetCPCConfig(), DT_CKY, (char *)d_CKYi, sizeof(d_CKYi)); //     DoS
    const vblob * CKYr = vcreate(GetCPCConfig(), DT_CKY, (char *)d_CKYr, sizeof(d_CKYi));

    // ID    
    vblob * IDi_b = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)IDii, sizeof(IDii));
    vblob * IDr_b = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)IDir, sizeof(IDir));

    // Site_NetID    
    const vblob * Site_NetID = vcreate(GetCPCConfig(), DT_NETID, (char *)NetID, sizeof(NetID));

    // PSK     
    const vblob * PSK = vcreate(GetCPCConfig(), DT_PSK, (char *)d_PSKir, sizeof(d_PSKir));

    // SitePSK  SiteID    
    const vblob * Site_IDi = vcreate(GetCPCConfig(), DT_SITEID, (char *)fp1, sizeof(fp1));
    const vblob * Site_IDr = vcreate(GetCPCConfig(), DT_SITEID, (char *)fp2, sizeof(fp2));
    const vblob * PSKi = vcreate(GetCPCConfig(), DT_PSK, (char *)PSK1, sizeof(PSK1));
    const vblob * PSKr = vcreate(GetCPCConfig(), DT_PSK, (char *)PSK2, sizeof(PSK2));

	//      ( 
        // example_certificate_usage())
	//  Windows  IE:
	//  1. : <http://www.cryptopro.ru/certsrv/>;
	//  2.   "    
	//     "  "User specified key container name"  
        //       "IPsecA";
        //  3.  ,    
        //      "1";
        //   Unix:
        //   1. cryptcp ... TODO:  ...
	//   3.   /opt/cprocsp/bin/ia32/certmgr -list
        //   4.   /opt/cprocsp/bin/ia32/certmgr -delete -dn CN=IPsecB
	//   5.    /opt/cprocsp/bin/ia32/certmgr -delete -cont IPsecB
	//   6.   /opt/cprocsp/bin/ia32/csptest -enum -type PP_ENUMCONTAINERS -info

    //   
    //  / ike_gost_handle
    {
	printf("Test IKE init/shutdown...");
	ike_gost_handle plg = init_ike_module(0);
	CERR(plg == 0);
	cpike_shutdown_gost(plg, 0);
	free(plg);
	printf("...done\n");
    }

    ike_gost_handle plg;
    plg = init_ike_module(0);

    //     PSK
    //   Site PSK  PSK 
    {
	// getPSKnotAfterFn()     ,
	//       ike_gost_handle

	time_t tNotAfter;
	CERR(plg->getPSKnotAfterFn(plg, PSKi, Site_NetID, Site_IDi, 0, &tNotAfter));
	printf("Initiator Site PSK will live %d months\n", 
	       (int)((tNotAfter - time(NULL))/30/24/60/60));
	if((tNotAfter  - time(NULL))/30/24/60/60 == 0) {
	    printf("\tcannot continue\n");
	    return 1;
	}
	CERR(plg->getPSKnotAfterFn(plg, PSKr, Site_NetID, Site_IDr, 0, &tNotAfter));
	printf("Responder Site PSK will live %d months\n", 
	       (int)((tNotAfter - time(NULL))/30/24/60/60));
	if((tNotAfter  - time(NULL))/30/24/60/60 == 0) {
	    printf("\tcannot continue\n");
	    return 1;
	}
	//  PSK    
	CERR(plg->getPSKnotAfterFn(plg, PSK, Site_NetID, Site_IDi, 0, &tNotAfter));
	printf("IKE PSK will live %d months (initiator check)\n", 
	       (int)((tNotAfter - time(NULL))/30/24/60/60));
	if((tNotAfter  - time(NULL))/30/24/60/60 == 0) {
	    printf("\tcannot continue\n");
	    return 1;
	}
	CERR(plg->getPSKnotAfterFn(plg, PSK, Site_NetID, Site_IDr, 0, &tNotAfter));
	printf("IKE PSK will live %d months (responder check)\n", 
	       (int)((tNotAfter - time(NULL))/30/24/60/60));
	if((tNotAfter  - time(NULL))/30/24/60/60 == 0) {
	    printf("\tcannot continue\n");
	    return 1;
	}
    }
#ifndef IKE_DRV
    //  /  SADB  PSK
    {
	PRIVKEY hPriv;
	PUBKEY_2012 hPub;
	BYTE *pcsadbSA;
	unsigned pusadbSALen;
	HCRYPTPROV hProv;

	printf("Test Set/Clear SADB PSK Keys...");
	CERR( CapiAcquireContext( hModuleIke, &hProv, 0, 0, PROV_GOST_2001_DH, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001 ) );

	// HCRYPTMODULE  user-space   -->   "0"  
	CERR(plg->sadb.CreatePSKFn( hModuleIke, hProv, PSKi, Site_NetID, Site_IDi, 0, &hPriv, 0, &pusadbSALen, GetCPCConfig()) != CAPI_NOERROR);
	pcsadbSA = (BYTE*) malloc(pusadbSALen);
	CERR(plg->sadb.CreatePSKFn( hModuleIke, hProv, PSKi, Site_NetID, Site_IDi, 0, &hPriv, pcsadbSA, &pusadbSALen, GetCPCConfig()) != CAPI_NOERROR);
	CERR(plg->sadb.deSerializePubKeyFn( hModuleIke, hProv, pcsadbSA, pusadbSALen, 0, &hPub, GetCPCConfig()) != CAPI_NOERROR);
	free(pcsadbSA);
	CERR(plg->sadb.DestroyPubKeyFn( 0, &hPub) != CAPI_NOERROR); //    IKE  ESP --> ,   
	CERR(plg->sadb.DestroyPrivKeyFn( 0, &hPriv) != CAPI_NOERROR); //    IKE  ESP --> ,   

	CERR( CapiReleaseContext( hModuleIke, hProv, 0 ) );
	printf("...done\n");
    }
#endif    
    {
	vblob * Vendor_IDs_from_IKE[5] = { 0, 0, 0, 0, 0 };
	unsigned vendor_count;
	CERR(plg->p1_GetVendorIDsFn( plg, 0, 0, &vendor_count ));
	vendor_count = sizeof( Vendor_IDs_from_IKE )/sizeof(Vendor_IDs_from_IKE[0]);
	CERR(plg->p1_GetVendorIDsFn( plg, 0, &Vendor_IDs_from_IKE[0], &vendor_count ));
	Vendor_IDs[2] = Vendor_IDs_from_IKE[0];
	Vendor_IDs[3] = Vendor_IDs_from_IKE[1];
	Vendor_IDs[4] = Vendor_IDs_from_IKE[2];
	Vendor_IDs[5] = Vendor_IDs_from_IKE[3];
	Vendor_IDs[6] = Vendor_IDs_from_IKE[4];
    }
    cpike_shutdown_gost(plg, 0);
    free(plg);

    //     CTOR
    //       CTOR.     5 
    p1_ir_state *i, *r;
    i = new p1_ir_state(Vendor_IDs,
			SA, SAtype_PSK,
			CKYi,
			IDi_b,
			Site_NetID, Site_IDi, PSK, PSKi,
			(BYTE*)"",         // <http://tyan:8080/browse/CSPNEW-751> i->pbPIN    = (const BYTE *)"1";
			(char *)CONT_IPSEC_A,   // 
			(CHAR *)DEFAULT_PROV_NAME_A, 	           //  CSP,    
			PROV_GOST_2001_DH, //      34.10-2001 ( )
			CRYPT_SILENT); // 
    i->plg = init_ike_module(0);
    if(!i->plg) {
	line = __LINE__ - 2;
	rc = GetLastError();
	goto err;
    }

    r = new p1_ir_state(Vendor_IDs,
			SA, SAtype_PSK,
			CKYr,
			IDr_b,
			Site_NetID, Site_IDr, PSK, PSKr,
			(BYTE*)"", (char *)CONT_IPSEC_B, (CHAR *)DEFAULT_PROV_NAME_A, PROV_GOST_2001_DH, CRYPT_SILENT);
    r->plg = init_ike_module(0);
    if(!r->plg) {
	line = __LINE__ - 2;
	rc = GetLastError();
	goto err;
    }

    i->plg->SetLogLvlUfn(i->plg->pUfnArg, EXAMPLE_LOG_LEVEL, 0);
    r->plg->SetLogLvlUfn(r->plg->pUfnArg, EXAMPLE_LOG_LEVEL, 0);

    {
	printf("Test Phase 1 PSK Main...\n");

	CERR(ph1_PSK_Main(i, r, 0));
	if( !check_p1_serdeser(i, r) ) return 1;
	i->plg->p1_DestroyFn(i->p1, 0);
	r->plg->p1_DestroyFn(r->p1, 0);

	printf("...done\n");
    }
    
    {
        // http://tyan:8080/browse/IPSEC-219
	printf("IPSEC-219: again Test Phase 1 PSK Main...\n");

	CERR(ph1_PSK_Main(i, r, P1_SETPSK_HCRYPT));
	if( !check_p1_serdeser(i, r) ) return 1;
	//i->plg->p1_DestroyFn(i->p1, 0);
	//r->plg->p1_DestroyFn(r->p1, 0);

	printf("...done\n");
    }
    {
	printf("Test Phase 1 PSK Aggressive...\n");

	CERR(ph1_PSK_Aggressive(i, r));
	if( !check_p1_serdeser(i, r) ) return 1;
	i->plg->p1_DestroyFn(i->p1, 0);
	r->plg->p1_DestroyFn(r->p1, 0);

	printf("...done\n");
    }

    //    i/r   
    cpike_shutdown_gost(i->plg, 0);
    free(i->plg);
    cpike_shutdown_gost(r->plg, 0);
    free(r->plg);
    delete i;
    delete r;

    i = new p1_ir_state(Vendor_IDs,
			SA, SAtype_SIGN,
			CKYi,
			IDi_b,
			Site_NetID, Site_IDi, PSK, PSKi,
			(BYTE*)"",    // <http://tyan:8080/browse/CSPNEW-751> i->pbPIN    = (const BYTE *)"1";
			(char *)CONT_IPSEC_A,	// 
			(CHAR *)DEFAULT_PROV_NAME_A, 	//  CSP,    
			PROV_GOST_2001_DH, //      34.10-2001 ( )
			CRYPT_SILENT); // 
    i->plg = init_ike_module(0);
    if(!i->plg) {
	line = __LINE__ - 2;
	rc = GetLastError();
	goto err;
    }
    //    A, /  SADB  () 
    //    vblob  "A"
    {
	printf("Test Set/Clear Site Cert Keys, get certificate A...");
	if( !check_get_cert(i, &i->CERT_b, &i->BLOB_b) )
	    return 1;
	printf("...done\n");
    }

    r = new p1_ir_state(Vendor_IDs,
			SA, SAtype_SIGN,
			CKYr,
			IDr_b,
			Site_NetID, Site_IDr, PSK, PSKr,
			(BYTE*)"", (char *)CONT_IPSEC_B, (CHAR *)DEFAULT_PROV_NAME_A, PROV_GOST_2001_DH, CRYPT_SILENT);
    r->plg = init_ike_module(0);
    if(!r->plg) {
	line = __LINE__ - 2;
	rc = GetLastError();
	goto err;
    }
    //    B, /  SADB  () 
    //    vblob  "B"
    {
	printf("Test Set/Clear Site Cert Keys, get certificate B...");
	if( !check_get_cert(r, &r->CERT_b, &r->BLOB_b) )
	    return 1;
	printf("...done\n");
    }

    {
	printf("Test Phase 1 SIGNATURE Main...\n");

	CERR(ph1_SIGNATURE_Main(i, r, false));
	if( !check_p1_serdeser(i, r) ) return 1;

	printf("...done\n");
    }

    {
	printf("Test Phase 1 SIGNATURE Aggressive...\n");

	CERR(ph1_SIGNATURE_Aggressive(i, r));
	if( !check_p1_serdeser(i, r) ) return 1;

	printf("...done\n");
    }

    {
	printf("Test Phase 1 CFGMODE Main...\n");

	CERR(ph1_SIGNATURE_Main(i, r, true));
	if( !check_p1_serdeser(i, r) ) return 1;

	printf("...done\n");
    }

    p2_ir_state *i2;
    p2_ir_state *r2;

    i2 = new p2_ir_state();
    r2 = new p2_ir_state();

    i2->parent = i;
    i2->plg = i->plg;
    i2->p1 = i->p1;
    i2->CKY = i->CKY;

    r2->parent = r;
    r2->plg = r->plg;
    r2->p1 = r->p1;
    r2->CKY = r->CKY;

    printf("Test Phase 2 CFGMODE...\n");
    CERR(phase_2_inf(r2, i2, false, true));
    printf("Test Phase 2 CFGMODE...done\n");

    printf("Test Phase 2...\n");
    CERR(phase_2_qm(i2, r2, true, true));
    printf("Test Phase 2...done\n");

    printf("Test Phase 2 informational...\n");
    CERR(phase_2_inf(i2, r2, false, false));
    CERR(phase_2_inf(i2, r2, true, false));
    printf("Test Phase 2 informational...done\n");

    /*printf("Test AH CPAH_GOST_HMAC_4M...\n");
    CERR(ike_esp(i2, r2, CPIPSEC_PROTO_IPSEC_AH, CPESP_NULL, CPAH_GOST_HMAC_4M));
    printf("Test AH CPAH_GOST_HMAC_4M...done\n\n");
    printf("Test AH CPAH_GOST_HMAC_1K...\n");
    CERR(ike_esp(i2, r2, CPIPSEC_PROTO_IPSEC_AH, CPESP_NULL, CPAH_GOST_HMAC_1K));
    printf("Test AH CPAH_GOST_HMAC_1K...done\n\n");*/

    /*XXTODO: if(CPGetProvParam(hProv, PP_SECURITY_LEVEL)>= KB1) - ike_esp()   */

    /*XXTODO: if(CPGetProvParam(PP_SECURITY_LEVEL)>= KB1) - ike_esp()   */
#if 1 // IPSEC-737
    printf("Test CPAH_GOST_HMAC_4M...\n");
    CERR(/*(CPGetProvParam(PP_SECURITY_LEVEL)>= KB1) ^ */ike_esp(i2, r2, CPIPSEC_PROTO_IPSEC_ESP, CPESP_NULL, CPAH_GOST_HMAC_4M));
    printf("Test CPAH_GOST_HMAC_4M...done\n\n");
    printf("Test CPAH_GOST_HMAC_1K...\n");
    CERR(ike_esp(i2, r2, CPIPSEC_PROTO_IPSEC_ESP, CPESP_NULL, CPAH_GOST_HMAC_1K));
    printf("Test CPAH_GOST_HMAC_1K...done\n\n");
#endif
    
    /*XXTODO: if(CPGetProvParam(PP_SECURITY_LEVEL)>= KB1) - ike_esp()   */
    printf("Test CPESP_GOST_4M_IMIT...\n");
    CERR(ike_esp(i2, r2, CPIPSEC_PROTO_IPSEC_ESP, CPESP_GOST_4M_IMIT, CPESP_MAC_NULL));
    printf("Test CPESP_GOST_4M_IMIT...done\n\n");

    printf("Test CPESP_GOST_1K_IMIT...\n");
    CERR(ike_esp(i2, r2, CPIPSEC_PROTO_IPSEC_ESP, CPESP_GOST_1K_IMIT, CPESP_MAC_NULL));
    printf("Test CPESP_GOST_1K_IMIT...done\n\n");


    // additional checks
    // remove p1 and then p2: IPSEC-150
    i2->plg->p1_DestroyFn(i2->p1, 0);
    i2->plg->p2_DestroyFn(i2->p2, 0);

    // "normal" delete
    r2->plg->p2_DestroyFn(r2->p2, 0);
    r2->plg->p1_DestroyFn(r2->p1, 0);

    cpike_shutdown_gost(i->plg, 0);
    free(i->plg);
    cpike_shutdown_gost(r->plg, 0);
    free(r->plg);

    vdelete(&i->CERT_b);
    i->CERT_b = 0;
    vdelete(&r->CERT_b);
    r->CERT_b = 0;

    delete i2;
    delete r2;
    delete i;
    delete r;

    vdelete( (vblob **)&vid_1 );
    vdelete( (vblob **)&vid_2 );
    vdelete( (vblob **)&SA );
    vdelete( (vblob **)&CKYi );
    vdelete( (vblob **)&CKYr );

    vdelete( (vblob **)&IDi_b );
    vdelete( (vblob **)&IDr_b );
    vdelete( (vblob **)&Site_NetID );
    vdelete( (vblob **)&PSK );
    vdelete( (vblob **)&Site_IDi );
    vdelete( (vblob **)&Site_IDr );
    vdelete( (vblob **)&PSKi );
    vdelete( (vblob **)&PSKr );

    printf( "\nexample pass OK\n");

#if defined UNIX
    // destroy CryptoServiceProvider for valgrind' checks
    HCRYPTPROV uProv;
    if( CapiAcquireContext( hModuleIke, &uProv, (char *)_TEXT("$reboot$"), NULL, PROV_GOST_2001_DH, CRYPT_REBOOT|CRYPT_DELETEKEYSET, (VTABLEPROVSTRUC*)&VTABLE2001 ) ) {
	DWORD dwErr = GetLastError();
	printf("\"$reboot$\", CRYPT_REBOOT fail [Err: 0x%08x]\n", dwErr);
	if(!dwErr) {
	    line = __LINE__-4;
	    goto err;
	}
    }
#endif	// UNIX

    return 0;

err:
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    return rc;
}

capi_result
correct_p1_LifeDur(ike_gost_handle plg, P1_HANDLE p1, time_t tNotAfter)
{
    capi_result rc;
    int line;
    uint32_t uP1Expiry;
    unsigned uP1ExpiryLen = sizeof(uP1Expiry);

    CERR(plg->p1_GetParamFn(p1, CPIKE_AC_Life_Duration, CPIKE_LIFET_SECONDS, 0, 
			    &uP1Expiry, &uP1ExpiryLen));
    CERRASSERT(uP1Expiry && uP1Expiry < 10*365*24*60*60, CAPI_PROTOCOL_ERROR);
    tNotAfter -= time(NULL);
    CERRASSERT(0 < tNotAfter && tNotAfter < 10*365*24*60*60, CAPI_PROTOCOL_ERROR);
    if(uP1Expiry > (uintptr_t)tNotAfter) {
	uP1Expiry = (uint32_t)tNotAfter;
	CERR(plg->p1_SetParamFn(p1, CPIKE_AC_Life_Duration, 
				uP1Expiry, 
				CPIKE_LIFET_SECONDS, 0));
    }
    return CAPI_NOERROR;

err:
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    return rc;
}

capi_result
send2buf(const vblob *v, char *pcData, unsigned *uDataLen, unsigned uBufLen)
{
    unsigned vlen = vsize( (vblob *)v );
    unsigned outlen = *uDataLen + sizeof(vlen) + vlen;
    unsigned addlen = (4-outlen%4) % 4;
    outlen += addlen;

    if (outlen > uBufLen) {
	return CAPI_BAD_LEN;
    }
    memcpy(pcData + *uDataLen, &vlen, sizeof(vlen));
    (*uDataLen) += sizeof(vlen);
    memcpy(pcData + *uDataLen, vref( (vblob *)v ), vlen);
    (*uDataLen) += vlen;
    
    //   4. zero-padding
    if(addlen) {
	memset(pcData + *uDataLen, 0, addlen);
        (*uDataLen) += addlen;
    }
    return CAPI_NOERROR;
}

capi_result
recv4buf(vblob **v, DATA_TYPE dp, const char *pcData, unsigned *uDataLen, unsigned uBufLen)
{
    unsigned vlen;

    if (*uDataLen + sizeof(vlen) > uBufLen) {
	return CAPI_BAD_LEN;
    }
    memcpy(&vlen, pcData + *uDataLen, sizeof(vlen));
    (*uDataLen) += sizeof(vlen);
    if (*uDataLen + vlen > uBufLen) {
	return CAPI_BAD_LEN;
    }
    *v = vcreate(GetCPCConfig(), dp, (char*)pcData + *uDataLen, vlen);
    *uDataLen += vlen;

    unsigned addlen = (4-vlen%4) % 4;
    *uDataLen += addlen;

    return CAPI_NOERROR;
}

static bool
check_get_cert(p1_ir_state* h, vblob **CERT, vblob **BLOB)
{
    unsigned rc;
    int line;
    PRIVKEY hPriv;
    PUBKEY_2012 hPub;
    HCRYPTPROV hCertProv;
    time_t tNotAfter;
    HCRYPTMODULE hModuleTemp;

    hModuleTemp = GetNewModule_Crypt();

    if( CapiAcquireContext( hModuleTemp, &hCertProv, (CHAR *)h->pszCont, h->pszProv, h->dwPT, h->dwPFW, (VTABLEPROVSTRUC*)&VTABLE2001 ) ) {
	line = __LINE__-1;
	rc = GetLastError();
	example_certificate_usage();
	printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
	return false;
    }
    CERR( CapiSetProvParam( hModuleTemp, hCertProv, PP_KEYEXCHANGE_PIN, (BYTE *)h->pbPIN, 0 ) );

    HCRYPTKEY hKU;
    CERR( CapiGetUserKey( hModuleTemp, hCertProv, AT_KEYEXCHANGE, &hKU ) );

    DWORD dwCertLen;
    dwCertLen = 0;
    CERR( CapiGetKeyParam( hModuleTemp, hCertProv, hKU, KP_CERTIFICATE, 0, &dwCertLen, 0 ) );
    BYTE *pc;
    pc = (BYTE*) malloc(dwCertLen);
    CERR( CapiGetKeyParam( hModuleTemp, hCertProv, hKU, KP_CERTIFICATE, pc, &dwCertLen, 0 ) );
    DWORD dwBlobLen;
    dwBlobLen = 0;
    CERR( CapiExportKey( hModuleTemp, hCertProv, hKU, 0, PUBLICKEYBLOB, 0, 0, &dwBlobLen ) );
    BYTE *pb;
    pb = (BYTE*) malloc(dwCertLen);
    CERR( CapiExportKey( hModuleTemp, hCertProv, hKU, 0, PUBLICKEYBLOB, 0, pb, &dwBlobLen ) );
    CERR( CapiDestroyKey( hModuleTemp, hCertProv, hKU ) );

    PCCERT_CONTEXT pCertCtx;
    pCertCtx = 0;
    CERR(ikeCheckCert(h->plg, pc, dwCertLen, &pCertCtx, &tNotAfter));
    CERR(!::CertFreeCertificateContext(pCertCtx));

    *CERT = vcreate(GetCPCConfig(), DT_EXTDATA, (char*)pc, dwCertLen);
    *BLOB = vcreate(GetCPCConfig(), DT_EXTDATA, (char*)pb, dwBlobLen);
    free(pc);
    free(pb);

    BYTE *pcsadbSA;
    unsigned pusadbSALen;

    CERR(h->plg->sadb.CreateProvFn( hModuleTemp, hCertProv, 0, &hPriv, 0, &pusadbSALen) != CAPI_NOERROR);
    pcsadbSA = (BYTE*) malloc(pusadbSALen);
    CERR(h->plg->sadb.CreateProvFn( hModuleTemp, hCertProv, 0, &hPriv, pcsadbSA, &pusadbSALen) != CAPI_NOERROR);
    CERR(h->plg->sadb.deSerializePubKeyFn( hModuleTemp, hCertProv, pcsadbSA, pusadbSALen, 0, &hPub, GetCPCConfig()) != CAPI_NOERROR);
    free(pcsadbSA);
    CERR(h->plg->sadb.DestroyPubKeyFn( 0, &hPub) != CAPI_NOERROR);
    CERR(h->plg->sadb.DestroyPrivKeyFn( 0, &hPriv) != CAPI_NOERROR);
    CERR( CapiReleaseContext( hModuleTemp, hCertProv, 0 ) );
    ReleaseModule_Crypt( hModuleTemp );

    return true;

  err:
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    return false;
}

static bool
check_p1_serdeser(p1_ir_state* i, p1_ir_state* r)
{
    unsigned rc;
    int line;
    PRIVKEY hPrivI, hPrivR;
    PUBKEY_2012 hPubI, hPubR;
    BYTE *pcsadbSA;
    unsigned pusadbSALen;
    HCRYPTPROV hProvI, hProvR;

    // HCRYPTMODULE  user-space   -->   "0"  
    CERR( CapiAcquireContext( hModuleIke, &hProvI, 0, 0, PROV_GOST_2001_DH, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001 ) );
    CERR(i->plg->sadb.CreatePSKFn(hModuleIke, hProvI, i->Site_PSK, i->NetID, i->Site_ID, 0, &hPrivI, 0, &pusadbSALen, GetCPCConfig()) != CAPI_NOERROR);
    pcsadbSA = (BYTE*) malloc(pusadbSALen);
    CERR(i->plg->sadb.CreatePSKFn(hModuleIke, hProvI, i->Site_PSK, i->NetID, i->Site_ID, 0, &hPrivI, pcsadbSA, &pusadbSALen, GetCPCConfig()) != CAPI_NOERROR);
    CERR(i->plg->sadb.deSerializePubKeyFn(hModuleIke, hProvI, pcsadbSA, pusadbSALen, 0, &hPubI, GetCPCConfig()) != CAPI_NOERROR);
    free(pcsadbSA);

    CERR( CapiAcquireContext( hModuleIke, &hProvR, 0, 0, PROV_GOST_2001_DH, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001 ) );
    CERR(r->plg->sadb.CreatePSKFn( hModuleIke, hProvR, r->Site_PSK, r->NetID, r->Site_ID, 0, &hPrivR, 0, &pusadbSALen, GetCPCConfig()) != CAPI_NOERROR);
    pcsadbSA = (BYTE*) malloc(pusadbSALen);
    // http://tyan:8080/browse/IPSEC-408
    {
	BYTE secret[] = "secretstring_for_testing_purposes";
	DWORD len = sizeof(secret);
	HCRYPTPROV hProvExternal = 0;
	HCRYPTHASH hHashTemp = 0;
	HCRYPTPROV hKeyExternal = 0;
	CERR( CapiAcquireContext( hModuleIke, &hProvExternal, 0, 0, PROV_GOST_2001_DH, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001 ) );
	CERR( CapiCreateHash( hModuleIke, hProvExternal, CALG_GR3411, 0, 0, &hHashTemp ) );
	CERR( CapiHashData( hModuleIke, hProvExternal, hHashTemp, secret, len, 0));
	CERR( CapiDeriveKey( hModuleIke, hProvExternal, CALG_G28147, hHashTemp, CRYPT_EXPORTABLE, &hKeyExternal));
	CapiDestroyHash( hModuleIke, hProvExternal, hHashTemp );
	CERR(r->plg->sadb.CreatePSKFn( hModuleIke, hProvR, (vblob *)hKeyExternal, (vblob *)hProvExternal, (vblob *)hModuleIke, P1_SETPSK_HCRYPT, &hPrivR, pcsadbSA, &pusadbSALen, GetCPCConfig()) != CAPI_NOERROR );
	CapiDestroyKey( hModuleIke, hProvExternal, hKeyExternal );
	CapiReleaseContext( hModuleIke, hProvExternal, 0 );
    }
    CERR(r->plg->sadb.deSerializePubKeyFn( hModuleIke, hProvR, pcsadbSA, pusadbSALen, 0, &hPubR, GetCPCConfig()) != CAPI_NOERROR);
    free(pcsadbSA);
    pcsadbSA = 0;

    // --------------Initiator: serialize/deserialize not checked/ P2 will be created from "alive" P1
    CERR(i->plg->p1_SerializeFn(i->p1, &hPrivI, &hPubI, 0, &i->p1_data));
    i->plg->p1_DestroyFn(i->p1, 0);
    CERR(i->plg->p1_deSerializeFn(i->plg, &hPrivI, &hPubI, i->p1_data, 0, &i->p1));
    vdelete(&i->p1_data);
    i->p1_data = 0;

    // --------------Responder: P2 will be created from "cached" P1
    // p1 -> cache 
    CERR(r->plg->p1_SerializeFn(r->p1, &hPrivR, &hPubR, 0, &r->p1_data));
    r->plg->p1_DestroyFn(r->p1, 0);
    // cache -> p1_from_cache
    CERR(r->plg->p1_deSerializeFn(r->plg, &hPrivR, &hPubR, r->p1_data, 0, &r->p1));

    // p1_reSerialize test (1) error = ok (2) reser (3) no error
    P1_HANDLE p1;
    rc = i->plg->p1_deSerializeFn(i->plg, &hPrivI, &hPubI, r->p1_data, 0, &p1);
    if( !rc )
    {
	line = __LINE__ - 3;
	goto err;
    }

    CERR(r->plg->p1_reSerializeFn(r->plg, &hPrivR, &hPrivI, &hPubR, &hPubI, r->p1_data, 0, &i->p1_data));
    vdelete(&r->p1_data);
    r->p1_data = 0;

    
    CERR(i->plg->p1_deSerializeFn(i->plg, &hPrivI, &hPubI, i->p1_data, 0, &p1));
    i->plg->p1_DestroyFn(p1, 0);

    // p1_data  hPrivI->hPrivR
    CERR(r->plg->p1_reSerializeFn(r->plg, &hPrivI, &hPrivR, &hPubI, &hPubR, i->p1_data, 0, &r->p1_data));
    vdelete(&i->p1_data);
    i->p1_data = 0;
    vdelete(&r->p1_data);
    r->p1_data = 0;

    CERR(i->plg->sadb.DestroyPubKeyFn(0, &hPubI));
    CERR(i->plg->sadb.DestroyPrivKeyFn(0, &hPrivI));
    CERR( CapiReleaseContext( hModuleIke, hProvI, 0 ) );

    CERR(r->plg->sadb.DestroyPubKeyFn(0, &hPubR));
    CERR(r->plg->sadb.DestroyPrivKeyFn(0, &hPrivR));
    CERR( CapiReleaseContext( hModuleIke, hProvR, 0 ) );

    return true;

  err:
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    return false;
}
