#!/bin/sh
# vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[]
#
# Copyright(C) 2005-2013  
#
#    , 
#    .
#
#        ,
# ,    ,
#     ,
# ,      
#     
#      .
#
#  ,    , 
#         
#   .
#
#  -   
#     .
#

f=${1:-.}
t=/lib/modules/2.4.21-21cp/kernel/crypto

ldconfig
/opt/cprocsp/sbin/ia32/cpconfig -hardware media -del FAT12

sync
sleep 1
sync
sleep 1

cp $f/drtcsp.o $t/.

/sbin/modprobe drvcsp
/sbin/modprobe drtcsp
major=`grep drtcsp /proc/devices |cut -d' ' -f1`
i=0;
while test $i -lt 40
do
    rm -f /dev/drtcsp$i
    test -n "$major" && mknod /dev/drtcsp$i c $major $i
    i=`expr $i + 1`
done

$f/dmntcs -create 
time $f/dmntcs -test -numblock 10000  -device /dev/drtcsp0 || {
    printf "Fail: $? $f/dmntcs\\n"
    exit 1
}
$f/dmntcs -delete 

/sbin/rmmod drtcsp
i=0
while test $i -lt 40
do
    rm -f /dev/drtcsp$i;
    i=`expr $i + 1`
done

/opt/cprocsp/src/ipsec/UserSpace/example || {
    printf "Fail: $? /opt/cprocsp/src/ipsec/UserSpace/example\\n"
    exit 2
}

sync
sleep 1
sync
sleep 1

cp testesp.o $t

/sbin/modprobe esp_gost
/sbin/modprobe testesp
major=`grep tstesp /proc/devices |cut -d' ' -f1`
mknod /dev/tstesp c $major 0

/opt/cprocsp/src/ipsec/UserSpace/example_io_krn || {
    printf "Fail: $? /opt/cprocsp/src/ipsec/UserSpace/example_io_krn\\n"
    exit 3
}

rm -f /dev/tstesp
/sbin/rmmod testesp
/sbin/rmmod esp_gost
/sbin/rmmod drvcsp
