/*
 * Copyright(C) 2007-2009
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 *
 * This is proprietary information of
 * Crypto-Pro company.
 *
 * Any part of this file can not be copied, 
 * corrected, translated into other languages,
 * localized or modified by any means,
 * compiled, transferred over a network from or to
 * any computer system without preliminary
 * agreement with Crypto-Pro company
 */

/*
 * \version $Revision: 191922 $
 * \date $Date:: 2019-04-11 12:01:31 +0300#$
 * \author $Author: dim $
 *
 */

#ifndef _TYPEDEFS_H_
#define _TYPEDEFS_H_

#if !defined(__KERNEL__) && !defined(_KERNEL)
    #if !defined CSP_LITE
	#if defined UNIX
	    #include <strings.h>
	#else
	    #include <string.h>
	#endif
    #endif
    #include <time.h>
#endif

#if defined _WIN32
typedef unsigned char  uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int   uint32_t;
#elif defined(__KERNEL__) || defined(_KERNEL)
//#   include <stddef.h>
#else
#   include <stdint.h>
#endif /* _WIN32*/

#include "cp-ike-gost.h"
#include "cp-ipsec-gost.h"

/*
 *   
 */
#if defined(_WIN32)
#   if !defined(CAPI_CHECK_CALL)
#	define CAPI_INTC	__fastcall
#	define CAPI_EXTC	__cdecl
#   else
#	define CAPI_INTC	__stdcall
#	define CAPI_EXTC	__fastcall
#   endif
#else
#   define CAPI_INTC
#   if defined(__GNUC__) && !defined(IOS) && (!defined (PROCESSOR_TYPE) || (PROCESSOR_TYPE == PROC_TYPE_I386))
#       define CAPI_EXTC __attribute__((regparm(0)))
#   else
#       define CAPI_EXTC 
#   endif
#endif

/*
 * error codes
 */
typedef enum {
    CAPI_NOERROR = 0,		/* no error */
    CAPI_NOT_ENOUGH_SPACE = 1,	/* The size of the output buffer is too small to hold the generated ciphertext */
    CAPI_CALL_ERROR = 2,        /* invalid args without length errors */
    CAPI_PROTOCOL_ERROR = 3,	/* invalid calls sequence */
    CAPI_INTERNAL_ERROR = 4,	/* plugin UNKNOWN internal error */
    CAPI_PSK_ERROR = 5,		/* PSK import error */
    CAPI_PSK_TTL_EXPIRED_ERROR=6,
    CAPI_ARGLEN_ERROR = 7,	/* invalid argument length */
    CAPI_NOFREE_SID_ERROR = 8,	/* sid-table overflow */
    CAPI_UNSUPPORTED_ERROR = 9, /* unsupported feature */
    CAPI_IMITA_ERROR = 10,	/* ESP, IKE, PSK imita error */
    CAPI_MSG_FORMAT_ERROR = 11,	/* misc packet format's errors */
    CAPI_CHAIN_ERROR = 12,      /* certificate chain check error */
    CAPI_HASH_A_ERROR = 13,	/* error while check HASH_A */
    CAPI_BAD_LEN = 14,		/* The size of the output buffer is too small to hold the generated ciphertext */
    CAPI_SN_ERROR = 15,		/* 'replay prevention' discard packet */

    CAPI_MAC_ERROR = 17,	/* MAC error */
    CAPI_CSP_ERROR = 18,	/* error in CSP call */
    CAPI_PHASE2_CREATE_LIMIT_ERROR = 29, /* too much P2 from one P1-session */
    CAPI_SPI_CREATE_LIMIT_ERROR  = 20,   /* too much SPI from one P2-session */
    CAPI_TTL_SECS_EXPIRED_ERROR  = 21,	 /* too old session */
    CAPI_TTL_BYTES_EXPIRED_ERROR = 22,   /* too more data for session (cryptographic keys) */
    CAPI_MAX_AUTH_ERROR = 23,		 /* #imita' errors exceeded */
    CAPI_TOO_MANY_THREADS = 24,		 /* too many threads */
    CAPI_MULTI_RESULT = 25		 /* MULTIPACKET one or more errors */
} capi_result;

/*
 * logger's severity levels libesp_gost  libike_gost
*/
typedef enum log_severity {  /* when to use, destination */
    CAPI_EMERG,	      /* system is unusable, ram&disk */
    CAPI_ALERT,       /* action must be taken immediately, ram&disk */
    CAPI_CRIT,	      /* critical conditions, ram&disk */
    CAPI_ERR,         /* error conditions, ram&disk */
    CAPI_WARNING,     /* warning conditions, ram&disk */
    CAPI_NOTICE,      /* normal but significant conditions, ram */
    CAPI_INFO,        /* informational messages, ram */
    CAPI_DEBUG        /* debug-level messages */
} log_severity_t;

/* inbound ? outbound SPI */
typedef enum CPESP_DIRECTION {
    CPESP_INBOUND = 1,
    CPESP_OUTBOUND = 2
} CPESP_DIRECTION_T;

/* length of P1 data */
static const unsigned P1_SER_LEN = 422;
/* length of SPI data */
static const unsigned SPI_SER_LEN = 153;

#if !defined UNUSED
#   define UNUSED(x) ((void)x)
#endif /* !UNUSED */

#ifndef CP_MS_SECURE_CRT_
#define CP_MS_SECURE_CRT_
/* XXX dim:   "Code Review"    */
    #ifdef UNIX
	// MS VS form of ISO/IEC TR 24731-1
	// <http://www.open-std.org/JTC1/SC22/WG14/www/projects#24731-1>
	// See \\cp.ru\dfs\home\lse\doc\C\n1225.pdf
	// See \\cp.ru\dfs\home\lse\doc\C\n1173.pdf
	//
	// strnlen
	
	// strcpy_s // TODO: check s1 & s2
	    #define strcpy_s(s1, s1max, s2) ( \
			    strncpy((s1), (s2), (s1max)), \
			    (s1)[(s1max)-1]  \
				? ((s1)[(s1max)-1] = '\0' ? -1 : -1) \
				: 0 \
			)
	// sprintf_s // TODO: check s & format
	    #define sprintf_s(s, n, format, ...)  ( \
			   (memset(s,0,n), /* XXX dim: valgrind want to be happy */ \
			    0 > snprintf((s), (n), format, ##__VA_ARGS__) \
			    ? -1 \
			    : ( (s)[(n)-1] \
				? (s)[(n)-1] = '\0' \
				: (int)strnlen((s), (n)) \
			      ) \
			   ) \
			)
	// vsprintf_s // TODO: check s & format
	    #define vsprintf_s(s, n, format, arg)  ( \
			    ( 0 > vsnprintf((s), (n), (format), (arg)) \
			    ? -1 \
			    : ( (s)[(n)-1] \
				? (s)[(n)-1] = '\0' \
				: (int)strnlen((s), (n)) \
			      ) \
			    ) \
			)
	// gmtime_s // TODO check TR & MS Doc & __STDC_LIB_EXT1_ _ The integer constant 200509L
	    #define gmtime_s(tm, time) ( \
			    gmtime_r((time), (tm)) \
			)
	// asctime_s // TODO check s1 & maxsize < 26
	    #define asctime_s(s, maxsize, timerptr) ( \
			    strcpy_s((s), (maxsize), asctime(timerptr)) \
			)
    #endif
#endif /*CP_MS_SECURE_CRT_*/

#if defined _WIN32
#define DEFAULT_PROV_NAME_A CP_GR3410_2001_PROV_A
#define DEFAULT_PROV_NAME_W CP_GR3410_2001_PROV_W
#else
#define DEFAULT_PROV_NAME_A NULL
#define DEFAULT_PROV_NAME_W NULL
#endif

//  ,   ,   ,      
//  "" 

typedef struct 
{
    char* g28147oid;
    uint8_t lic;    // license
    uint8_t gost12;
} GlobalParams;

#endif /* _TYPEDEFS_H_ */
