/*
 * Copyright(C) 2009-2012
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */
/*
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 *
 * \brief
 *
 */
#ifndef _SADB_H_
#define _SADB_H_

#include "typedefs.h"		/* enum capi_result */
#include "typedefs_sadb.h"

/*   SADB */
/*  CSP_LITE     PSK */
#include "vblob.h"		/* class vblob */

typedef capi_result CAPI_EXTC
CreatePSKDecl(
    HCRYPTMODULE m,   
    HCRYPTPROV hProv,
    const vblob * SitePSK,
    const vblob * SiteNetID,
    const vblob * SiteID,
    unsigned uFlags,
    PRIVKEY * hPriv,   /*     */
    unsigned char * pcsadbSA, /*      */
    unsigned * pusadbSALen, /*       */
    CPC_CONFIG * config
);

typedef capi_result CAPI_EXTC
CreateProvDecl(
    HCRYPTMODULE m,   
    HCRYPTPROV hProv,  /* handle   */
    unsigned uFlags,
    PRIVKEY * hPriv,   /*     */
    unsigned char* pcsadbSA, /*      */
    unsigned * pusadbSALen /*       */
);

typedef capi_result CAPI_EXTC
CreateEphemDecl(
    HCRYPTMODULE m,   
    HCRYPTPROV hProv,
    unsigned uFlags,
    PRIVKEY *hPriv,   /*     */
    unsigned char* pcsadbSA, /*      */
    unsigned* pusadbSALen /*       */
);

/*    */
typedef capi_result CAPI_EXTC
deSerializePubKeyDecl(
    HCRYPTMODULE m,
    HCRYPTPROV hProv,
    const unsigned char* pcsadbSA, 
    unsigned pcsadbSALen, 
    unsigned uFlags,
    PUBKEY_2012 *hPub,          /*     */
    CPC_CONFIG * config
);

/*    */
typedef capi_result CAPI_EXTC
DestroyPrivKeyDecl(
    unsigned uFlags,
    PRIVKEY * hPriv  /*     */
);

/*    */
typedef capi_result CAPI_EXTC
DestroyPubKeyDecl(
    unsigned uFlags,
    PUBKEY_2012 * hPub    /*     */
);
#ifdef __cplusplus
extern "C"
{
#endif
extern CreateProvDecl CreateProvFn;
extern CreatePSKDecl CreatePSKFn;
extern CreateEphemDecl CreateEphemFn;
extern deSerializePubKeyDecl deSerializePubKeyFn;
extern DestroyPrivKeyDecl DestroyPrivKeyFn;
extern DestroyPubKeyDecl DestroyPubKeyFn;
#ifdef __cplusplus
}
#endif

/*!
 * \ingroup ikeData
 * \ingroup espData
 * \struct gen_sadb
 * \brief      SADB (  #IKE_GOST  #ESP_GOST). 
 *
 */
typedef struct gen_sadb {
    CreateEphemDecl *CreateEphemFn;
    /*!< \brief  #CreateEphemFn.*/
    deSerializePubKeyDecl *deSerializePubKeyFn;
    /*!< \brief  #deSerializePubKeyFn.*/
    DestroyPrivKeyDecl *DestroyPrivKeyFn;
    /*!< \brief  #DestroyPrivKeyFn.*/
    DestroyPubKeyDecl *DestroyPubKeyFn;
    /*!< \brief  #DestroyPubKeyFn.*/
    CreateProvDecl *CreateProvFn;
    /*!< \brief  #CreateProvFn (   ).*/
    CreatePSKDecl *CreatePSKFn;
    /*!< \brief  #CreatePSKFn (   ).*/
} GEN_SADB;

static const unsigned FLAG_SADB_DUPLICATE_EPHEM  = 0x00000011; // CreateEphemFn can copy PRIVKEY -> new PRIVKEY

#endif /* _SADB_H_ */
