/*
 * Copyright(C) 2005-2009
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 *
 * This is proprietary information of
 * Crypto-Pro company.
 *
 * Any part of this file can not be copied,
 * corrected, translated into other languages,
 * localized or modified by any means,
 * compiled, transferred over a network from or to
 * any computer system without preliminary
 * agreement with Crypto-Pro company
 */

/*!
 * \version $Revision: 142076 $
 * \date $Date:: 2016-07-21 11:56:48 +0300#$
 * \author $Author: pdn $
 *
 * \brief
 *
 */

#ifndef _ESP_GOST_H_
#define _ESP_GOST_H_

#include "esp_gost_types.h"
#include "typedefs.h"
#include "sadb.h"
#include "ipsec_version.h"

/*
 * \ingroup ESPinit
 * \brief     ESP/AH  Linux(SPLAT), Solaris
 * \def CPESP_INIT_GOST_FUNCTION
 *
 * used in Linux-2.4.x for inter_module_register/inter_module_unregister
 * no #ifdef i.e. dont want to use kernel headers here
 * in kernel interface file uses "#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)"
 */
#define CPESP_INIT_GOST_FUNCTION	"cpesp_init_gost"

/*
 * \ingroup ESPinit
 * \brief     ESP/AH  Linux(SPLAT), Solaris
 * \def CPESP_INIT_GOST_FUNCTION
 *
 * used in Linux-2.4.x for inter_module_register/inter_module_unregister
 * no #ifdef i.e. dont want to use kernel headers here
 * in kernel interface file uses "#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)"
 */
#define CPESP_SHUTDOWN_GOST_FUNCTION	"cpesp_shutdown_gost"

/* function prototypes */
typedef capi_result CAPI_EXTC
espEncapDecl(ESP_HANDLE sid,
	     unsigned uFlags,
	     char * pcNextProto,
	     void * pData, unsigned * puDataLen, unsigned uBufLen, CPC_CONFIG * config);

typedef capi_result CAPI_EXTC
espDecapDecl(ESP_HANDLE sid,
	     unsigned uFlags,
	     char * pcNextProto,
	     void * pData, unsigned * puDataLen, CPC_CONFIG * config);

typedef capi_result CAPI_EXTC
espGetParamDecl(ESP_HANDLE sid, unsigned uFlags,
                unsigned uParam, void * pData, unsigned * puDataLen);

/* This performs key negotiation between IKE-daemon and kernel module and
 * to receive keys from IKE
 */
/* CreateEphemFn, deSerializePubKeyFn, DestroyPrivKeyFn, DestroyPubKeyFn declared in sadb.h */

/* deserialize IPSEC SA, create new ESP session */
typedef capi_result CAPI_EXTC
spiCreateDecl(
    esp_gost_handle h,
    PRIVKEY *hPriv,       /*  (hPriv, hPub)     user-space */
    PUBKEY_2012 *hPub,
    const unsigned char *pcIPsecSA, /*    IKE */
    unsigned uIPsecSALen, /*     IKE */
    unsigned uFlags,
    ESP_HANDLE *sid,
    CPC_CONFIG *config);

/* destroy session */
typedef capi_result CAPI_EXTC
destroyDecl(unsigned uFlags, ESP_HANDLE sid);

typedef void CAPI_EXTC
EspLogDecl(void *pUfnAgr, 
	   log_severity_t severity, unsigned uFlags, 
	   const char *fmt, ...);

typedef void CAPI_EXTC
EspSetLogLvlDecl(void *pUfnAgr, log_severity_t severity, unsigned uFlags);

/*!
 * \ingroup espData
 * \struct esp_gost
 * \brief    ESP. 
 *
 */
typedef struct esp_gost {
    void *pUfnArg;
    /*!< \brief    .*/
    EspLogDecl *LogUfn;
    /*!< \brief   #LogUfn.*/
    EspSetLogLvlDecl *SetLogLvlUfn;
    /*!< \brief    #SetLogLvlUfn.*/
    destroyDecl  *destroyFn;
    /*!< \brief  #destroyFn.*/
    espEncapDecl *espEncapFn;
    /*!< \brief  #espEncapFn.*/
    espDecapDecl *espDecapFn;
    /*!< \brief  #espDecapFn.*/
    espGetParamDecl *espGetParamFn;
    /*!< \brief  #espGetParamFn.*/
    spiCreateDecl *spiCreateFn;
    /*!< \brief  #spiCreateFn.*/
    GEN_SADB sadb;
    /*!< \brief   #GEN_SADB.*/
    void* reserved[7];
    /*!< \brief ,  ,  .*/
} ESP_GOST;

/*!
 * \ingroup espData
 * \struct esp_gost_in
 * \brief     ESP/AH   #cpesp_init_gost. 
 * 
 */
typedef struct esp_gost_in {
    unsigned         apiVersionMajor;
    /*!< \brief   ,      .*/
    unsigned         apiVersionMinor;
    /*!< \brief   ,      .*/
    unsigned         maxSessions;
    /*!< \brief   ,      .*/
    void             *pUfnArg;
    /*!< \brief    .*/
    EspLogDecl	     *LogUfn;
    /*!< \brief   #LogUfn,   0.*/
    EspSetLogLvlDecl *SetLogLvlUfn;
    /*!< \brief    #SetLogLvlUfn,    #LogUfn.*/
    unsigned         allocatedMem;
    /*!< \brief    esp_gost_handle  (  requiredMem  #esp_gost_out).*/
    const char*	     sczDebugKey;
    /*!< \brief           .
         (     ).*/
    UINT_PTR         maxThreads;
    /*!< \brief      :
     * - 0 -   ;
     * - N -      N 
     * */
    HCRYPTMODULE     hBaseModule;
    /*!< \brief       (  maxThreads > 0).*/
    void*            reserved[5];
    /*!< \brief ,  ,  .*/
} ESP_GOST_IN;

/*!
 * \ingroup espData
 * \struct esp_gost_out
 * \brief      ESP/AH   #cpesp_init_gost.  
 * 
 */
typedef struct esp_gost_out {
    unsigned requiredMem;
    /*!< \brief   esp_gost_handle  .*/
    char     cVID[32];
    /*!< \brief  Vendor ID (  IKE/ESP/AH).*/
    unsigned cVIDLen;
    /*!< \brief  Vendor ID.*/
    UINT_PTR apiVersionMajor;
    /*!< \brief   .*/
    UINT_PTR apiVersionMinor;
    /*!< \brief   .*/
    void*    reserved[6];
    /*!< \brief ,  ,  .*/
} ESP_GOST_OUT;

#define ESP_DATA_IOVEC		0x00020000  /*   IOVEC    encap() decap() */
#define ESP_DATA_MULTIPACKET	0x00200000  /*   MULTIPACKET   encap() decap() */
#define ESP_PADDING_SEQ         0x00000100  /* sequencial padding for ESP */
#define ESP_PADDING_ZERO        0x00000200  /* zero padding for ESP */
#define ESP_PADDING_SIZE	0x00000400  /* exact padding size in mask */
#define ESP_PADDING_MASK        (ESP_PADDING_SEQ|ESP_PADDING_ZERO|ESP_PADDING_SIZE)  /* mask for padding flag */
#define ESP_PADDING_SIZE_MASK	0x000000FF  /* mask for padding exact size */

#define ESP_FLAGS_ENC_UNDEFINED	~(ESP_DATA_IOVEC|ESP_DATA_MULTIPACKET|ESP_PADDING_MASK|ESP_PADDING_SIZE_MASK)
#define ESP_FLAGS_DEC_UNDEFINED	~(ESP_DATA_IOVEC|ESP_DATA_MULTIPACKET|ESP_PADDING_MASK)

#define AH_IPHEADER_SIZE_MASK	0x000000FF  /* mask for ipheader exact size */
#define AH_FLAGS_UNDEFINED	~(ESP_DATA_IOVEC|AH_IPHEADER_SIZE_MASK)

#define WINDOW_BASE		256

#if defined __cplusplus
extern "C" {
#endif
    capi_result CAPI_EXTC cpesp_init_gost(esp_gost_handle h, const struct esp_gost_in*, 
				unsigned uFlags, struct esp_gost_out*);
    void CAPI_EXTC cpesp_shutdown_gost(esp_gost_handle h, unsigned uFlags);
#if defined __cplusplus
}
#endif
#endif /* _ESP_GOST_H_ */
