#!/bin/sh
if test $# -lt 3 
then
    printf "Usage: %s file1 file2 symbol1 symbol2...\n" "$0"
    exit 1
fi
test -f "$1" || exit 1
test -f "$2" || exit 1
f1="$1"
f2="$2"
shift 2
while test $# -gt 0
do
    sym="$1"
    crc1="`grep "$sym" "$f1" | cut -f1|sed 's/0x//g;s/^0*//'`"
    crc2="`grep "$sym" "$f2" | cut -f1|sed 's/0x//g;s/^0*//'`"
    test "$crc1" != "$crc2" && {
        printf "sym: %s, crc1: %s, crc2: %s, fail\n" "$sym" "$crc1" "$crc2" >&2
        exit 2
    }
    shift
done
