/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2008-2013  
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */
/*
 *      Test driver for Crypto-Pro driver.
 *
 *      Copyright (c) 2008 Crypto-Pro Ltd.
 *
 *      Can be freely distributed and used under the terms of the GNU GPL.
 */
/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 *
 * \brief      
 * " CSP"  Solaris
 *
 */
#define _CSPLITECRT_H_INCLUDED 1
#if defined(KERNEL) || defined(MODULE)
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/limits.h>
#include <asm/errno.h>
typedef int wchar_t;
#elif defined(_KERNEL)
#include <sys/file.h>
#include <sys/errno.h>
#include <sys/conf.h>
#include <sys/modctl.h>
#include <sys/open.h>
#include <sys/stat.h>
#include <sys/ddi.h>
#include <sys/sunddi.h>
#include <sys/dditypes.h>
#include <sys/byteorder.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stddef.h>
#include <netinet/in.h>
#include <inttypes.h>
#include <sys/mutex.h>
#define memset(ptr,c,len) bzero(ptr,len)
#define memcpy(a,b,c) bcopy(b,a,c)
#define memcmp(a,b,c) bcmp(a,b,c)
#else
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <limits.h>
#include <string.h>
#include <wchar.h>
#endif
#include "stdafx.h"
#include "drtcsp_io.h"
#include "cmpmem.h"
//#include "platformstream.h"


#define MAX_BLK 4096
#define MAX_BIND 22
#define MAX_PROVBIND 9
#define BIND_LOCK 0
#define BIND_LOCK_NOSER 1
//#define BIND_FAIL_NOSER 2
#define BIND_NOLOCK_0 2
#define BIND_NOLOCK_1 3
#define BIND_NOLOCK_2 4
#define BIND_NOLOCK_3 5
#define BIND_NOLOCK_4 6
#define BIND_NOLOCK_5 7
#define BIND_NOLOCK_6 8
#define BIND_NOLOCK_7 9
#define BIND_FAIL_NOLOCK 10

static const int MinBlk = 100;   /* MAX_BLK - (3*4 + 2 + cbPktKeyBlob + cbIV + cbHash); */

/*      */
typedef struct 
{
  int provs; /*     */
  int mod_init; /*     */
  int prov_init; /*      */
  int use_fastcode; /*   FASTCODE */
  int use_locks; /*    */
  int serialize; /*   serialize */
  HCRYPTMODULE module; /*  */
  HCRYPTPROV prov[MAX_PROVBIND]; /*    */
  VTABLEPROVSTRUC vtable;
  CPC_CONFIG config;
  mem_block mblock; /*  Lfmm   ,   */
} ProvBind, *LPProvBind;

static ProvBind binds[MAX_BIND]=
{
  /* FASTCODE */
  {1,1,1,1,1,1,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_LOCK */
  {9,1,1,1,1,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_LOCK_NOSER */
  {1,0,0,1,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_0 */
  {1,0,0,1,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_1 */
  {1,0,0,1,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_2 */
  {1,0,0,1,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_3 */
  {1,0,0,1,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_4 */
  {1,0,0,1,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_5 */
  {1,0,0,1,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_6 */
  {1,0,0,1,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_7 */
  {8,1,0,1,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_FAIL_NOLOCK */
  /* NO FASTCODE */
  {1,1,1,0,1,1,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_LOCK */
  {9,1,1,0,1,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_LOCK_NOSER */
  {1,0,0,0,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_0 */
  {1,0,0,0,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_1 */
  {1,0,0,0,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_2 */
  {1,0,0,0,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_3 */
  {1,0,0,0,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_4 */
  {1,0,0,0,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_5 */
  {1,0,0,0,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_6 */
  {1,0,0,0,0,0,0,{0,0,0,0,0,0,0,0,0}}, /* BIND_NOLOCK_7 */
  {8,1,0,0,0,0,0,{0,0,0,0,0,0,0,0,0}} /* BIND_FAIL_NOLOCK */
};

/*   ->[,   ] */ 
typedef struct
{
  int bind;
  int num;
} MinorBind,*LPMinorBind;

const MinorBind minors[MAX_MINORS]=
{
  /* FASTCODE */
  {0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}, /* Test 1,locks & seralize */
  {1,0},{1,1},{1,2},{1,3},{1,4},{1,5},{1,6},{1,7}, /* Test 2,locks & noser */
  {1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}, /* Test 3,fail 1 context */
  {2,0},{3,0},{4,0},{5,0},{6,0},{7,0},{8,0},{9,0}, /* Test 4,nolock,noser */
  {10,0},{10,1},{10,2},{10,3},{10,4},{10,5},{10,6},{10,7}, /* Test 5 fail 1 prov*/
  /* NO FASTCODE */
  {11,0},{11,0},{11,0},{11,0},{11,0},{11,0},{11,0},{11,0}, /* Test 1,locks & seralize */
  {12,0},{12,1},{12,2},{12,3},{12,4},{12,5},{12,6},{12,7}, /* Test 2,locks & noser */
  {12,8},{12,8},{12,8},{12,8},{12,8},{12,8},{12,8},{12,8}, /* Test 3,fail 1 context */
  {13,0},{14,0},{15,0},{16,0},{17,0},{18,0},{19,0},{20,0}, /* Test 4,nolock,noser */
  {21,0},{21,1},{21,2},{21,3},{21,4},{21,5},{21,6},{21,7} /* Test 5 fail 1 prov*/
};

/*     DRTCSP */ 
static inline HCRYPTMODULE get_module(PDRTCSP pdrtcsp)
{
	int minor;
	if (pdrtcsp == NULL)
		return 0;
	minor=pdrtcsp->minor;
	if (minor<0 || minor>=MAX_MINORS)
		return 0;
	return binds[minors[minor].bind].module;
}

/*     DRTCSP */ 
static inline HCRYPTPROV get_prov(PDRTCSP pdrtcsp)
{
	int minor;
	if (pdrtcsp == NULL)
		return 0;
	minor=pdrtcsp->minor;
	if (minor<0 || minor>=MAX_MINORS)
		return 0;
	return binds[minors[minor].bind].prov[minors[minor].num];
}


const VTABLEPROVSTRUC VTABLE2001 = { 3, 0, 0, PROV_GOST_2001_DH,
    0, 0, 0 };

/*   -  ,   .. */
static int remove_binds(void)
{
  int i,j;
  for (i=0;i<MAX_BIND;i++)
  {
    if (binds[i].module)
    {
       for (j=0;j<binds[i].provs;j++)
         if (binds[i].prov[j])	       
	 { 
	    binds[i].module->ReleaseContext(binds[i].module,binds[i].prov[j],0);
	    binds[i].prov[j]=0;
         }
       binds[i].module->DestroyProvider(binds[i].module);
       binds[i].module=0;
       remove_config(&binds[i].config,&binds[i].mblock);
    }
  }
  return S_OK;
}

static void get_fastcode_str(HCRYPTMODULE hCSP,HCRYPTPROV hProv, char * buf, size_t n)
{
    DWORD res = (DWORD)NTE_FAIL;
    DWORD dwFastCode = 0;
    DWORD dwFastCodeLen = sizeof(dwFastCode);
    res = hCSP->GetProvParam(hCSP,hProv,
	PP_FAST_CODE_FLAGS, 
	(BYTE *)&dwFastCode,
	&dwFastCodeLen,
	CRYPT_FAST_CODE_ALL_KERNEL_FUNCTIONS|CRYPT_FAST_CODE_GET_SETFN);
    if (res != 0)
    {
	snprintf(buf,n,"PP_FASTCODE Failed:0x%08x",res);
	return;
    }
    if (dwFastCode&CSP_FAST_CODE_GET_SETFN)
    {
	snprintf(buf,n,"FAST_CODE:0x%08x,%sSSSE3,%sAVX,%s",
	    dwFastCode,
	    (dwFastCode&CSP_FAST_CODE_DISABLE_SSSE3)?"Disable":"Enable",
	    (dwFastCode&CSP_FAST_CODE_DISABLE_AVX)?"Disable":"Enable",
	    (dwFastCode&CSP_FAST_CODE_GET_FN)?"Full":"Partial");
    }
    else
	snprintf(buf,n,"NoFastHW");
}



/*   /,     */
static int init_binds(void)
{
  int i,j;
  HRESULT code;

  for (i=0;i<MAX_BIND;i++)
  {
    if (binds[i].mod_init)
    {
      memcpy(&binds[i].vtable,&VTABLE2001,sizeof(VTABLE2001));
      code=prepare_config(&binds[i].config,&binds[i].mblock,binds[i].use_fastcode, binds[i].use_locks);
      if (code!=S_OK) {
	// TODO:    ,   
	//    
	goto err;
      }
      code=CPCCreateProvider(&binds[i].module,&binds[i].config);
      if (code!=S_OK)
      {
	 binds[i].config.logConfig.eprint_str(binds[i].config.logConfig.lpArg,
	 	"init_binds():256: CPCCreateProvider() fail, "
		"retcode see below");
	 remove_config(&binds[i].config,&binds[i].mblock);
	 goto err;
      }
      if (binds[i].prov_init)
      {
	for (j=0;j<binds[i].provs;j++)
	{	
	   code=binds[i].module->AcquireContext(binds[i].module, 
			           &binds[i].prov[j], NULL,
				   CRYPT_VERIFYCONTEXT|
				    (binds[i].serialize?0:CRYPT_NOSERIALIZE),
				   &binds[i].vtable);
	  if (code!=S_OK) {
	     binds[i].config.logConfig.eprint_str(
	     	    binds[i].config.logConfig.lpArg,
		    "init_binds():273: ->AcquireContext() fail, "
		    "retcode see below");
	    goto err;
	  }
	  {
	     char buf[160]=MODNAME":";
	     size_t l=strlen(buf);
	     get_fastcode_str(binds[i].module,binds[i].prov[j],buf+l,sizeof(buf)-l-1);
	     binds[i].config.logConfig.dprint_str (NULL, buf);
	  }
	}
      }
    }
  }
  return S_OK;
err:
  remove_binds();
  return code;
}

static void
err_print(PDRTCSP pdrtcsp, char *str, const char *func, int line)
{
  char buf[256];

  snprintf(buf, 255, MODNAME": %s:%d: %s", func, line, str);
  binds[minors[pdrtcsp->minor].bind].config.logConfig.eprint_str (NULL, buf);
}

#define ERR_PRINT(str) err_print(pdrtcsp, str, __func__, __LINE__);
/*      ,   */
static void * cfg_malloc(LPCPC_CONFIG CSPConfig, size_t dwSize, DWORD dwMemPoolId)
{
  unsigned long dwThreadId;
  void * res=NULL;
  if (CSPConfig == NULL)
  {
    return NULL;
  }
  if (CSPConfig->logConfig.get_thread_id == NULL)
  {
    CSPConfig->logConfig.eprint_str(NULL,"NO get_thread_id!!!");
    return NULL;
  }
  dwThreadId=CSPConfig->logConfig.get_thread_id();
  if (CSPConfig->pArena == NULL)
  {
    CSPConfig->logConfig.eprint_str(NULL,"NO CSPConfig->pArena!!!");
    return NULL;
  }
  if (CSPConfig->pArena->pAllocMemory(
			CSPConfig->pArena,
			dwSize,
			dwMemPoolId,
			dwThreadId,
			&res)!=S_OK)
  {
    CSPConfig->logConfig.eprint_str(NULL,"Could not alloc memory");
    return NULL;	
  }
  else
  {	
    memset(res,0,dwSize);
    CSPConfig->logConfig.eprint_str(NULL,"Buffer filled with zeroes");
    return res;
  }
}

/*      ,   */
static void cfg_free(LPCPC_CONFIG CSPConfig, void * ptr, DWORD dwMemPoolId)
{
  CSPConfig->pArena->pFreeMemory(CSPConfig->pArena,ptr,dwMemPoolId);
}

int CPCAPI open_hook(PDRTCSP pdrtcsp)
{
  LPProvBind bnd; 
  int num;
  HRESULT code=NTE_FAIL;
  
  if (pdrtcsp->minor<0 || pdrtcsp->minor>=MAX_MINORS)
	  return EPERM;
  if(pdrtcsp->size != sizeof(*pdrtcsp)){
    ERR_PRINT("corrupt");
    return ENXIO;
  }

  if(!(pdrtcsp->state&DRTCSP_ATTACH)){
    ERR_PRINT("double attach");
    return ENXIO;
  }

  /*    */
  if(pdrtcsp->state&DRTCSP_OPEN) {
    ERR_PRINT("already open");
    return EBUSY;
  }

  pdrtcsp->hDmnKey = 0;
  pdrtcsp->hSessionKey = 0;
  bnd=&binds[minors[pdrtcsp->minor].bind];
  num=minors[pdrtcsp->minor].num;
  if (!bnd->mod_init)
  {
    if (bnd->module)
      return EAGAIN;
    else
    {
      memcpy(&bnd->vtable,&VTABLE2001,sizeof(VTABLE2001));
      code=prepare_config(&bnd->config,&bnd->mblock,bnd->use_fastcode,bnd->use_locks);
      if (code!=S_OK)
        return EPERM;
      code=CPCCreateProvider(&bnd->module,&binds->config);
      if (code!=S_OK)
	goto err;
    }
  }
  if (!bnd->prov_init)
  {
    code=bnd->module->AcquireContext(bnd->module, 
		           &bnd->prov[num], NULL,
			   CRYPT_VERIFYCONTEXT|
			    (bnd->serialize?0:CRYPT_NOSERIALIZE),
			   &bnd->vtable);
    if (code!=S_OK)
      goto err;
  }
  pdrtcsp->bData=cfg_malloc(&bnd->config,MAX_BLK+1,MP_BIG);
  if (pdrtcsp->bData == NULL)
     goto err;
  pdrtcsp->rcnt = 0;
  pdrtcsp->wcnt = 0;
  pdrtcsp->state |= DRTCSP_OPEN;
  return 0;

err:
  if (bnd->prov[num] && !bnd->prov_init)
  {
    bnd->module->ReleaseContext(bnd->module,bnd->prov[num],0);
    bnd->prov[num]=0;
  }
  if (bnd->module && !bnd->mod_init)
  {
    bnd->module->DestroyProvider(bnd->module);
    bnd->module=0;
    remove_config(&bnd->config,&bnd->mblock);
  }
  switch(code) 
  {
    case NTE_FAIL: return EFAULT;break;
    case NTE_NO_MEMORY: return ENOMEM;break;
    case NTE_PROVIDER_DLL_FAIL: return EPERM;break;
    default: return EFAULT;
  }
}

int CPCAPI close_hook(PDRTCSP pdrtcsp)
{
  LPProvBind bnd; 
  int num;
  
  if (pdrtcsp->minor<0 || pdrtcsp->minor>=MAX_MINORS)
	  return EPERM;

  if (pdrtcsp->size != sizeof(*pdrtcsp))
  {
    ERR_PRINT("corrupt");
    return ENXIO;
  }

  if (!(pdrtcsp->state&DRTCSP_OPEN))
  {
    ERR_PRINT("double close");
    return ENXIO;
  }

  bnd=&binds[minors[pdrtcsp->minor].bind];
  num=minors[pdrtcsp->minor].num;

  /*
   *  
   */
  if (bnd->module)
  {
    if (bnd->prov[num])
    {
      if (pdrtcsp->hSessionKey) 
        bnd->module->DestroyKey(bnd->module, get_prov(pdrtcsp), pdrtcsp->hSessionKey);
      if (pdrtcsp->hDmnKey) 
         bnd->module->DestroyKey(bnd->module, get_prov(pdrtcsp), pdrtcsp->hDmnKey);
      if (!bnd->prov_init)
      {
         bnd->module->ReleaseContext(bnd->module, get_prov(pdrtcsp), 0);
         bnd->prov[num] = 0;
      }
    }
    if (pdrtcsp->bData)
       cfg_free(&bnd->config,pdrtcsp->bData,MP_BIG);
    if (!bnd->mod_init)
    {
       bnd->module->DestroyProvider(bnd->module);
       remove_config(&bnd->config,&bnd->mblock);
       bnd->module=0;
    }
  }
  pdrtcsp->hSessionKey = 0;
  pdrtcsp->hDmnKey = 0;
  pdrtcsp->bData=0;
  pdrtcsp->state &= ~(DRTCSP_OPEN|DRTCSP_DRVRND_OK|DRTCSP_DRVKEY_OK|DRTCSP_SESKEY_OK);
  return 0;
}

int CPCAPI init_hook(void)
{
  return init_binds();
}

int CPCAPI fini_hook(void)
{
  return remove_binds();
}


int CPCAPI
detach_hook(PDRTCSP pdrtcsp)
{
  if(!pdrtcsp) return EINVAL;
  if(pdrtcsp->size != sizeof(*pdrtcsp)){
    ERR_PRINT("corrupt");
    return EINVAL;
  }
  if(!(pdrtcsp->state&DRTCSP_ATTACH)){
    ERR_PRINT("double detach");
    return EINVAL;
  }
  pdrtcsp->state = 0;

  return 0;
}

int CPCAPI
ioctl_hook(PDRTCSP pdrtcsp)
{
  if(pdrtcsp->size != sizeof(*pdrtcsp)){
    ERR_PRINT("corrupt");
    return ENXIO;
  }

  if(!(pdrtcsp->state&DRTCSP_OPEN)){
    ERR_PRINT("not open");
    return ENXIO;
  }

  return 0;
}

static int CPCAPI
rw_hook(PDRTCSP pdrtcsp, int resid)
{
  if (pdrtcsp->size != sizeof(*pdrtcsp)){
    ERR_PRINT("corrupt");
    return ENXIO;
  }

  if (!(pdrtcsp->state&DRTCSP_OPEN)){
    ERR_PRINT("not open");
    return ENXIO;
  }

  if (!(pdrtcsp->state&DRTCSP_DRVRND_OK && pdrtcsp->state&DRTCSP_DRVKEY_OK)){
    ERR_PRINT("not common key");
    return ENXIO;
  }

  if (!(pdrtcsp->state&DRTCSP_SESKEY_OK)){
    ERR_PRINT("not session key");
    return ENXIO;
  }
  if(resid < MinBlk || resid > MAX_BLK) {
    char str[64];
    snprintf(str, 63, "resid=%d, MinBlk=%ld, MAX_BLK=%ld", resid,
	     (unsigned long)MinBlk, (unsigned long)MAX_BLK);
    ERR_PRINT(str);
    return EINVAL;
  }

  return 0;
}

static void
null_packet(packet *pkt)
{
  ZeroMemory(pkt, sizeof(packet));
}

static int
out_pkt(PDRTCSP pdrtcsp, packet *pkt, void *arg)
{
  int error=0;
  packet n_pkt;

  n_pkt.cbPktLen=htons(pkt->cbPktLen);
  n_pkt.cbPktKeyBlob=htons(pkt->cbPktKeyBlob);
  n_pkt.cbIV=htonl(pkt->cbIV);
  n_pkt.cbData=htonl(pkt->cbData);
  n_pkt.cbHash=htonl(pkt->cbHash);

#if 0
  {
    char str[64];
    snprintf(str, 63, "n_pkt: %lu %lu %lu %lu %lu", n_pkt.cbPktLen,
	     n_pkt.cbPktKeyBlob, n_pkt.cbIV, n_pkt.cbData, n_pkt.cbHash);
    ERR_PRINT(str);
    snprintf(str, 63, "pkt: %lu %lu %lu %lu %lu", pkt->cbPktLen,
	     pkt->cbPktKeyBlob, pkt->cbIV, pkt->cbData, pkt->cbHash);
    ERR_PRINT(str);
  }
#endif

  if(trans((unsigned char*)&n_pkt.cbPktLen, sizeof(pkt->cbPktLen), FROM_KERNEL, arg)
  || trans((unsigned char*)&n_pkt.cbPktKeyBlob, sizeof(pkt->cbPktKeyBlob), FROM_KERNEL, arg)
  || trans(pkt->bPktKeyBlob, pkt->cbPktKeyBlob, FROM_KERNEL, arg)
  || trans((unsigned char*)&n_pkt.cbIV, sizeof(pkt->cbIV), FROM_KERNEL, arg)
  || trans(pkt->bIV, pkt->cbIV, FROM_KERNEL, arg)
  || trans((unsigned char*)&n_pkt.cbData, sizeof(pkt->cbData), FROM_KERNEL, arg)
  || trans(pkt->bData, pkt->cbData, FROM_KERNEL, arg)
  || trans((unsigned char*)&n_pkt.cbHash, sizeof(pkt->cbHash), FROM_KERNEL, arg)
  || trans(pkt->bHash, pkt->cbHash, FROM_KERNEL, arg)){
    ERR_PRINT("failed");
    error=EFAULT;
  }

  ZeroMemory(pkt, sizeof(packet));
  ZeroMemory(&n_pkt, sizeof(packet));

  return error;
}

/*    ,   */
static int
in_pkt(PDRTCSP pdrtcsp, packet *pkt, void *arg)
{
  int error=0;
  packet n_pkt;

  if(trans((unsigned char*)&n_pkt.cbPktLen, sizeof(pkt->cbPktLen), TO_KERNEL, arg)
  || trans((unsigned char*)&n_pkt.cbPktKeyBlob, sizeof(pkt->cbPktKeyBlob), TO_KERNEL, arg)
  || pkt->cbPktKeyBlob<ntohs(n_pkt.cbPktKeyBlob)
  || trans(pkt->bPktKeyBlob, ntohs(n_pkt.cbPktKeyBlob), TO_KERNEL, arg)
  || trans((unsigned char*)&n_pkt.cbIV, sizeof(pkt->cbIV), TO_KERNEL, arg)
  || pkt->cbIV<ntohl(n_pkt.cbIV)
  || trans(pkt->bIV, ntohl(n_pkt.cbIV), TO_KERNEL, arg)
  || trans((unsigned char*)&n_pkt.cbData, sizeof(pkt->cbData), TO_KERNEL, arg)
  || pkt->cbData<ntohl(n_pkt.cbData)
  || trans(pkt->bData, ntohl(n_pkt.cbData), TO_KERNEL, arg)
  || trans((unsigned char*)&n_pkt.cbHash, sizeof(pkt->cbHash), TO_KERNEL, arg)
  || pkt->cbHash<ntohl(n_pkt.cbHash)
  || trans(pkt->bHash, ntohl(n_pkt.cbHash), TO_KERNEL, arg)){
    ERR_PRINT("failed");
#if 0
    {
      char str[64];
      snprintf(str, 63, "n_pkt: %lu %lu %lu %lu %lu", n_pkt.cbPktLen,
	       n_pkt.cbPktKeyBlob, n_pkt.cbIV, n_pkt.cbData, n_pkt.cbHash);
      ERR_PRINT(str);
      snprintf(str, 63, "pkt: %lu %lu %lu %lu %lu", pkt->cbPktLen,
	       pkt->cbPktKeyBlob, pkt->cbIV, pkt->cbData, pkt->cbHash);
      ERR_PRINT(str);
    }
#endif
    error=EFAULT;
  }

  pkt->cbPktLen=ntohs(n_pkt.cbPktLen);
  pkt->cbPktKeyBlob=ntohs(n_pkt.cbPktKeyBlob);
  pkt->cbIV=ntohl(n_pkt.cbIV);
  pkt->cbData=ntohl(n_pkt.cbData);
  pkt->cbHash=ntohl(n_pkt.cbHash);

  ZeroMemory(&n_pkt, sizeof(packet));

  return error;
}

/*
 * \section read "read(->uio_offset, ->uio_resid)"
 * \brief    (  
 *  block_num)      :
 *      \arg 2  -    (  );
 *      \arg 2  - cbPktKeyBlob -     ;
 *      \arg cbPktKeyBlob  - bPktKeyBlob -    ;
 *      \arg 4  - cbIV -  ;
 *      \arg cbIV  - bIV - ;
 *      \arg 4  - cbData -   == uio_resid - (3*4 + 2 + cbPktKeyBlob + cbIV + cbHash);
 *      \arg cbData  - bData -   0;
 *      \arg 4  - cbHash -  ;
 *      \arg cbHash  - bHash - ;
 */
int CPCAPI
read_hook(PDRTCSP pdrtcsp, int *resid,  void *arg)
{
  int error;
  HCRYPTKEY   hBlkKey = 0;
  HCRYPTKEY   hBlkHash = 0;
  DWORD       bPktKeyBlob; // MUST be 4 bytes len because of cpDiversData size.
  unsigned char   bIV[8];
  DWORD           dwcbcbHash=0;
  unsigned char   bHash[4];
  /*     CRYPT_DIVERSBLOB,
    ,       1 
      DWORD.     ,
      ,     
    */
  struct
  {
      CRYPT_DIVERSBLOB Blob;
      BYTE dummy[sizeof(bPktKeyBlob)-1];
  } Blb;     
  packet pkt;
  const HCRYPTMODULE csp=get_module(pdrtcsp);
  const HCRYPTPROV hProv=get_prov(pdrtcsp);
  size_t block_num = pdrtcsp->rcnt;

  null_packet(&pkt);

  if((error=rw_hook(pdrtcsp, *resid))) return error;
  error=EFAULT;

  bPktKeyBlob = htonl(block_num);
  pkt.cbPktLen=*resid;
  pkt.cbPktKeyBlob=sizeof(bPktKeyBlob);
  pkt.bPktKeyBlob=(unsigned char *)&bPktKeyBlob;
  pkt.bIV=bIV;
  pkt.cbIV=sizeof(bIV);
  pkt.bHash=bHash;
  pkt.bData=pdrtcsp->bData;

  Blb.Blob.DiversBlobHeader.BlobHeader.bType = DIVERSKEYBLOB;
  Blb.Blob.DiversBlobHeader.BlobHeader.bVersion = BLOB_VERSION;
  Blb.Blob.DiversBlobHeader.BlobHeader.reserved = 0;
  Blb.Blob.DiversBlobHeader.BlobHeader.aiKeyAlg = CALG_G28147;
  Blb.Blob.DiversBlobHeader.aiDiversAlgId = CALG_PRO_DIVERS;
  Blb.Blob.DiversBlobHeader.dwDiversMagic = 0x31564944;
  CopyMemory(Blb.Blob.bDiversData, (BYTE *)&bPktKeyBlob, sizeof(bPktKeyBlob));
  Blb.Blob.DiversBlobHeader.cbDiversData = sizeof(bPktKeyBlob);

  if(csp->ImportKey(csp, hProv, (BYTE *)&Blb.Blob,
      sizeof(CRYPT_DIVERSBLOBHEADER)+Blb.Blob.DiversBlobHeader.cbDiversData, pdrtcsp->hSessionKey, 0, &hBlkKey)) {
    return EFAULT;
  }
#if 0
    test_encrypt_data(dCSP, hProv, hBlkKey);
#endif


  if (csp->CreateHash(csp, hProv, CALG_G28147_IMIT, hBlkKey, 0, &hBlkHash)) {
    goto exit;
  }

  dwcbcbHash = sizeof(pkt.cbHash);
  if(csp->GetHashParam(csp, hProv, hBlkHash,
      HP_HASHSIZE, (BYTE *)&pkt.cbHash, &dwcbcbHash, 0) ||
      pkt.cbHash > sizeof(bHash) ||
      dwcbcbHash != sizeof(pkt.cbHash)) {
    goto exit;
  }
  pkt.bHash=bHash;

  if(csp->GetKeyParam(csp, hProv, hBlkKey, KP_IV, bIV, &pkt.cbIV, 0)) {
    goto exit;
  }
  pkt.cbData = *resid -
            (   sizeof(pkt.cbPktLen) +
                sizeof(pkt.cbPktKeyBlob) + pkt.cbPktKeyBlob +
                sizeof(pkt.cbIV) + pkt.cbIV +
                sizeof(pkt.cbData) +
                sizeof(pkt.cbHash) + pkt.cbHash);

  ZeroMemory(pdrtcsp->bData, pkt.cbData);

  if (csp->Encrypt(csp, hProv, hBlkKey, hBlkHash, TRUE, 0, pdrtcsp->bData, &pkt.cbData, pkt.cbData)) {
    goto exit;
  }

  if(csp->GetHashParam(csp, hProv, hBlkHash, HP_HASHVAL,
      bHash, &pkt.cbHash, 0) || pkt.cbHash > sizeof(bHash)) {
    goto exit;
  }

  if((error=out_pkt(pdrtcsp, &pkt, arg))) goto exit;

  pdrtcsp->rcnt++;

  *resid=0;
exit:
  if (hBlkKey) {
    csp->DestroyKey(csp, hProv, hBlkKey);
    hBlkKey = 0;
  }
  if (hBlkHash) {
    csp->DestroyHash(csp, hProv, hBlkHash);
    hBlkHash = 0;
  }
   
  return error;
}

/*
 * \section write "write(->uio_offset, ->uio_resid)"
 * \brief    (  
 *  block_num == ->uio_offset/4096),   
 *  :
 *      \arg 2  -    (  );
 *      \arg 2  - cbPktKeyBlob -     ;
 *      \arg cbPktKeyBlob  - pbPktKeyBlob -    ;
 *      \arg 2  - cbIV -  ;
 *      \arg cbIV  - pbIV - ;
 *      \arg 2  - cbData -   == uio_resid - (4*2 + cbPktKeyBlob + cbIV + cbHash);
 *      \arg cbData  - pbData -   0;
 *      \arg 2  - cbHash -  ;
 *      \arg cbHash  - pbHash - ;
 *         0.
 */
int CPCAPI
write_hook(PDRTCSP pdrtcsp, int *resid, void *arg)
{
  HCRYPTKEY   hBlkKey = 0;
  HCRYPTKEY   hBlkHash = 0;
  int error;

  DWORD       bPktKeyBlob;
  unsigned char   bIV[8];
  unsigned char   bHash[4];
  DWORD           dwcbcbHash1, dwcbHash1;
  unsigned char   bHash1[4];
  CRYPT_DIVERSBLOB Blob;
  packet pkt;
  const HCRYPTMODULE csp=get_module(pdrtcsp);
  const HCRYPTPROV hProv=get_prov(pdrtcsp);
  size_t block_num=pdrtcsp->wcnt;

  null_packet(&pkt);

  if((error=rw_hook(pdrtcsp, *resid))) return error;
  error=EFAULT;

  pkt.cbPktKeyBlob=sizeof(bPktKeyBlob);
  pkt.bPktKeyBlob=(void*)&bPktKeyBlob;
  pkt.cbIV=sizeof(bIV);
  pkt.bIV=bIV;
  pkt.cbData=MAX_BLK+1;
  pkt.bData=pdrtcsp->bData;
  pkt.cbHash=sizeof(bHash);
  pkt.bHash=bHash;

  in_pkt(pdrtcsp, &pkt, arg);
  
  if(pkt.cbPktLen != *resid){
    char str[64];
    snprintf(str, 63, "cbPktLen (%u) != *resid (%u)", pkt.cbPktLen, *resid);
    ERR_PRINT(str);
    goto exit;
  }

  if(ntohl(bPktKeyBlob) != block_num) {
    char str[64];
    snprintf(str, 63, "ntohl(bPktKeyBlob) (%u) != block_num (%u)",
	     ntohl(bPktKeyBlob), (unsigned)block_num);
    ERR_PRINT(str);
    goto exit;
  }

  Blob.DiversBlobHeader.BlobHeader.bType = DIVERSKEYBLOB;
  Blob.DiversBlobHeader.BlobHeader.bVersion = BLOB_VERSION;
  Blob.DiversBlobHeader.BlobHeader.reserved = 0;
  Blob.DiversBlobHeader.BlobHeader.aiKeyAlg = CALG_G28147;
  Blob.DiversBlobHeader.aiDiversAlgId = CALG_PRO_DIVERS;
  Blob.DiversBlobHeader.dwDiversMagic = 0x31564944;
  CopyMemory(Blob.bDiversData, (BYTE *)&bPktKeyBlob, pkt.cbPktKeyBlob);
  Blob.DiversBlobHeader.cbDiversData = pkt.cbPktKeyBlob;

  if(csp->ImportKey(csp, hProv, (BYTE *)&Blob,
      sizeof(Blob), pdrtcsp->hSessionKey, 0, &hBlkKey)) {
    goto exit;
  }
#if 0
    error=test_decrypt_data(dCSP, hProv, hBlkKey);
    if(error) {error=-1; goto ret;}
#endif

  if(csp->CreateHash(csp, hProv, CALG_G28147_IMIT, hBlkKey, 0, &hBlkHash)) {
    goto exit;
  }

  dwcbcbHash1 = sizeof(dwcbHash1);
  if(csp->GetHashParam(csp, hProv, hBlkHash, HP_HASHSIZE, (BYTE *)&dwcbHash1, &dwcbcbHash1, 0) ||
    dwcbHash1 > sizeof(bHash1)    ||
    dwcbcbHash1 != sizeof(dwcbHash1)) {
    goto exit;
  }

  if(csp->SetKeyParam(csp, hProv, hBlkKey, KP_IV, bIV, 0)){
    goto exit;
  }

  if(csp->Decrypt(csp, hProv, hBlkKey, hBlkHash, TRUE, 0, pdrtcsp->bData, &pkt.cbData)) {
    goto exit;
  }

  if(csp->GetHashParam(csp, hProv, hBlkHash, HP_HASHVAL, bHash1, &dwcbHash1, 0) || dwcbHash1 > sizeof(bHash1)) {
    goto exit;
  }

  if (pkt.cbHash != dwcbHash1) {
    char str[64];
    snprintf(str, 63, "pkt.cbHash(%d)!=dwcbHash1(%d)", pkt.cbHash, dwcbHash1);
    ERR_PRINT(str);
    goto exit;
  }

  if(memcmp(&bHash, &bHash1, pkt.cbHash)) {
    ERR_PRINT("memcmp(&bHash, &bHash1, pkt.cbHash)");
    goto exit;
  }
  if (pdrtcsp->bData[0] != '\0' || pdrtcsp->bData[pkt.cbData-1] != '\0') {
    char str[64];
    snprintf(str, 63, "bData[0] = %x, bData[pkt.cbData-1(%d)] = %x",
	     pdrtcsp->bData[0], pkt.cbData-1, pdrtcsp->bData[pkt.cbData-1]);
    ERR_PRINT(str);
    goto exit;
  }

  *resid=0;
  error=0;
  pdrtcsp->wcnt++;
exit:
  if (hBlkHash)
  {
    csp->DestroyHash(csp,hProv,hBlkHash);
  }
  if (hBlkKey)
  {
    csp->DestroyKey(csp,hProv,hBlkKey);
  }
  ZeroMemory(&bPktKeyBlob, sizeof(bPktKeyBlob));
  ZeroMemory(bIV, sizeof(bIV));
  ZeroMemory(pdrtcsp->bData, MAX_BLK+1);
  ZeroMemory(bHash, sizeof(bHash));
  ZeroMemory(bHash1, sizeof(bHash1));
  dwcbHash1 = dwcbcbHash1 = 0;

  return error;
}

int CPCAPI
set_driver_rng(PDRTCSP pdrtcsp, DRTCSP_DRIVER_KEY *tmp)
{
  HCRYPTHASH  hDmnHash = 0;
  HCRYPTKEY   hDmnKey = 0;
  int         error = EFAULT;
  DWORD       dwAlgId;    /* what length ??? */
  CRYPT_DATA_BLOB cdb;
  DRTCSP_DRIVER_KEY xxx;
  const HCRYPTMODULE csp=get_module(pdrtcsp);
  const HCRYPTPROV hProv=get_prov(pdrtcsp);

  xxx.size = sizeof(xxx);
  xxx.version = Version1_2;
  xxx.magic = Drtcsp_RN_Daemon_Magic;
  if(memcmp(&tmp->size, &xxx.size, sizeof(xxx.size)) ||
     memcmp(&tmp->version, &xxx.version, sizeof(xxx.version)) ||
     memcmp(&tmp->magic, &xxx.magic, sizeof(xxx.magic))){
    ERR_PRINT("corrupt");
    goto exit;
  }

  cdb.cbData=tmp->cbData;
  cdb.pbData=tmp->bData;

  if(csp->SetProvParam(csp, hProv, PP_RANDOM, (BYTE*)&cdb, 0)) goto exit;

  if(csp->CreateHash(csp, hProv, CALG_GR3411, 0, 0, &hDmnHash)) goto exit;

  if(csp->HashData(csp, hProv, hDmnHash, (BYTE *)"DriverDaemon", sizeof("DriverDaemon"), 0)) goto exit;

  if(csp->HashData(csp, hProv, hDmnHash, tmp->bData, tmp->cbData, 0)) goto exit;

  if(csp->GenRandom(csp, hProv, sizeof(tmp->bData), tmp->bData)) goto exit;

  xxx.cbData = sizeof(tmp->bData);
  CopyMemory(&tmp->cbData, &xxx.cbData, sizeof(xxx.cbData));
  xxx.magic = Drtcsp_RN_Driver_Magic;
  CopyMemory(&tmp->magic, &xxx.magic, sizeof(xxx.magic));

  if(csp->HashData(csp, hProv, hDmnHash, tmp->bData, tmp->cbData, 0)) goto exit;

  if(csp->DeriveKey(csp, hProv, CALG_G28147, hDmnHash, 0, &hDmnKey)) goto exit;

  if(csp->DestroyHash(csp, hProv, hDmnHash)) goto exit;
  hDmnHash = 0;

#if 0
  error=test_encrypt_data(dCSP, hProv, hDmnKey);
  if(error == -1) goto exit;
#endif

  dwAlgId = CALG_SIMPLE_EXPORT;
  if(csp->SetKeyParam(csp, hProv, hDmnKey, KP_ALGID,
	(BYTE *)&dwAlgId, 0)) goto exit;
  pdrtcsp->hDmnKey=hDmnKey;
  hDmnKey=0;
  pdrtcsp->state |= DRTCSP_DRVRND_OK|DRTCSP_DRVKEY_OK;
  error=0;
#if 0
  error=test_encrypt_data(dCSP, hProv, hDmnKey);
#endif

exit:
  if(hDmnHash) csp->DestroyHash(csp, hProv, hDmnHash);
  if(hDmnKey) csp->DestroyKey(csp, hProv, hDmnKey);
  
  return error;
}

int CPCAPI
set_session_key(PDRTCSP pdrtcsp, DRTCSP_DRIVER_KEY *tmp)
{
  HCRYPTKEY   hSessionKey = 0;
  int         error = EFAULT;
  DRTCSP_DRIVER_KEY xxx;
  const HCRYPTMODULE csp=get_module(pdrtcsp);
  const HCRYPTPROV hProv=get_prov(pdrtcsp);

  if(!(pdrtcsp->state&DRTCSP_DRVRND_OK && pdrtcsp->state&DRTCSP_DRVKEY_OK)){
    ERR_PRINT("not common key");
    return ENXIO;
  }

  xxx.size = sizeof(xxx);
  xxx.version = Version1_2;
  xxx.magic = Drtcsp_KE_Session_Magic;
  if(memcmp(&tmp->size, &xxx.size, sizeof(xxx.size)) ||
     memcmp(&tmp->version, &xxx.version, sizeof(xxx.version)) ||
     memcmp(&tmp->magic, &xxx.magic, sizeof(xxx.magic))){
    ERR_PRINT("corrupt");
    goto exit;
  }

  if(csp->ImportKey(csp, hProv, tmp->bData, tmp->cbData,
	pdrtcsp->hDmnKey, 0, &hSessionKey)) goto exit;

#if 0
  error=test_encrypt_data(dCSP, hProv, hSessionKey);
  if(error == -1) goto exit;
#endif

  if(pdrtcsp->hSessionKey) 
    csp->DestroyKey(csp, hProv, pdrtcsp->hSessionKey);
  pdrtcsp->hSessionKey = hSessionKey;
  hSessionKey = 0;

  xxx.cbData = sizeof(tmp->bData);
  CopyMemory(&tmp->cbData, &xxx.cbData, sizeof(xxx.cbData));
  ZeroMemory(tmp->bData, xxx.cbData);
  xxx.magic = Drtcsp_KE_OKSetSK_Magic;
  CopyMemory(&tmp->magic, &xxx.magic, sizeof(xxx.magic));
  pdrtcsp->state |= DRTCSP_SESKEY_OK;
  error=0;
exit:
  if(hSessionKey) csp->DestroyKey(csp, hProv, hSessionKey);

  return error;
}

int CPCAPI
kernel_selftest(PDRTCSP pdrtcsp, DRTCSP_DRIVER_KEY *tmp)
{
  int         error = EFAULT;
  DWORD dwLen;
  DRTCSP_DRIVER_KEY xxx;
  const HCRYPTMODULE csp=get_module(pdrtcsp);
  const HCRYPTPROV hProv=get_prov(pdrtcsp);

  xxx.size = sizeof(xxx);
  xxx.version = Version1_2;
  xxx.magic = Drtcsp_ST_Daemon_Magic;
  if(memcmp(&tmp->size, &xxx.size, sizeof(xxx.size)) ||
     memcmp(&tmp->version, &xxx.version, sizeof(xxx.version)) ||
     memcmp(&tmp->magic, &xxx.magic, sizeof(xxx.magic))){
    ERR_PRINT("corrupt");
    goto exit;
  }

  dwLen = tmp->cbData;
  if(csp->GetProvParam(csp, hProv, PP_SELFTEST, (BYTE*)tmp->bData, &dwLen, 0)) goto exit;

  xxx.cbData = sizeof(tmp->bData);
  CopyMemory(&tmp->cbData, &xxx.cbData, sizeof(xxx.cbData));
  xxx.magic = Drtcsp_ST_Driver_Magic;
  CopyMemory(&tmp->magic, &xxx.magic, sizeof(xxx.magic));

  error=0;
exit:
  
  return error;
}
