/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2008-2013  
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */
/*
 *      Test driver headers for CryptoPro CSP driver
 *
 *      Copyright (c) 2008  Crypto-Pro Ltd.
 *
 *      Can be freely distributed and used under the terms of the GNU GPL.
 */
/*!
 * \file $RCSfile$
 * \version $Revision: 178883 $
 * \date $Date:: 2018-08-06 17:29:43 +0300#$
 * \author $Author: sempav $
 *
 * \brief       
 * " CSP"  Unix
 *
 *    -,  
 *   .    
 *   :
 *
 * \section open "open(...)"
 * \brief      
 *  " CSP"   Unix.
 *
 * \section ioctl "ioctl(...DRTCSP_DRIVER_KEY...)"
 * \brief   ioctl(...DRTCSP_DRIVER_KEY...)  
 * , :
 *      \arg    ;
 *      \arg    
 *           ;
 *      \arg     .
 *
 * \section ioctl "ioctl(...DRTCSP_SESSION_KEY...)"
 * \brief   ioctl(...DRTCSP_SESSION_KEY...)  
 * , :
 *      \arg       ();
 *      \arg  .
 *
 * \section ioctl "ioctl(...DRTCSP_SELFTEST...)"
 * \brief   ioctl(...DRTCSP_SELFTEST...)  
 * , :
 *      \arg      .
 *
 * \section read "read(->uio_offset, ->uio_resid)"
 * \brief    (,   
 *  N == ->uio_offset/4096)     
 *  :
 *      \arg 2  -    (  );
 *      \arg 2  - cbPktKeyBlob -     ;
 *      \arg cbPktKeyBlob  - pbPktKeyBlob -    ;
 *      \arg 4  - cbIV -  ;
 *      \arg cbIV  - pbIV - ;
 *      \arg 4  - cbData -   == uio_resid - (5*2 + cbPktKeyBlob + cbIV + cbHash);
 *      \arg cbData  - pbData -   0;
 *      \arg 4  - cbHash -  ;
 *      \arg cbHash  - pbHash - ;
 *
 * \section write "write(->uio_offset, ->uio_resid)"
 * \brief    (   
 *  N == ->uio_offset/4096),    
 *  :
 *      \arg 2  -    (  );
 *      \arg 2  - cbPktKeyBlob -     ;
 *      \arg cbPktKeyBlob  - pbPktKeyBlob -    ;
 *      \arg 4  - cbIV -  ;
 *      \arg cbIV  - pbIV - ;
 *      \arg 4  - cbData -   == uio_resid - (5*2 + cbPktKeyBlob + cbIV + cbHash);
 *      \arg cbData  - pbData -   0;
 *      \arg 4  - cbHash -  ;
 *      \arg cbHash  - pbHash - ;
 *   ,      0.
 *
 * \section close "close(...)"
 * \brief  (CPReleaseContext) 
 *  " CSP"   Unix.
 *
 * \section  ""
 * \brief :
 *
 *      /dev/drtcsp[01] 
 *                ,   .
 *
 *      /dev/drtcsp[23]
 *             CPHashSessionKey/CPDeriveKey   ,   .
 *
 *      /dev/drtcsp[45]
 *              CPGenKey,    .
 *
 *      /dev/drtcsp[67]
 *            ==  .
 *
 *      /dev/drtcsp[89]
 *            ,   .
*
 */

#ifndef	DRTCSP_IO_H
#define	DRTCSP_IO_H

#include "reader/support.h"
#include "wincspc_int.h"
#if !defined(USE_STD_MM) 
#include "lfmm.h"
#include "lfmm_int.h"
#endif

#ifndef CSP_LITE
# include <string.h>
# include <stdio.h>
#endif /* CSP_LITE */

#ifdef	__cplusplus
extern "C" {
#endif

#define MODNAME "drtcsp"
#define SUPPORT_DBMAX 256

typedef enum {
    Version1_2 = 0x0102,
    Version2_0 = 0x0200
}   DRTCSP_VERISON;

typedef enum {
    Drtcsp_RN_Daemon_Magic  = 0x6E6D6452,
    Drtcsp_RN_Driver_Magic  = 0x56524472,
    Drtcsp_KE_Session_Magic = 0x4B736553,
    Drtcsp_KE_OKSetSK_Magic = 0x74706D45,
    Drtcsp_ST_Daemon_Magic  = 0x6E9D1677,
    Drtcsp_ST_Driver_Magic  = 0x56ED1BB5
}   DRTCSP_MAGIC;

typedef struct {
    unsigned short	size;
    DRTCSP_VERISON	version;
    DWORD		cbData;
    unsigned char	bData[256-8];
    DRTCSP_MAGIC	magic; 
}   DRTCSP_DRIVER_KEY, *PDRTCSP_DRIVER_KEY; 

/*
 * commands for drtcsp_ioctl
 */
#ifdef FREEBSD
# include <sys/ioccom.h>
# define DRTCSP_DRIVER_RNG _IOWR('D', 1, DRTCSP_DRIVER_KEY)
# define DRTCSP_SESSION_KEY _IOWR('D', 2, DRTCSP_DRIVER_KEY)
# define DRTCSP_SELFTEST _IOWR('D', 3, DRTCSP_DRIVER_KEY)
#else
# define DRTCSP_IOC		('p' << 8)
# define DRTCSP_DRIVER_RNG	(DRTCSP_IOC | 1)
# define DRTCSP_SESSION_KEY	(DRTCSP_IOC | 2)
# define DRTCSP_SELFTEST	(DRTCSP_IOC | 3)
#endif


#define Ganuls 4096

#define MAX_MINORS 80
#define DRTCSP_MAX_CHANNEL MAX_MINORS

#define DRTCSP_ATTACH		0x01
#define DRTCSP_OPEN		0x02
#define DRTCSP_DRVRND_OK	0x04
#define DRTCSP_DRVKEY_OK	0x08
#define DRTCSP_SESKEY_OK	0x10

/*   */
typedef struct {
#if defined _KERNEL && defined SOLARIS
  dev_info_t     *dip;
#else
  void           *placeholder;
#endif
  unsigned long	 state;
  int		 minor;
  HCRYPTKEY	 hDmnKey;
  HCRYPTKEY      hSessionKey;
  size_t	 rcnt;
  size_t	 wcnt;
  size_t	 size;
  unsigned char * bData;
} DRTCSP, *PDRTCSP;

typedef struct {
  unsigned short cbPktLen;
  unsigned short cbPktKeyBlob;
  unsigned char *bPktKeyBlob;
  DWORD cbIV;
  unsigned char *bIV;
  DWORD cbData;
  unsigned char *bData;
  DWORD cbHash;
  unsigned char *bHash;
} packet;

typedef struct {
  void * buffer;
  size_t size;
} mem_block;

#define FROM_KERNEL 1
#define TO_KERNEL 2
extern int CPCAPI trans(unsigned char *data, size_t len, int dir, void *arg);

extern int CPCAPI init_hook(void);
extern int CPCAPI fini_hook(void);

extern int CPCAPI
attach_hook(PDRTCSP pdrtcsp, CPCCreateProvider_t *init_func,
	    LPCPC_CONFIG CSPConfig);
extern int CPCAPI
prepare_config(LPCPC_CONFIG CSPConfig, mem_block * blk,int use_fastcode, int use_locks);
extern int CPCAPI
remove_config(LPCPC_CONFIG CSPConfig, mem_block * blk);
extern int CPCAPI
detach_hook(PDRTCSP pdrtcsp);
extern int CPCAPI
open_hook(PDRTCSP pdrtcsp);
extern int CPCAPI
close_hook(PDRTCSP pdrtcsp);
extern int CPCAPI
ioctl_hook(PDRTCSP pdrtcsp);
/* extern int CPCAPI */
/* rw_hook(PDRTCSP pdrtcsp, int resid); */
extern int CPCAPI
read_hook(PDRTCSP pdrtcsp, int *resid, void *arg);
extern int CPCAPI
write_hook(PDRTCSP pdrtcsp, int *resid, void *arg);

extern int CPCAPI
set_driver_rng(PDRTCSP, DRTCSP_DRIVER_KEY *);
extern int CPCAPI
set_session_key(PDRTCSP, DRTCSP_DRIVER_KEY *);
extern int CPCAPI
kernel_selftest(PDRTCSP, DRTCSP_DRIVER_KEY *);

#ifdef	__cplusplus
}
#endif

#endif	/* DRTCSP_IO_H */
