/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

#if !defined( _READER_FAT12_FAT12INF_H )
#define _READER_FAT12_FAT12INF_H

#include "reader.kit/reader.h"

#if defined( __cplusplus )
extern "C" {
#endif

/*+   info-. +*/
extern const unsigned FAT12_INFO_SUPPORT[];
extern const size_t FAT12_INFO_SUPPORT_LEN;

#if defined( _WIN32 )
typedef struct TFat12ConnectEnum_
{
    TCHAR *drive_strings;
    TCHAR *cur;
} TFat12ConnectEnum;

#elif defined UNIX
  typedef struct TFat12ConnectEnumElem_ TFat12ConnectEnumElem;
  struct TFat12ConnectEnumElem_
  {
    TCHAR *connect_str;
    TFat12ConnectEnumElem *next;
  };
  
  typedef struct TFat12ConnectEnum_
  {
    TFat12ConnectEnumElem *drive_strings;
    TFat12ConnectEnumElem *cur;
  } TFat12ConnectEnum;
#endif /* _WIN32 */

DWORD fat12_info_system_flag(
    TSupSysContext *context, TSupSysInfo* );

DWORD fat12_group_info_system_flag(
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_group_enum_open(
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_group_enum_next(
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_group_enum_close(
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_get_password_type(TSupSysContext *context, TSupSysInfo *info);
DWORD fat12_get_param(TSupSysContext *context, TSupSysInfo *info);

DWORD fat12_info_nickname(
   TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_info_name(
   TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_register( 
    TSupSysContext *context, TSupSysInfo* );

DWORD fat12_unregister( 
    TSupSysContext *context, TSupSysInfo* );

DWORD fat12_context_dup( 
    TSupSysContext *context, TSupSysInfo* );

DWORD fat12_context_free( 
    TSupSysContext *context, TSupSysInfo* );

DWORD fat12_info_instance(
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_connect( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_disconnect( 
    TSupSysContext *context, TSupSysInfo *info );

/*   . */
DWORD fat12_open( 
    TSupSysContext *context, TSupSysInfo *info );

/*    . */
DWORD fat12_write( 
    TSupSysContext *context, TSupSysInfo *info );

/*    . */
DWORD fat12_read( 
    TSupSysContext *context, TSupSysInfo *info );

/*   . */
DWORD fat12_close( 
    TSupSysContext *context, TSupSysInfo *info );

/*    . */
DWORD fat12_length(
    TSupSysContext *context, TSupSysInfo *info );

/*     */
DWORD fat12_free_space(
    TSupSysContext *context, TSupSysInfo *info);

/*   . */
DWORD fat12_unlink( 
    TSupSysContext *context, TSupSysInfo *info );

/*     . */
DWORD fat12_connect_carrier( 
    TSupSysContext *context, TSupSysInfo* );

/*    . */
DWORD fat12_disconnect_carrier(
    TSupSysContext *context, TSupSysInfo* );

/*    . */
DWORD fat12_unique_get(
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_aux_call(
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_info_folder_enum_open( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_info_folder_enum_next( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_info_folder_enum_close( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_info_locked_folder_enum_open( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_info_locked_folder_enum_next( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_info_locked_folder_enum_close( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_folder_open( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_folder_close( 
    TSupSysContext *context, TSupSysInfo *info );

#ifdef _WIN32
DWORD fat12_folder_get_sdecr(
    TSupSysContext *context, TSupSysInfo *info);

DWORD fat12_folder_put_sdecr(
    TSupSysContext *context, TSupSysInfo *info);
#endif //_WIN32

DWORD fat12_folder_clear(
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_get_text_info(TSupSysContext *context, TSupSysInfo *info);

#ifdef UNIX
DWORD fat12_lock( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD fat12_unlock( 
    TSupSysContext *context, TSupSysInfo *info );
#endif //UNIX

DWORD fat12_chsize( 
    TSupSysContext *context, TSupSysInfo *info );

#if defined( __cplusplus )
}
#endif

#endif /* !_READER_FAT12_FAT12INF_H */
