/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/****
 * $Id: f12kchs.c 118717 2015-04-14 16:16:50Z sagafyin $
 *
 *       (READER).
 *
 *   /      (FAT12).
 *
 *   /      .
 *    .
 *
 * : fat12_write
 ****/

#include "fat12prj.h"
#if defined(UNIX)
#include <unistd.h>
#endif /* UNIX */

#ifdef UNIX
static DWORD set_file_size(FILE *handle, size_t size)
{
  if(!ftruncate(fileno(handle),size)) return ERROR_SUCCESS;
  /* Shit, ftruncate didn't work, we need manual intervention */
  if(fseek(handle, size, SEEK_SET)==-1) return fat12_os_error(); 

  return 0;
}
#else /* UNIX */
static DWORD set_file_size(HANDLE handle, size_t size)
{
    SUPSYS_PRE( size <= MAXLONG );
    if( SetFilePointer( handle, (long)size, NULL, FILE_BEGIN ) 
	== INVALID_SET_FILE_POINTER )
	    return fat12_os_error();
    if( !SetEndOfFile( handle ) )
	    return fat12_os_error();

  return ERROR_SUCCESS;
} 
#endif /* UNIX */


/*++++ 
 *    . 
 ++++*/
DWORD fat12_chsize( 
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TReaderInfoChSize *inf = (TReaderInfoChSize*)info;
    TFat12Context *ctx = (TFat12Context*)context;

    SUPSYS_PRE_CONTEXT( context, TFat12Context );
    SUPSYS_PRE_INFO( info, TReaderInfoChSize );

#ifdef UNIX
    if( ctx->handle == NULL )
#else
    if( ctx->handle == INVALID_HANDLE_VALUE )
#endif
	return (DWORD)SCARD_E_NOT_READY;

    return
	set_file_size(ctx->handle, *inf);
}
