#!/bin/sh

# Accepts either g++ or clang++ as argument.
# Returns 0 on success, 1 if the compiler isn't found.
try_to_set_compiler() {
    type "$1" >/dev/null || return 1
    echo "$1 found in the path" >&2
    case "$1" in
	g++)
	    ADD_CXX="-std=c++98"
	    if test -n '0'; then
		ADD_CXX="$ADD_CXX -D_GLIBCXX_USE_CXX11_ABI=0"
	    fi
	    if ( test `uname -m` = x86_64 || test `uname -s` = Darwin ) && test x$ARG = x32
	    then
		echo "CC=\"gcc -m32\";export CC;"
		echo "CXX=\"g++ -m32 $ADD_CXX\";export CXX;"
		echo "ARCH_FLAGS=\"-m32\";export ARCH_FLAGS;"
	    else
		echo "CC=\"gcc\";export CC;"
		echo "CXX=\"g++ $ADD_CXX\";export CXX;"
	    fi
	    if test x$ARG = x32
	    then
		echo "LSB_LD=/lib/ld-lsb.so.3;export LSB_LD;"
	    else
		echo "LSB_LD=/lib64/ld-lsb-x86-64.so.3;export LSB_LD;"
	    fi;;
	clang++)
	    echo "CC=\"clang\";export CC;"
	    echo "CXX=\"clang++ -std=c++98\";export CXX;"
            case `uname -s` in
                Darwin)
	            echo "CLANG_CXX_STDLIB=\"-stdlib=libc++\";export CLANG_CXX_STDLIB;";;
                *)
	            echo "CLANG_CXX_STDLIB=\"-stdlib=libstdc++\";export CLANG_CXX_STDLIB;";;
            esac;;
	*) echo "Unknown compiler: $1" >&2
	   return 2;;
    esac
    return 0
}

# Accepts env name and list of possible utility names as arguments.
# Set env variable to found executable
find_and_set() {
    name=$1
    shift
    if eval test -n \"\$$name\";then
	return 0
    fi
    for cmd in "$@";do
	if type "$cmd" 1>/dev/null 2>&1;then
	    eval $name=\"$cmd\"
	    return 0
	fi
    done
    echo "Cannot find suitable $name"
    return 1
}

ARG=32
#case `isainfo -k` in
#i386|sparc) ARG=32;;
#amd64|sparcv9) ARG=64;;
#esac
case `uname -m` in
x86_64|amd64|ppc64|aarch64) ARG=64;;
esac
for i in $*
do
	case $i in
	--64) ARG=64;;
	--32) ARG=32;;
	--help|--usage) echo "Usage: setenv.sh options" >&2
		echo "--32 - configure 32bit environment" >&2
		echo "--64 - configure 64bit environment" >&2
		exit 1;;
	esac
done

LIBDIR64=`echo /opt/cprocsp/lib/amd64 |sed -e 's/ia32/amd64/g;s/ppc$/ppc64/g;s/sparc$/sparcv9/g'`
LIBDIR32=`echo /opt/cprocsp/lib/amd64 |sed -e 's/amd64/ia32/g;s/ppc64/ppc/g;s/sparcv9/sparc/g'`

if test x$ARG = x64;then
case `uname -m` in
aarch64) MODVERSFILE=/opt/cprocsp/include/Module.symvers.aarch64;;
x86_64) MODVERSFILE=/opt/cprocsp/include/Module.symvers.amd64;;
ppc64) MODVERSFILE=/opt/cprocsp/include/Module.symvers.ppc64;;
*)MODVERSFILE=/opt/cprocsp/include/Module.symvers.amd64;;
esac
else
case `uname -m` in
i*86)MODVERSFILE=/opt/cprocsp/include/Module.symvers.ia32;;
mips)MODVERSFILE=/opt/cprocsp/include/Module.symvers.mips32;;
*)MODVERSFILE=/opt/cprocsp/include/Module.symvers.ia32;;
esac
fi

if test x$ARG = x64
then
    libdir=$LIBDIR64
    SIZEOF_VOID_P=8
else
    libdir=$LIBDIR32
    SIZEOF_VOID_P=4
fi

add_CPPFLAGS=-D_COMPACT
test -f /usr/include/stdint.h && \
    add_CPPFLAGS="${add_CPPFLAGS} -DHAVE_STDINT_H"
test -f /usr/include/sys/inttypes.h && \
    add_CPPFLAGS="${add_CPPFLAGS} -DHAVE_SYS_INTTYPES_H"

if test -z "$CXX" && test -z "$CCC";then
    echo "No compiler specified... trying to guess" >&2
    case `uname -s` in
#    SunOS) case `isainfo -k` in
    SunOS) case "XXX" in
#for stupid lsb checkers "XXX" (instead of isainfo -k)
	       amd64) COMPARCH=amd64
		      test $ARG = 64 && CSP_KERNEL_FLAGS="-DUSE_STD_MM -xmodel=kernel";;
	       sparcv9) COMPARCH=v9
			CSP_KERNEL_FLAGS="-DUSE_STD_MM";;

	   esac
	   if test -f /opt/SUNWspro/bin/CC;then
	        echo "Studio is found">&2
		CCC=/opt/SUNWspro/bin/CC
	   elif type CC >/dev/null;then 
		echo "CC is in the path" >&2
		CCC=CC
	   elif type g++ >/dev/null;then
		echo "g++ is found">&2
		CCC=g++
	   else
		echo "No C++  found">&2
		exit 1
           fi		
	   test x$ARG = x64 && case $CCC in
	    *CC) case `$CCC -V 2>&1|head -1|cut -d' ' -f4` in
		    5.9) echo "ARCH_FLAGS=\"-m64\";export ARCH_FLAGS;";;
		    *) echo "ARCH_FLAGS=\"-xarch=$COMPARCH\";export ARCH_FLAGS;";;
		 esac
		 test -n "$CSP_KERNEL_FLAGS" && echo "CSP_KERNEL_FLAGS=\"$CSP_KERNEL_FLAGS\";export CSP_KERNEL_FLAGS;"
		 ;;
	    *) CCC="$CCC -m64";;
	   esac
	   echo "CCC=\"$CCC\";export CCC;"
	   if test -f /opt/SUNWspro/bin/cc;then
	        echo "Studio is found">&2
		CC=/opt/SUNWspro/bin/cc
	   elif type cc >/dev/null;then 
		echo "cc is in the path" >&2
		CC=cc
	   elif type gcc >/dev/null;then
		echo "gcc is found">&2
		CC=gcc
	   else
		echo "Nothing is found">&2
		exit 1
           fi
	   echo "CC=\"$CC\";export CC;" ;;		

    AIX)
	if test x$ARG = x32;then
	    echo "CXX=/usr/vacpp/bin/xlC;export CXX;"
	    echo "CC=\"/usr/vac/bin/cc -qlanglvl=extc89 -qlanglvl=extc99\";export CC;"
	else
	    echo "CXX=\"/usr/vacpp/bin/xlC -q64\";export CXX;"
	    echo "CC=\"/usr/vac/bin/cc -q64 -qlanglvl=extc89 -qlanglvl=extc99\";export CC;"
	    echo "OBJECT_MODE=64;export OBJECT_MODE;"
	fi
    ;;
    Darwin)
        if ! try_to_set_compiler clang++ &&
           ! try_to_set_compiler g++;
        then
            echo "Nothing is found">&2
            exit 1
        fi;;
    *)
        if ! try_to_set_compiler g++ &&
           ! try_to_set_compiler clang++;
        then
            echo "Nothing is found">&2
            exit 1
        fi;;
    esac
fi    
if test -z "$INSTALL"
then 
    if type install >/dev/null;then
	INSTALL=install
    else
	INSTALL=cp
    fi
fi
prefix=/opt/cprocsp
includedir=${prefix}/include
if test -z "$includedir"
then
includedir=/opt/cprocsp/include
fi

find_and_set AWK "gawk" gawk awk
find_and_set SED "/usr/bin/sed" gsed sed

echo "SED=$SED;"
echo "AWK=$AWK;"
echo "CSP_DIR=/opt/cprocsp;"
echo "CSP_INCLUDE=$includedir;"
echo "add_CPPFLAGS=\"$add_CPPFLAGS $extern_CPPFLAGS\";"
echo "SIZEOF_VOID_P=$SIZEOF_VOID_P;"
echo "CSP_LIB=$libdir;"
echo "INSTALL=$INSTALL;"
echo "MODVERSFILE=$MODVERSFILE;"
case `uname -s` in
SunOS)echo "CSP_EXTRA_LIBS=\"-R$libdir -lsocket -lnsl\";";;
FreeBSD)echo "CSP_EXTRA_LIBS=\"-lpthread\";";;
AIX)echo "CXXFLAGS=\"$CXXFLAGS -qlang=stdc99\";export CXXFLAGS"
echo "add_ldflags=\"-Wl,-brtl\";";;
Darwin) echo "CSP_EXTRA_LIBS=\"-lpthread -framework CoreFoundation\";";;
*) echo "CSP_EXTRA_LIBS=\"-lpthread\";";;
esac
echo "export SED AWK CSP_DIR CSP_INCLUDE CSP_LIB CSP_EXTRA_LIBS SIZEOF_VOID_P INSTALL add_ldflags add_CPPFLAGS MODVERSFILE;"
