/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
#ifdef _WIN32
    #pragma setlocale("rus")
#endif
/*
 * Copyright(C) 2010-2014 -, 
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 250466 $
 * \date $Date:: 2022-12-15 14:26:57 +0300#$
 * \author $Author: kadykov $
 *
 * \brief      POSIX <unistd.h>
 *
 */

#ifndef sup_unistd_h_
#define sup_unistd_h_

#ifdef UNIX
    #include <unistd.h>
#else
    #include <Winsock2.h>
#endif

#include "reader/support.h"
#include "reader/sup_errno.h"
#include "reader/sup_signal_safe.h"
//#include "reader/sup_sys_socket.h"
//for android 
#ifndef F_LOCK
# define F_ULOCK 0      /* Unlock a previously locked region.  */
# define F_LOCK  1      /* Lock a region for exclusive use.  */
#endif //F_LOCK
#ifdef __cplusplus
extern "C" {
#endif

#ifdef UNIX
    SUPPORT_NOSIG(int, /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		close, (int fildes),
		(fildes),
		0 == ret,
		(EET_FTEXT(db_ctx, "%s(%d) = %d fail %s(%d)"),
		SFUNC, ret,
		ret, SUP_STRERROR(serrno), serrno))

    static SUP_INLINE int 
    support_close(SOCKET fildes)
    {
	return close(fildes);
    }
#else
    SUPPORT_ACTUAL_NOSIG(int, /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		closesocket, (__in SOCKET s),
		(s),
		0 == ret,
		(EET_FTEXT(db_ctx, "%s(%d) = %d fail %s(%d)"),
		SFUNC, s,
		ret, SUP_STRERROR(serrno), serrno))

    static SUP_INLINE int 
    support_an_close(SOCKET fildes)
    {
	return support_an_closesocket(fildes);
    }
    SUPPORT_NOSIG(int, /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		closesocket, (__in SOCKET s),
		(s),
		0 == ret,
		(EET_FTEXT(db_ctx, "%s(%d) = %d fail %s(%d)"),
		SFUNC, s,
		ret, SUP_STRERROR(serrno), serrno))

    static SUP_INLINE int 
    support_n_close(SOCKET fildes)
    {
	return support_n_closesocket(fildes);
    }

    static SUP_INLINE int 
    support_close(SOCKET fildes)
    {
	return closesocket(fildes);
    }
#endif
#ifdef UNIX
#ifdef ANDROID
int lockf(int /*filedes*/, int /*function*/, off_t /*size*/);
int lockf(int filedes, int function, off_t size){
    return 0;
}
#endif //ANDROID

    SUPPORT_NOSIG(int, /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		lockf, (int fildes, int function, off_t size),
		(fildes, function, size),
		0 == ret,
		(EET_FTEXT(db_ctx, "%s(%d, %d, %lld) = %d fail %s(%d)"),
		SFUNC, fildes, function, (long long)size,
		ret, SUP_STRERROR(serrno), serrno))

    SUPPORT_ACTUAL_NOSIG(int, /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		pipe, (int fildes[2]),
		(fildes),
		0 == ret,
		(EET_FTEXT(db_ctx, "%s(%p) = %d fail %s(%d)"),
		SFUNC, fildes,
		ret, SUP_STRERROR(serrno), serrno))
    SUPPORT_NOSIG(SUP_SSIZE_T, 
		/* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		read, (int fildes, void *buf, size_t nbyte),
		(fildes, buf, nbyte),
		0 <= ret,
		(EET_FTEXT(db_ctx, "%s(%d, %p, %lu) = %ld fail %s(%d)"),
		SFUNC, fildes, buf, (sup_ulong_t)nbyte,
		(long)ret, SUP_STRERROR(serrno), serrno))
    SUPPORT_ACTUAL_NOSIG(int, /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		unlink, (const char *path),
		(path),
		0 == ret,
		(EET_FTEXT(db_ctx, "%s(%s) = %d fail %s(%d)"),
		SFUNC, path,
		ret, SUP_STRERROR(serrno), serrno))
    SUPPORT_NOSIG(SUP_SSIZE_T, 
		/* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		write, (int fildes, const void *buf, size_t nbyte),
		(fildes, buf, nbyte),
		0 <= ret,
		(EET_FTEXT(db_ctx, "%s(%d, %p, %lu) = %ld fail %s(%d)"),
		SFUNC, fildes, buf, (sup_ulong_t)nbyte,
		(long)ret, SUP_STRERROR(serrno), serrno))
#endif

#ifdef __cplusplus
}
#endif
#endif /* sup_unistd_h_ */
