#ifndef IKEV2_DEBUG_H_
#define IKEV2_DEBUG_H_

#include <stdio.h>

#ifndef IKEV2_DEBUG_LEVEL
# define IKEV2_DEBUG_LEVEL 4
#endif /* DEBUG_LEVEL */

#ifdef IKEV2_SOURCE

/** debug macros, they call the dbg function hook */
#if IKEV2_DEBUG_LEVEL >= 0
# define DBG0(fmt, ...) ikev2_dbg(0, fmt, ##__VA_ARGS__)
#endif /* DEBUG_LEVEL */
#if IKEV2_DEBUG_LEVEL >= 1
# define DBG1(fmt, ...) ikev2_dbg(1, fmt, ##__VA_ARGS__)
#endif /* DEBUG_LEVEL */
#if IKEV2_DEBUG_LEVEL >= 2
# define DBG2(fmt, ...) ikev2_dbg(2, fmt, ##__VA_ARGS__)
#endif /* DEBUG_LEVEL */
#if IKEV2_DEBUG_LEVEL >= 3
# define DBG3(fmt, ...) ikev2_dbg(3, fmt, ##__VA_ARGS__)
#endif /* DEBUG_LEVEL */
#if IKEV2_DEBUG_LEVEL >= 4
# define DBG4(fmt, ...) ikev2_dbg(4, fmt, ##__VA_ARGS__)
# define DBGTRACE ikev2_dbg(4, "%s", __FUNCTION__)
# define DBGMTRACE ikev2_dbg(4, "%s this=%p", __FUNCTION__, this)
#endif /* DEBUG_LEVEL */

//#ifndef DBG0
//# define DBG0(...) {}
//#endif
//#ifndef DBG1
//# define DBG1(...) {}
//#endif
//#ifndef DBG2
//# define DBG2(...) {}
//#endif
//#ifndef DBG3
//# define DBG3(...) {}
//#endif
//#ifndef DBG4
//# define DBG4(...) {}
//# define DBGTRACE {}
//# define DBGMTRACE {}
//#endif

#endif /* IKEV2_SOURCE */

#ifndef DBG0
# define DBG0(...) {}
#endif
#ifndef DBG1
# define DBG1(...) {}
#endif
#ifndef DBG2
# define DBG2(...) {}
#endif
#ifndef DBG3
# define DBG3(...) {}
#endif
#ifndef DBG4
# define DBG4(...) {}
# define DBGTRACE {}
# define DBGMTRACE {}
#endif

/** dbg function hook, uses dbg_default() by default */
extern void (*ikev2_dbg) (int level, char *fmt, ...);

/** default logging function */
void ikev2_dbg_default(int level, char *fmt, ...);

/** set the level logged by dbg_default() */
void ikev2_dbg_default_set_level(int level);

/** set the stream logged by dbg_default() to */
void ikev2_dbg_default_set_stream(FILE *stream);

#endif /* DEBUG_H_ */
