/*
 * Copyright (c) 2000,  
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, CryptoPro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LICENSE_API_H_INCLUDED
#define _LICENSE_API_H_INCLUDED

#if defined(__cplusplus)
extern "C" {
#endif // defined(__cplusplus)

#define LICENSE_EXTRA_DEMO 1
#define LICENSE_EXTRA_SERVER 2
#define LICENSE_SET_LOCAL 1
#define LICENSE_REQUIREMENTS_SERVER 1

#ifdef _WIN32
#  define CPRO_CHAR wchar_t
#else
#  define CPRO_CHAR char
#endif // _WIN32

uint32_t get_first_install_date(const CPRO_CHAR *productCode, int64_t *pUnixTime);
uint32_t license_get(CPRO_CHAR *outSN, uint32_t *pOutSnLen, const CPRO_CHAR *productCode, uint32_t flags);
uint32_t license_check(const CPRO_CHAR *SN, CPRO_CHAR *outSN, uint32_t *pOutSnLen, int32_t *pValidity, int32_t *pType,
    			int32_t *pRestrictions, uint32_t *pExtra, int32_t *pDaysToExpire, int64_t *pUnixTimeEnd);
uint32_t license_set(CPRO_CHAR *SN, const CPRO_CHAR *productCode, uint32_t flags);
uint32_t license_requirements(uint32_t *pRequirements, uint32_t flags);

#if defined(__cplusplus)
} // extern "C"
#endif // defined(__cplusplus)

#endif // _LICENSE_API_H_INCLUDED
