#
# Copyright (c) 2015, Crypto-Pro LLC
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or 
# without modification, are permitted provided that the 
# following conditions are met:
# * Redistributions of source code must retain the above 
#   copyright notice, this list of conditions and the following
#   disclaimer.
# * Redistributions in binary form must reproduce the above 
#   copyright notice, this list of conditions and the following
#   disclaimer in the documentation and/or other materials 
#   provided with the distribution.
# * Neither the name of the Crypto-Pro LLc nor the
#   names of its contributors may be used to endorse or promote
#   products derived from this software without specific prior 
#   written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL CRYPTO-PRO LLC BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
# THE POSSIBILITY OF SUCH DAMAGE.
#

%if %{!?kernel_release:1}%{?kernel_release:0}
%define kernel_release %(uname -r)
%endif

Summary: Accord random driver
Name: accord_random-%{kernel_release}
Source0: accord_random.tar.gz
Version: 1
Release: 0
#Source1: ./%{name}-%{version}.%{release}.tar.gz
License: BSD
Group: Applications/Security
URL: http://www.cryptopro.ru/
Packager: Dedal <dedal@cryptopro.ru>
BuildRoot: /tmp/%{name}-%{version}.%{release}-inst

%description
This package contains accord_random driver for linux.
This driver provides a hardware based RNG (accord_random chip) for CryptoPro CSP.

%prep
%setup -a0 -T -c

%build 
KVER=%{kernel_release}
for BUILDDIR in /lib/modules/$KVER/build /usr/src/linux-$KVER /usr/src/linux-headers-$KVER /usr/src/kernels/$KVER
do
    if test -d $BUILDDIR || test -h $BUILDDIR
    then
    	break
    fi
done
if ! test -d $BUILDDIR && ! test -h $BUILDDIR
then
    echo "Cannot find any suitable kernel headers"
    exit 1
fi

case $KVER in
2.*) make -C $BUILDDIR SUBDIRS=$PWD modules;;
*) make -C $BUILDDIR M=$PWD;;
esac

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/lib/modules/%{kernel_release}/kernel/drivers/misc
if test -f accord_random.ko; then 
  install -m755 accord_random.ko $RPM_BUILD_ROOT/lib/modules/%{kernel_release}/kernel/drivers/misc
else
  install -m755 accord_random.o $RPM_BUILD_ROOT/lib/modules/%{kernel_release}/kernel/drivers/misc
fi


%clean
rm -rf $RPM_BUILD_ROOT

%files 
/lib/modules/%{kernel_release}/kernel/drivers/misc/accord_random*

%post
depmod -a
modprobe accord_random

%preun
if lsmod|grep accord_random > /dev/null; then
  modprobe -r accord_random
else
  true
fi

%postun
depmod -a
