<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>
<xsl:output method="html" encoding="windows-1251"/>

<xsl:template match="/">

<HTML> 
   <HEAD> 
      <TITLE></TITLE> 
	<STYLE type="text/css"> 
	</STYLE> 
   </HEAD> 
   <BODY> 
	<xsl:apply-templates select="/fo:root/fo:layout-master-set/*"/>
   </BODY> 
</HTML> 

</xsl:template>


<xsl:template match="fo:simple-page-master">


<DIV>
   <!--xsl:apply-templates select="/fo:root/fo:page-sequence/fo:static-content[@flow-name='xsl-region-before']//*[@text-align='left']"/-->
   <xsl:apply-templates select="/fo:root/fo:page-sequence/fo:flow/*" mode="body"/>
</DIV>

</xsl:template>

<xsl:template match="fo:block" mode="body">

<xsl:variable name="style">	
	<xsl:if test="@font-family != ''">  font-family:  <xsl:value-of select="@font-family"/>;  </xsl:if> 
	<xsl:if test="@font-size != ''">    font-size:    <xsl:value-of select="@font-size"/>;    </xsl:if> 
	<xsl:if test="@font-family != ''">  font-family:  <xsl:value-of select="@font-family"/>;  </xsl:if> 
	<xsl:if test="@font-size != ''">    font-size:    <xsl:value-of select="@font-size"/>;    </xsl:if> 
	<xsl:if test="@text-align != ''">   text-align:   <xsl:value-of select="@text-align"/>;   </xsl:if> 
	<xsl:if test="@border-style != ''"> border-style: <xsl:value-of select="@border-style"/>; border-width: thin; border-color: black; </xsl:if> 
	<xsl:if test="@border-after-style != ''"> border-bottom-style: <xsl:value-of select="@border-after-style"/>; border-width: thin; border-color: black;</xsl:if> 
	<xsl:if test="@space-before != ''">   margin-top:   <xsl:value-of select="@space-before"/>;   </xsl:if> 
	<xsl:if test="@space-after != ''">   margin-bottom:   <xsl:value-of select="@space-after"/>;   </xsl:if> 
	<xsl:if test="@space-before.precedence != ''">   space-before.precedence:   <xsl:value-of select="@space-before.precedence"/>;   </xsl:if> 
	<xsl:if test="@space-after.precedence != ''">   space-after.precedence:   <xsl:value-of select="@space-after.precedence"/>;   </xsl:if> 
	<xsl:if test="@margin-left != ''">   margin-left:   <xsl:value-of select="@margin-left"/>;   </xsl:if> 
	<xsl:if test="@margin-right != ''">   margin-right:   <xsl:value-of select="@margin-right"/>;   </xsl:if> 
	<xsl:if test="@padding != ''">   padding:   <xsl:value-of select="@padding"/>;   </xsl:if> 

</xsl:variable>

    <DIV>
	<xsl:attribute name="STYLE"> 
	   <xsl:value-of select="$style"/>
	</xsl:attribute>

        <xsl:for-each select=".">
	   <xsl:apply-templates mode="body" />
	</xsl:for-each>
    </DIV>
</xsl:template>


<xsl:template match="fo:table" mode="body">

<xsl:variable name="style">	
	<xsl:if test="@font-family != ''">  font-family:  <xsl:value-of select="@font-family"/>;  </xsl:if> 
	<xsl:if test="@font-size != ''">    font-size:    <xsl:value-of select="@font-size"/>;    </xsl:if> 
	<xsl:if test="@font-family != ''">  font-family:  <xsl:value-of select="@font-family"/>;  </xsl:if> 
	<xsl:if test="@font-size != ''">    font-size:    <xsl:value-of select="@font-size"/>;    </xsl:if> 
	<xsl:if test="@text-align != ''">   text-align:   <xsl:value-of select="@text-align"/>;   </xsl:if> 
	<xsl:if test="@border-style != ''"> border-style: <xsl:value-of select="@border-style"/>; border-width: thin; border-color: black; </xsl:if> 
	<xsl:if test="@border-after-style != ''"> border-bottom-style: <xsl:value-of select="@border-after-style"/>; border-width: thin; border-color: black;</xsl:if> 
	<xsl:if test="@space-before != ''">   margin-top:   <xsl:value-of select="@space-before"/>;   </xsl:if> 
	<xsl:if test="@space-after != ''">   margin-bottom:   <xsl:value-of select="@space-after"/>;   </xsl:if> 
	<xsl:if test="@space-before.precedence != ''">   space-before.precedence:   <xsl:value-of select="@space-before.precedence"/>;   </xsl:if> 
	<xsl:if test="@space-after.precedence != ''">   space-after.precedence:   <xsl:value-of select="@space-after.precedence"/>;   </xsl:if> 
	<xsl:if test="@margin-left != ''">   margin-left:   <xsl:value-of select="@margin-left"/>;   </xsl:if> 
	<xsl:if test="@margin-right != ''">   margin-right:   <xsl:value-of select="@margin-right"/>;   </xsl:if> 
	<xsl:if test="@padding != ''">   padding:   <xsl:value-of select="@padding"/>;   </xsl:if> 
</xsl:variable>


<TABLE WIDTH="100%" cellspacing="0" >

	<xsl:attribute name="STYLE"> 
	   <xsl:value-of select="$style"/>
	</xsl:attribute>

        <xsl:for-each select=".">
	   <xsl:apply-templates mode="body"/>
	</xsl:for-each>

</TABLE>
</xsl:template>

<xsl:template match="fo:table-column" mode="body">
  <xsl:if test="@column-width != ''">
    <xsl:variable name="style">	
	<xsl:value-of select="@column-width"/> 
    </xsl:variable>
      <COL>
	<xsl:attribute name="WIDTH"> 
	   <xsl:value-of select="$style"/>
	</xsl:attribute>
      </COL>
  </xsl:if>
</xsl:template>


<xsl:template match="fo:table-body" mode="body">
<xsl:apply-templates mode="body"/>
</xsl:template>

<xsl:template match="fo:table-row" mode="body">
<TR>
   <xsl:apply-templates mode="body"/>
</TR>
</xsl:template>




<xsl:template match="fo:table-cell" mode="body">

<xsl:variable name="style">	
	<xsl:if test="@font-family != ''">  font-family:  <xsl:value-of select="@font-family"/>;  </xsl:if> 
	<xsl:if test="@font-size != ''">    font-size:    <xsl:value-of select="@font-size"/>;    </xsl:if> 
	<xsl:if test="@font-family != ''">  font-family:  <xsl:value-of select="@font-family"/>;  </xsl:if> 
	<xsl:if test="@font-size != ''">    font-size:    <xsl:value-of select="@font-size"/>;    </xsl:if> 
	<xsl:if test="@text-align != ''">   text-align:   <xsl:value-of select="@text-align"/>;   </xsl:if> 
	<xsl:if test="@border-style != ''"> border-style: <xsl:value-of select="@border-style"/>; border-width: thin; border-color: black; </xsl:if> 
	<xsl:if test="@border-after-style != ''"> border-bottom-style: <xsl:value-of select="@border-after-style"/>; border-width: thin; border-color: black;</xsl:if> 
	<xsl:if test="@space-before != ''">   margin-top:   <xsl:value-of select="@space-before"/>;   </xsl:if> 
	<xsl:if test="@space-after != ''">   margin-bottom:   <xsl:value-of select="@space-after"/>;   </xsl:if> 
	<xsl:if test="@space-before.precedence != ''">   space-before.precedence:   <xsl:value-of select="@space-before.precedence"/>;   </xsl:if> 
	<xsl:if test="@space-after.precedence != ''">   space-after.precedence:   <xsl:value-of select="@space-after.precedence"/>;   </xsl:if> 
	<xsl:if test="@margin-left != ''">   margin-left:   <xsl:value-of select="@margin-left"/>;   </xsl:if> 
	<xsl:if test="@margin-right != ''">   margin-right:   <xsl:value-of select="@margin-right"/>;   </xsl:if> 
	<xsl:if test="@padding != ''">   padding:   <xsl:value-of select="@padding"/>;   </xsl:if> 
</xsl:variable>

<TD>
   <xsl:attribute name="STYLE"> 
	<xsl:value-of select="$style"/>
   </xsl:attribute>

   <xsl:for-each select=".">
	<xsl:apply-templates mode="body"/>
   </xsl:for-each>

</TD>
</xsl:template>


</xsl:stylesheet>