<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>

	 <!--    -->	

<xsl:template match="AuthorityKeyIdentifier" name="AuthorityKeyIdentifier">

  <xsl:if test="keyIdentifier">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_AuthorityKeyIdentifier_keyIdentifier</xsl:with-param> </xsl:call-template> 		<!--    -->
    <xsl:for-each select="./keyIdentifier">  
	<xsl:call-template name="KeyIdentifier"/>
    </xsl:for-each>
  </xsl:if>

  <xsl:if test="authorityCertIssuer">
    <fo:block>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_AuthorityKeyIdentifier_authorityCertIssuer</xsl:with-param> </xsl:call-template>		<!--   : -->
    </fo:block>

    <xsl:for-each select="./authorityCertIssuer">  
	<xsl:call-template name="GeneralNames"/>
    </xsl:for-each>
  </xsl:if>

  <xsl:if test="authorityCertSerialNumber">
    <fo:block>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_AuthorityKeyIdentifier_authorityCertSerialNumber</xsl:with-param> </xsl:call-template>
	=
      <xsl:value-of select="./authorityCertSerialNumber"/>  
    </fo:block>
  </xsl:if>
</xsl:template>

<!--^-->
<xsl:template match="KeyIdentifier" name="KeyIdentifier">
   <xsl:value-of select="."/>
</xsl:template>


<xsl:template match="SubjectKeyIdentifier" name="SubjectKeyIdentifier">
	 <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SubjectKeyIdentifier_header</xsl:with-param> </xsl:call-template>
		=
	<xsl:call-template name="printOID"/>
</xsl:template>


<!--    -->

<xsl:template match="KeyUsage" name="KeyUsage">
<!--  <xsl:value-of select="."/> -->

  <xsl:if test='substring(.,1,1) = 1'>
	<!--   -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyUsage_digit_sign</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,2,1) = 1'>

	<!--  -->
    <xsl:if test='substring(.,1,1) != "0"'>
      <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyUsage_undisownable</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,3,1) = 1'>

	<!--   -->
    <xsl:if test='substring(.,1,2) != "00"'>
      <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyUsage_key_encr</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,4,1) = 1'>

	<!--   -->
    <xsl:if test='substring(.,1,3) != "000"'>
      <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyUsage_data_encr</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,5,1) = 1'>

	<!--   -->
    <xsl:if test='substring(.,1,4) != "0000"'>
      <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyUsage_key_consol</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,6,1) = 1'>

	<!--   -->
    <xsl:if test='substring(.,1,5) != "00000"'>
      <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyUsage_cert_sign</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,7,1) = 1'>

	<!--   (CRL) -->
    <xsl:if test='substring(.,1,6) != "000000"'>
      <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyUsage_crl_sign</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,8,1) = 1'>

	<!--   -->
    <xsl:if test='substring(.,1,7) != "0000000"'>
      <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyUsage_encr_only</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,9,1) = 1'>

	<!--   -->
    <xsl:if test='substring(.,1,8) != "00000000"'>
      <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyUsage_decr_only</xsl:with-param> </xsl:call-template>
  </xsl:if>
</xsl:template>


     <!--   -->
<xsl:template name="PrivateKeyUsagePeriod" match="PrivateKeyUsagePeriod">
	    
	<!--    -->
    <xsl:for-each select="./notBefore">  
    	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PrivateKeyUsagePeriod_notBefore</xsl:with-param> </xsl:call-template>               <!--  -->
	<xsl:call-template name="GeneralizedTime"/>
    </xsl:for-each>
    
	<!--    -->
    <xsl:for-each select="./notAfter">  
      	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PrivateKeyUsagePeriod_notAfter</xsl:with-param> </xsl:call-template>		<!--  -->
	<xsl:call-template name="GeneralizedTime"/>
    </xsl:for-each>
</xsl:template>

<xsl:template match="GeneralNames" name="GeneralNames">
   <xsl:for-each select=".">
     <xsl:text>

     </xsl:text>
     <xsl:call-template name="GeneralName"/>
   </xsl:for-each>
</xsl:template>


	<!--  CRLReason -->
<xsl:template match="CRLReason" name="CRLReason">
	<xsl:choose>

			<!--  unspecified -->			
		<xsl:when test="count(unspecified) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CRLReason_unspecified</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--  keyCompromise -->	
		<xsl:when test="count(keyCompromise) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CRLReason_keyCompromise</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--   cACompromise-->	
		<xsl:when test="count(cACompromise) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CRLReason_cACompromise</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--  affiliationChanged -->	
		<xsl:when test="count(affiliationChanged) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CRLReason_affiliationChanged</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--  superseded -->	
		<xsl:when test="count(superseded) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CRLReason_superseded</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--  cessationOfOperation -->	
		<xsl:when test="count(cessationOfOperation) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CRLReason_cessationOfOperation</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--  certificateHold -->	
		<xsl:when test="count(certificateHold) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CRLReason_certificateHold</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--  removeFromCRL -->	
		<xsl:when test="count(removeFromCRL) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CRLReason_removeFromCRL</xsl:with-param> </xsl:call-template>
		</xsl:when>


	</xsl:choose>
</xsl:template>	


<xsl:template match="HoldInstruction" name="HoldInstruction">
     <xsl:call-template name="printOID"/>
</xsl:template>

<xsl:template match="InvalidityDate" name="InvalidityDate">
     <xsl:call-template name="GeneralizedTime"/>
</xsl:template>


<xsl:template match="CRLDistPointsSyntax" name="CRLDistPointsSyntax">
   <xsl:for-each select="./*">
	<xsl:call-template name="DistributionPoint"/>
   </xsl:for-each>
</xsl:template>

<!--^-->
<xsl:template match="DistributionPoint" name="DistributionPoint">
   <xsl:for-each select="./distributionPoint">
	<xsl:call-template name="DistributionPointName"/>
   </xsl:for-each>

   <xsl:for-each select="./reasons">
	<xsl:call-template name="ReasonFlags"/>
   </xsl:for-each>

   <xsl:for-each select="./cRLIssuer">
	<xsl:call-template name="GeneralNames"/>
   </xsl:for-each>

</xsl:template>

<!--^-->
<xsl:template match="DistributionPointName" name="DistributionPointName">
   <xsl:for-each select="./fullName">
	<xsl:call-template name="GeneralNames"/>
   </xsl:for-each>

   <xsl:for-each select="./nameRelativeToCRLIssuer">
	<xsl:call-template name="RelativeDistinguishedName"/>
   </xsl:for-each>
</xsl:template>



<xsl:template match="IssuingDistPointSyntax" name="IssuingDistPointSyntax">
   <xsl:for-each select="./distributionPoint">
	<xsl:call-template name="DistributionPointName"/>
   </xsl:for-each>

   <xsl:for-each select="./onlyContainsUserCerts/true">
        <xsl:text> </xsl:text>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_IssuingDistPointSyntax_onlyContainsUserCerts_true</xsl:with-param> </xsl:call-template>
   </xsl:for-each>

   <xsl:for-each select="./onlyContainsCACerts/true">
        <xsl:text> </xsl:text>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_IssuingDistPointSyntax_onlyContainsCACerts_true</xsl:with-param> </xsl:call-template>
   </xsl:for-each>

   <xsl:for-each select="./indirectCRL/true">
        <xsl:text> </xsl:text>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_IssuingDistPointSyntax_indirectCRL_true</xsl:with-param> </xsl:call-template>
   </xsl:for-each>

   <xsl:for-each select="./onlySomeReasons">
        <xsl:text> </xsl:text>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_IssuingDistPointSyntax_onlySomeReasons_true</xsl:with-param> </xsl:call-template>
	<xsl:value-of select="."/>
	<xsl:call-template name="ReasonFlags"/>
   </xsl:for-each>


</xsl:template>


<xsl:template match="CertificateIssuer" name="CertificateIssuer">
     <xsl:call-template name="GeneralNames"/>
</xsl:template>

<xsl:template match="CertificatePoliciesSyntax" name="CertificatePoliciesSyntax">
   <xsl:for-each select="./*">
     <xsl:call-template name="PolicyInformation"/>
   </xsl:for-each>
</xsl:template>


<xsl:template match="PolicyInformation" name="PolicyInformation">
    <fo:block padding="0pt"  margin="0pt">
        <xsl:text>[</xsl:text><xsl:value-of select="position()"/><xsl:text>]</xsl:text>

	<xsl:for-each select="./policyIdentifier">  
		<xsl:call-template name="CertPolicyId"/>
	</xsl:for-each>

    </fo:block>
    <fo:block padding="0pt"  margin-left="20pt">

	<xsl:for-each select="./policyQualifiers/*">  
		<xsl:sort select="position()" data-type="number"/>
		<xsl:call-template name="PolicyQualifierInfo"/>
	</xsl:for-each>

    </fo:block>
</xsl:template>


<!--^-->
<xsl:template match="PolicyQualifierInfo" name="PolicyQualifierInfo">
    <fo:block padding="0pt"  margin="0pt">

	<!--  -->
        <xsl:text>[</xsl:text><xsl:value-of select="position()"/><xsl:text>]</xsl:text>
        <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PolicyQualifierInfo_policyQualifierId</xsl:with-param> </xsl:call-template>


	<xsl:for-each select="./policyQualifierId">  
		<xsl:call-template name="CERT-POLICY-QUALIFIER"/>
	</xsl:for-each>

    </fo:block>
    <fo:block padding="0pt"  margin="0pt">
        <fo:block padding="0pt" margin-left="20pt">

	<xsl:for-each select="./qualifier">  
		<xsl:call-template name="CERT-POLICY-QUALIFIER"/>
	</xsl:for-each>

        </fo:block>
    </fo:block>
</xsl:template>


<!--^-->
<xsl:template match="CERT-POLICY-QUALIFIER" name="CERT-POLICY-QUALIFIER">
    <xsl:call-template name="printOID"/>
</xsl:template>




<xsl:template match="PolicyMappingsSyntax" name="PolicyMappingsSyntax">
   <xsl:for-each select="./*">
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PolicyMappingsSyntax_header</xsl:with-param> </xsl:call-template>
         	
      <fo:block font-family="Courier New" font-size="10pt"
	border-style="solid"
	padding="3pt"
	>

	<xsl:for-each select="./issuerDomainPolicy">
	   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PolicyMappingsSyntax_issuerDomainPolicy</xsl:with-param> </xsl:call-template>
           <xsl:call-template name="CertPolicyId"/>
   	</xsl:for-each>

	<xsl:for-each select="./subjectDomainPolicy">
	   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PolicyMappingsSyntax_subjectDomainPolicy</xsl:with-param> </xsl:call-template>
    	   <xsl:call-template name="CertPolicyId"/>
   	</xsl:for-each>
      </fo:block>
   </xsl:for-each>

</xsl:template>

<xsl:template match="AttributesSyntax" name="AttributesSyntax">
   <xsl:for-each select="./*">
     <xsl:call-template name="Attribute"/>
   </xsl:for-each>
</xsl:template>

<xsl:template match="BasicConstraintsSyntax" name="BasicConstraintsSyntax">
   <xsl:for-each select="./cA/true">
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_cert_cent</xsl:with-param> </xsl:call-template>
   </xsl:for-each>
   <xsl:for-each select="./pathLenConstraint">
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicConstraintsSyntax_pathLenConstraint</xsl:with-param> </xsl:call-template>
	=
      <xsl:value-of select="."/>
   </xsl:for-each>

</xsl:template>

<xsl:template match="NameConstraintsSyntax" name="NameConstraintsSyntax">
   <xsl:for-each select="./permittedSubtrees">

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_NameConstraintsSyntax_permittedSubtrees</xsl:with-param> </xsl:call-template>

         	
      <fo:block font-family="Courier New" font-size="10pt"
	border-style="solid"
	padding="3pt"
	>
	<xsl:call-template name="GeneralSubtrees"/>
      </fo:block>
   </xsl:for-each>

   <xsl:for-each select="./excludedSubtrees">
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_NameConstraintsSyntax_excludedSubtrees</xsl:with-param> </xsl:call-template>

         	
      <fo:block font-family="Courier New" font-size="10pt"
	border-style="solid"
	padding="3pt"
	>
	<xsl:call-template name="GeneralSubtrees"/>
      </fo:block>
   </xsl:for-each>

   <xsl:for-each select="./requiredNameForms">
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_NameConstraintsSyntax_requiredNameForms</xsl:with-param> </xsl:call-template>
         	
      <fo:block font-family="Courier New" font-size="10pt"
	border-style="solid"
	padding="3pt"
	>
	<xsl:call-template name="NameForms"/>
      </fo:block>
   </xsl:for-each>
</xsl:template>

<xsl:template match="GeneralSubtrees" name="GeneralSubtrees">
   <xsl:for-each select="./*">
     <xsl:call-template name="GeneralSubtree"/>
   </xsl:for-each>
</xsl:template>

<xsl:template match="GeneralSubtree" name="GeneralSubtree">
   <xsl:for-each select="./base">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralSubtree_base</xsl:with-param> </xsl:call-template>
     <xsl:call-template name="GeneralName"/>
   </xsl:for-each> <xsl:text>
   </xsl:text>

   <xsl:for-each select="./minimum">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralSubtree_minimum</xsl:with-param> </xsl:call-template>
	=
     <xsl:call-template name="BaseDistance"/>
   </xsl:for-each> <xsl:text>
   </xsl:text>

   <xsl:for-each select="./maximum">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralSubtree_maximum</xsl:with-param> </xsl:call-template>
	=
     <xsl:call-template name="BaseDistance"/>
   </xsl:for-each>

</xsl:template>

<xsl:template match="BaseDistance" name="BaseDistance">
     <xsl:value-of select="."/>
</xsl:template>



<xsl:template match="NameForms" name="NameForms">
   <xsl:for-each select="./basicNameForms">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_NameForms_basicNameForms</xsl:with-param> </xsl:call-template>
     <xsl:call-template name="BasicNameForms"/>
   </xsl:for-each> <xsl:text>
   </xsl:text>

   <xsl:for-each select="./otherNameForms">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_NameForms_otherNameForms</xsl:with-param> </xsl:call-template>
     <xsl:for-each select="./*">
	<xsl:text> </xsl:text>
	<xsl:call-template name="printOID"/>	
     </xsl:for-each>
   </xsl:for-each> 

</xsl:template>

<xsl:template match="BasicNameForms" name="BasicNameForms">
  <xsl:value-of select="."/> <xsl:text> </xsl:text>
  <xsl:if test='substring(.,1,1) = 1'>

	<!-- rfc822Name -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicNameForms_rfc822Name</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,2,1) = 1'>

	<!-- dNSName -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicNameForms_dNSName</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,3,1) = 1'>

	<!-- x400Address -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicNameForms_x400Address</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,4,1) = 1'>

	<!-- directoryName -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicNameForms_directoryName</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,5,1) = 1'>

	<!-- ediPartyName -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicNameForms_ediPartyName</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,6,1) = 1'>

	<!-- uniformResourceIdentifier -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicNameForms_uniformResourceIdentifier</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,7,1) = 1'>

	<!-- iPAddress -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicNameForms_iPAddress</xsl:with-param> </xsl:call-template>
  </xsl:if>
  <xsl:if test='substring(.,8,1) = 1'>

	<!-- registeredID -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicNameForms_registeredID</xsl:with-param> </xsl:call-template>
  </xsl:if>
</xsl:template>


<xsl:template match="PolicyConstraintsSyntax" name="PolicyConstraintsSyntax">
   <xsl:for-each select="./requireExplicitPolicy">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PolicyConstraintsSyntax_requireExplicitPolicy</xsl:with-param> </xsl:call-template>
	=
     <xsl:call-template name="SkipCerts"/>
   </xsl:for-each>
   <xsl:for-each select="./inhibitPolicyMapping">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PolicyConstraintsSyntax_inhibitPolicyMapping</xsl:with-param> </xsl:call-template>
	=
     <xsl:call-template name="SkipCerts"/>
   </xsl:for-each>

</xsl:template>

<xsl:template match="SkipCerts" name="SkipCerts">
   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SkipCerts_header</xsl:with-param> </xsl:call-template>
   <xsl:text> </xsl:text>
   <xsl:value-of select="."/>
   <xsl:text> </xsl:text>
   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SkipCerts_footer</xsl:with-param> </xsl:call-template>
</xsl:template>


<xsl:template match="CRLNumber" name="CRLNumber">
   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CRLNumber_header</xsl:with-param> </xsl:call-template>
	=
   <xsl:value-of select="."/>
</xsl:template>

<xsl:template match="BaseCRLNumber" name="BaseCRLNumber">
     <xsl:call-template name="CRLNumber"/>
</xsl:template>

<!--   AltName: -->

<xsl:template match="directoryName">
  <!-- directoryName    -->
    <fo:block>
<!--   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_directoryName</xsl:with-param> </xsl:call-template>-->

   <xsl:for-each select="./rdnSequence">  
<xsl:call-template name="RNDSequence"/>
   </xsl:for-each>
<!--	<xsl:apply-templates/> -->
    </fo:block>
</xsl:template>

<xsl:template match="otherName">
    <fo:block>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_otherName</xsl:with-param> </xsl:call-template>
   	<xsl:for-each select="./type_id">
          <xsl:call-template name="printOID"/>	
        </xsl:for-each><xsl:text>=</xsl:text>
        <xsl:value-of select="./value"/>  
    </fo:block>
</xsl:template>

<xsl:template match="rfc822Name">
    <fo:block>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_rfc822Name</xsl:with-param> </xsl:call-template>
	<xsl:apply-templates/>
    </fo:block>
</xsl:template>

<xsl:template match="x400Address">
    <fo:block>
	<xsl:variable name="result">
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_x400Address</xsl:with-param> </xsl:call-template>
	    <xsl:apply-templates/>
	</xsl:variable>

	<xsl:call-template name="split">
	    <xsl:with-param name="val" select="$result"/>
	</xsl:call-template>
    </fo:block>
</xsl:template>
	<xsl:template match="country_name">
	  <xsl:text>/C=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="administration_domain_name">
	  <xsl:text>/ADMD=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="network_address">
	  <xsl:text>/X121=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="terminal_identifier">
	  <xsl:text>/T-ID=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="numeric_user_identifier">
	  <xsl:text>/NU-ID=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="private_domain_name">
	  <xsl:text>/PRMD=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="organization_name">
	  <xsl:text>/O=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="surname">
	  <xsl:text>/S=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="given_name">
	  <xsl:text>/G=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="initials">
	  <xsl:text>/I=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="generation_qualifier">
	  <xsl:text>/GQ=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="OrganizationalUnitName">
	  <xsl:text>/OU=</xsl:text>
	  <xsl:apply-templates/>
	  <xsl:text> </xsl:text>
	</xsl:template>
	<xsl:template match="BuiltInDomainDefinedAttribute">
	  <xsl:text>/</xsl:text>
	  <xsl:apply-templates select="type"/>
	  <xsl:text>=</xsl:text>
	  <xsl:apply-templates select="value"/>
	  <xsl:text> </xsl:text>
	</xsl:template>

<xsl:template match="dNSName">
    <fo:block>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_dNSName</xsl:with-param> </xsl:call-template>
	<xsl:apply-templates/>
    </fo:block>
</xsl:template>

<xsl:template match="ediPartyName">
    <fo:block>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_ediPartyName</xsl:with-param> </xsl:call-template>
	<xsl:apply-templates/>
    </fo:block>
</xsl:template>
	<xsl:template match="nameAssigner">
	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_ediPartyNameAssigner</xsl:with-param> </xsl:call-template>
	  <xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="partyName">
	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_ediPartyNameName</xsl:with-param> </xsl:call-template>
	  <xsl:apply-templates/>
	</xsl:template>

<xsl:template match="uniformResourceIdentifier">
    <fo:block>
	<xsl:variable name="result">
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_uri</xsl:with-param> </xsl:call-template>
	    <xsl:apply-templates/>
	</xsl:variable>

	<xsl:call-template name="split">
	    <xsl:with-param name="val" select="$result"/>
	</xsl:call-template>
    </fo:block>
</xsl:template>

<xsl:template match="iPAddress">
    <fo:block>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_iPAddress</xsl:with-param> </xsl:call-template>
	<xsl:apply-templates/>
    </fo:block>
</xsl:template>

<xsl:template match="registeredID">
    <fo:block>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_GeneralName_registeredID</xsl:with-param> </xsl:call-template>
	<xsl:apply-templates/>
    </fo:block>
</xsl:template>

<!--   AltName: -->

<xsl:template match="CrlID">
  <xsl:apply-templates/>
</xsl:template>


<xsl:template match="crlTime">
  <xsl:for-each select=".">
    <!-- <xsl:value-of select="."/> -->
      <xsl:call-template name="GeneralizedTime"/>
  </xsl:for-each>
</xsl:template>

</xsl:stylesheet>