<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>


<xsl:template match="TimeStampResp" name="TimeStampResp">

	
    <!-- Header   -->

  <fo:static-content flow-name="xsl-region-before">
    <fo:block>
    </fo:block>
  </fo:static-content>



      <!-- Footer -->

  <fo:static-content flow-name="xsl-region-after">
    <fo:block text-align="center" font-size="10pt" 	
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_paper</xsl:with-param> </xsl:call-template>			<!--  -->
      <fo:page-number/>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_of</xsl:with-param> </xsl:call-template>
      <fo:page-number-citation ref-id="end of certificate"/>
    </fo:block>
  </fo:static-content>





	<!--   -->

		<!--   -->

  <fo:flow flow-name="xsl-region-body">
    <fo:block text-align="center"
	      font-family="Arial" font-size="14pt"
	      space-before="32pt"			
	      space-after="16pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TimeStampResp_header</xsl:with-param> </xsl:call-template>		<!--  -->
    </fo:block>


    <!--     -->	  
    <xsl:call-template name="uc_title"/>





    <!--   /   . . -->
	

	<!--   PKIStatusInfo -->

    <xsl:for-each select="./status">  
	<xsl:call-template name="PKIStatusInfo"/>
    </xsl:for-each>

	<!--   TimeStampToken -->

      <xsl:for-each select="./timeStampToken">  
	<xsl:call-template name="TimeStampToken"/>
      </xsl:for-each>


    <fo:block id="end of certificate">
    </fo:block>
  </fo:flow>
</xsl:template>


<xsl:template match="TimeStampToken" name="TimeStampToken">


      <xsl:variable name="Content">TSTInfo.xml</xsl:variable>
      
      <xsl:for-each select=".">  
	<xsl:call-template name="ContentInfo">
	   <xsl:with-param name="Content" select="$Content"/>
	</xsl:call-template>
      </xsl:for-each>
</xsl:template>




	<!--     -->	
<xsl:template match="TSTInfo" name="TSTInfo">

<xsl:value-of select="$Content"/>

	<!-->   <-->
    <fo:block text-align="center"
	      font-family="Arial" font-size="14pt"
	      space-before="32pt"			
	      space-after="16pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
              keep-with-next="always"
	      >

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TSTInfo_header</xsl:with-param> </xsl:call-template>
    </fo:block>





    <!--   -->	
     <xsl:for-each select="./version">  
	<xsl:call-template name="INTVersion"/>
    </xsl:for-each>


    <!--   -->	
     <xsl:for-each select="./policy">  
	<xsl:call-template name="TSAPolicyId"/>
    </xsl:for-each>

	<!--   MessageImprint -->
     <xsl:for-each select="./messageImprint">  
	<xsl:call-template name="MessageImprint"/>
    </xsl:for-each>



    <!--    -->	
     <xsl:for-each select="./serialNumber">  
		<!--   : -->
	<fo:block font-family="Times" font-size="10pt"                        
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TSTInfo_serialNumber</xsl:with-param> </xsl:call-template>					<!--  -->
	</fo:block>

	    <!--    -->	
	<fo:block font-family="Courier New" font-size="10pt"                      
	    border-style="solid"
	    padding="3pt"
	    >

	    <xsl:value-of select="."/>
	 </fo:block>

    </xsl:for-each>


	<!--    -->

        <!--    -->	
    <fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TSTInfo_genTime</xsl:with-param> </xsl:call-template>			<!--  -->

         <!--   -->
    </fo:block>

    <fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    padding="3pt"
	    border-style="solid"
	    >

     <xsl:for-each select="./genTime">  
	<xsl:call-template name="GeneralizedTime"/>
    </xsl:for-each>
    </fo:block>


	<!--   -->
     <xsl:for-each select="./accuracy">  
	<xsl:call-template name="Accuracy"/>
    </xsl:for-each>
	

    <!--   -->	
    <fo:block text-align="left"
	      font-family="Arial" font-size="10pt"
	      space-before="4pt"			
	      space-after="2pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >                                                         <!--  -->

       <xsl:variable name="tst"> 
	   <xsl:value-of select="./ordering"/> 
       </xsl:variable>

       <xsl:choose>
	   <xsl:when test="count(./ordering/true) &gt; 0">
	       <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TSTInfo_ordering_true</xsl:with-param> </xsl:call-template>              <!--  -->
	   </xsl:when>
	   <xsl:otherwise>
	       <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TSTInfo_ordering_false</xsl:with-param> </xsl:call-template>             <!--  -->
	   </xsl:otherwise>
       </xsl:choose>
    </fo:block>

    <!--    -->	
     <xsl:for-each select="./nonce">  
	<xsl:call-template name="Nonce"/>
    </xsl:for-each>


        <!--  TSA -->	
     <fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TSTInfo_tsa</xsl:with-param> </xsl:call-template>			<!--  -->

         <!--   -->
     </fo:block>

    <fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    padding="3pt"
	    border-style="solid"
	    >

     <xsl:for-each select="./tsa">  
	<xsl:call-template name="GeneralName"/>
    </xsl:for-each>
    </fo:block>


	<!--   -->
     <xsl:for-each select="./extensions">  
	<xsl:call-template name="Extensions"/>
    </xsl:for-each>

</xsl:template>


</xsl:stylesheet>


