/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
#ifdef _WIN32
    #pragma setlocale("rus")
#endif
/*
 * Copyright(C) 2011-2014 -, 
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 */

#pragma once
#ifndef CAdES_cppcades_CPPCadesContent_h_
#define CAdES_cppcades_CPPCadesContent_h_

#include "cplib/Blob.h"
#include "boost/shared_ptr.hpp"

class CCadesContent
{
public:
    CCadesContent() :
        m_contentEncoding(CADESCOM_STRING_TO_UCS2LE) { };
public:
#ifndef UNIX
    //   IE:    
    //  BSTR / CComBSTR
    HRESULT SetContent(const BSTR content);
    HRESULT GetContent(CComBSTR& content);
#endif
    //  ;    
    //   
    //     NPAPI
    HRESULT SetContent(LPCSTR pbData, DWORD cbData);

    //   ,   
    //      CadesVerifyMessage
    //  ,          
    HRESULT SetRawContent(PCRYPT_DATA_BLOB pContent);

    //   
    HRESULT GetContent(CStringBlob& pVal);

    //     
    //  : CADESCOM_STRING_TO_UCS2LE
    HRESULT put_ContentEncoding(CADESCOM_CONTENT_ENCODING_TYPE encoding);
    HRESULT get_ContentEncoding(CADESCOM_CONTENT_ENCODING_TYPE* pVal);

    //        
    const BYTE* pbData() const;
    DWORD cbData() const;

    //      CStringBlob  CStringBlob
    LPSTR GetBuffer(int nMinBufferLength);
    void ReleaseBufferSetLength(int nNewLength);
    void Empty();

    bool IsEmpty();
private:
    DISALLOW_COPY_AND_ASSIGN(CCadesContent);
    CStringBlob m_content;
    CADESCOM_CONTENT_ENCODING_TYPE m_contentEncoding;
};

#endif // CAdES_cppcades_CPPCadesContent_h_
