%define has_dpkg %(which dpkg >/dev/null 2>&1 && echo 1||echo 0)
%define has_rpm %(which rpm >/dev/null 2>&1 && echo 1||echo 0)

%if %{!?kernel_release:1}%{?kernel_release:0}
%define kernel_release %(uname -r)
%endif
%if %{!?use_depmod:1}%{?use_depmod:0}
%define use_depmod 1
%endif

%if %{!?verbose_build:1}%{?verbose_build:0}
%define verbose_build 0
%endif

%if %verbose_build
%define build_drv() MAKE_VARS="V=1" bash -x build_drv.sh %{kernel_name} 
%else
%define build_drv() bash build_drv.sh %{kernel_name} 
%endif

%define debug_package %{nil}
%define is_altlinux %(test -e /etc/altlinux-release && cat /etc/altlinux-release |grep -v 4.0 > /dev/null && echo 1 || echo 0)
%if %is_altlinux
%brp_strip_none *
%add_verify_elf_skiplist /lib/modules/%{kernel_release}/kernel/crypto/*.ko

%if %{?add_debuginfo_skiplist:1}%{!?add_debuginfo_skiplist:0}
%add_debuginfo_skiplist /lib/modules/%{kernel_release}/kernel/crypto/*.ko
%endif
%else
%define __spec_install_post /usr/lib/rpm/brp-compress /usr/lib/rpm/brp-strip-comment-note %{nil}
%endif
License: Crypto-Pro
Version: 5.0.13000
Release: 7
URL: http://www.cryptopro.ru/
Packager: CryptoPro Ltd. <support@cryptopro.ru>
%if %{!?kernel_name:1}%{?kernel_name:0}
%define kernel_name %{kernel_release}
%endif
%define def_log_error log_error()\{ logger "$*";echo "$*">&2; \}
%define depmod_errmsg() "ERROR: uninstall %1: depmod -a failed. Please reboot and try to run it manually"

%if %has_rpm
%if %has_dpkg
%define check_pkg() set +x;if dpkg -l %1 >/dev/null || rpm -qi %1 >/dev/null ;then echo "%1 ok";else echo "Build requires %1 (not installed)";exit 1;fi;set -x;
%else
%define check_pkg() set +x;if rpm -qi %1 >/dev/null ;then echo "%1 ok";else echo "Build requires %1 (not installed)";exit 1;fi;set -x;
%endif
%else
%define check_pkg() set +x;if dpkg -l %1 >/dev/null ;then echo "%1 ok";else echo "Build requires %1 (not installed)";exit 1;fi;set -x;
%endif
%define check_cpverify() set +x;CPV=/opt/cprocsp/bin/amd64/cpverify;HASH=`$CPV -mk $CPV`;if test $? = 0 && $CPV $CPV $HASH >/dev/null;then echo "$CPV is ok (hash $HASH)";else echo "$CPV is bugged";exit 1;fi;set -x;
%define csp_mod_dir /lib/modules/%{kernel_release}/kernel/crypto
Summary: LKM for linux. Build 13000.
Name: cprocsp-drv-64-%{kernel_release}
BuildRoot: %{_tmppath}/%{name}-root
Group: Development/Libraries
Requires: lsb-cprocsp-rdr-64 >= 5.0, lsb-cprocsp-rdr-64 < 6.0
# BuildRequires: lsb-cprocsp-rdr-64 >= 5.0, lsb-cprocsp-rdr-64 < 6.0, lsb-cprocsp-devel >= 5.0, lsb-cprocsp-devel < 6.0, cprocsp-drv-devel >= 5.0, cprocsp-drv-devel < 6.0
Source: cprocsp-drv-64.src.tar.gz

%prep
%setup -q -c

%description

This is Loadable Kernel Module for linux.

%build
%check_pkg lsb-cprocsp-devel
%check_pkg cprocsp-drv-devel
%check_pkg lsb-cprocsp-rdr-64
%check_cpverify
%build_drv

%install
rm -rf ${RPM_BUILD_ROOT}
mod_dir=%{csp_mod_dir}
hash_dir=/opt/cprocsp/lib/hashes
mkdir -p $RPM_BUILD_ROOT/$mod_dir
mkdir -p $RPM_BUILD_ROOT/$hash_dir
hash_name=cprocsp-drv-64-%{kernel_release}
if test -f drvcsp.ko; then 
  install -m644 drvcsp.ko $RPM_BUILD_ROOT/$mod_dir
  mod_path=$mod_dir/drvcsp.ko
else
  install -m644 drvcsp.o $RPM_BUILD_ROOT/$mod_dir
  mod_path=$mod_dir/drvcsp.o
fi
echo "/$mod_path `/opt/cprocsp/bin/amd64/cpverify -mk -alg GR3411_2012_256 $RPM_BUILD_ROOT/$mod_path`" >$hash_name
install -m 644 $hash_name $RPM_BUILD_ROOT/$hash_dir

%clean
rm -rf ${RPM_BUILD_ROOT}

%pre
ALTLINUX_DEPS_WORKAROUND=/etc/init.d/cprocsp; $ALTLINUX_DEPS_WORKAROUND stop_check force
mkdir -p %{csp_mod_dir}

%post
%if %use_depmod
/sbin/depmod -a
%endif

%preun
#rm /lib/modules/`uname -r`/kernel/drivers/crypto/drvcsp.ko
/sbin/modprobe -r drvcsp
%if %use_depmod
%def_log_error
%define drvcsp_errmsg %depmod_errmsg drvcsp.ko
/sbin/depmod -a || log_error %drvcsp_errmsg
%endif

%files
%defattr(-,root,root,0755)
%{csp_mod_dir}/*
/opt/cprocsp/lib/hashes/*
